/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.collision.narrowphase.FallbackCondition;
import org.dyn4j.collision.narrowphase.TypedFallbackCondition;
import org.dyn4j.geometry.Convex;

public class PairwiseTypedFallbackCondition
extends TypedFallbackCondition
implements FallbackCondition,
Comparable<FallbackCondition> {
    private final Class<? extends Convex> type1;
    private final boolean strict1;
    private final Class<? extends Convex> type2;
    private final boolean strict2;

    public PairwiseTypedFallbackCondition(Class<? extends Convex> type1, Class<? extends Convex> type2) {
        this(type1, true, type2, true, 0);
    }

    public PairwiseTypedFallbackCondition(Class<? extends Convex> type1, Class<? extends Convex> type2, int sortIndex) {
        this(type1, true, type2, true, sortIndex);
    }

    public PairwiseTypedFallbackCondition(Class<? extends Convex> type1, Class<? extends Convex> type2, boolean strict) {
        this(type1, strict, type2, strict, 0);
    }

    public PairwiseTypedFallbackCondition(Class<? extends Convex> type1, Class<? extends Convex> type2, boolean strict, int sortIndex) {
        this(type1, strict, type2, strict, sortIndex);
    }

    public PairwiseTypedFallbackCondition(Class<? extends Convex> type1, boolean strict1, Class<? extends Convex> type2, boolean strict2) {
        this(type1, strict1, type2, strict2, 0);
    }

    public PairwiseTypedFallbackCondition(Class<? extends Convex> type1, boolean strict1, Class<? extends Convex> type2, boolean strict2, int sortIndex) {
        super(sortIndex);
        this.type1 = type1;
        this.strict1 = strict1;
        this.type2 = type2;
        this.strict2 = strict2;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.strict1 ? 1231 : 1237);
        result = 31 * result + (this.strict2 ? 1231 : 1237);
        result = 31 * result + (this.type1 == null ? 0 : this.type1.hashCode());
        result = 31 * result + (this.type2 == null ? 0 : this.type2.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof PairwiseTypedFallbackCondition) {
            PairwiseTypedFallbackCondition pfc = (PairwiseTypedFallbackCondition)obj;
            if ((pfc.type1 == this.type1 && pfc.type2 == this.type2 || pfc.type1 == this.type2 && pfc.type2 == this.type1) && pfc.strict1 == this.strict1 && pfc.strict2 == this.strict2 && pfc.sortIndex == this.sortIndex) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PairwiseTypedFallbackCondition[").append("Type1=").append(this.type1.getName()).append("|IsStrict1=").append(this.strict1).append("|Type2=").append(this.type2.getName()).append("|IsStrict2=").append(this.strict2).append("]");
        return sb.toString();
    }

    @Override
    public boolean isMatch(Class<? extends Convex> type1, Class<? extends Convex> type2) {
        if (this.strict1) {
            if (this.strict2) {
                return this.type1 == type1 && this.type2 == type2 || this.type1 == type2 && this.type2 == type1;
            }
            return this.type1 == type1 && this.type2.isAssignableFrom(type2) || this.type1 == type2 && this.type2.isAssignableFrom(type1);
        }
        if (this.strict2) {
            return this.type1.isAssignableFrom(type1) && this.type2 == type2 || this.type1.isAssignableFrom(type2) && this.type2 == type1;
        }
        return this.type1.isAssignableFrom(type1) && this.type2.isAssignableFrom(type2) || this.type1.isAssignableFrom(type2) && this.type2.isAssignableFrom(type1);
    }

    public Class<? extends Convex> getType1() {
        return this.type1;
    }

    public Class<? extends Convex> getType2() {
        return this.type2;
    }

    public boolean isStrict1() {
        return this.strict1;
    }

    public boolean isStrict2() {
        return this.strict2;
    }
}

