/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.collision.narrowphase.CircleDetector;
import org.dyn4j.collision.narrowphase.NarrowphaseDetector;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.geometry.Circle;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class Sat
implements NarrowphaseDetector {
    @Override
    public boolean detect(Convex convex1, Transform transform1, Convex convex2, Transform transform2, Penetration penetration) {
        Vector2 c2;
        Vector2 c1;
        Vector2 cToc;
        double min;
        double max;
        double o;
        Interval intervalB;
        Interval intervalA;
        Vector2 axis;
        int i;
        int size;
        if (convex1 instanceof Circle && convex2 instanceof Circle) {
            return CircleDetector.detect((Circle)convex1, transform1, (Circle)convex2, transform2, penetration);
        }
        penetration.clear();
        Vector2 n = null;
        double overlap = Double.MAX_VALUE;
        Vector2[] foci1 = convex1.getFoci(transform1);
        Vector2[] foci2 = convex2.getFoci(transform2);
        Vector2[] axes1 = convex1.getAxes(foci2, transform1);
        Vector2[] axes2 = convex2.getAxes(foci1, transform2);
        if (axes1 != null) {
            size = axes1.length;
            i = 0;
            while (i < size) {
                axis = axes1[i];
                if (!axis.isZero()) {
                    intervalA = convex1.project(axis, transform1);
                    if (!intervalA.overlaps(intervalB = convex2.project(axis, transform2))) {
                        return false;
                    }
                    o = intervalA.getOverlap(intervalB);
                    if (intervalA.contains(intervalB) || intervalB.contains(intervalA)) {
                        max = Math.abs(intervalA.getMax() - intervalB.getMax());
                        if (max > (min = Math.abs(intervalA.getMin() - intervalB.getMin()))) {
                            axis.negate();
                            o += min;
                        } else {
                            o += max;
                        }
                    }
                    if (o < overlap) {
                        overlap = o;
                        n = axis;
                    }
                }
                ++i;
            }
        }
        if (axes2 != null) {
            size = axes2.length;
            i = 0;
            while (i < size) {
                axis = axes2[i];
                if (!axis.isZero()) {
                    intervalA = convex1.project(axis, transform1);
                    if (!intervalA.overlaps(intervalB = convex2.project(axis, transform2))) {
                        return false;
                    }
                    o = intervalA.getOverlap(intervalB);
                    if (intervalA.contains(intervalB) || intervalB.contains(intervalA)) {
                        max = Math.abs(intervalA.getMax() - intervalB.getMax());
                        if (max > (min = Math.abs(intervalA.getMin() - intervalB.getMin()))) {
                            axis.negate();
                            o += min;
                        } else {
                            o += max;
                        }
                    }
                    if (o < overlap) {
                        overlap = o;
                        n = axis;
                    }
                }
                ++i;
            }
        }
        if ((cToc = (c1 = transform1.getTransformed(convex1.getCenter())).to(c2 = transform2.getTransformed(convex2.getCenter()))).dot(n) < 0.0) {
            n.negate();
        }
        penetration.normal = n;
        penetration.depth = overlap;
        return true;
    }

    @Override
    public boolean detect(Convex convex1, Transform transform1, Convex convex2, Transform transform2) {
        Interval intervalB;
        Interval intervalA;
        Vector2 axis;
        int i;
        int size;
        if (convex1 instanceof Circle && convex2 instanceof Circle) {
            return CircleDetector.detect((Circle)convex1, transform1, (Circle)convex2, transform2);
        }
        Vector2[] foci1 = convex1.getFoci(transform1);
        Vector2[] foci2 = convex2.getFoci(transform2);
        Vector2[] axes1 = convex1.getAxes(foci2, transform1);
        Vector2[] axes2 = convex2.getAxes(foci1, transform2);
        if (axes1 != null) {
            size = axes1.length;
            i = 0;
            while (i < size) {
                axis = axes1[i];
                if (!axis.isZero() && !(intervalA = convex1.project(axis, transform1)).overlaps(intervalB = convex2.project(axis, transform2))) {
                    return false;
                }
                ++i;
            }
        }
        if (axes2 != null) {
            size = axes2.length;
            i = 0;
            while (i < size) {
                axis = axes2[i];
                if (!axis.isZero() && !(intervalA = convex1.project(axis, transform1)).overlaps(intervalB = convex2.project(axis, transform2))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

