/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.collision.narrowphase.FallbackCondition;
import org.dyn4j.collision.narrowphase.TypedFallbackCondition;
import org.dyn4j.geometry.Convex;

public class SingleTypedFallbackCondition
extends TypedFallbackCondition
implements FallbackCondition,
Comparable<FallbackCondition> {
    private final Class<? extends Convex> type;
    private final boolean strict;

    public SingleTypedFallbackCondition(Class<? extends Convex> type) {
        this(type, 0, true);
    }

    public SingleTypedFallbackCondition(Class<? extends Convex> type, int sortIndex) {
        this(type, sortIndex, true);
    }

    public SingleTypedFallbackCondition(Class<? extends Convex> type, boolean strict) {
        this(type, 0, strict);
    }

    public SingleTypedFallbackCondition(Class<? extends Convex> type, int sortIndex, boolean strict) {
        super(sortIndex);
        this.type = type;
        this.strict = strict;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.strict ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof SingleTypedFallbackCondition) {
            SingleTypedFallbackCondition other = (SingleTypedFallbackCondition)obj;
            if (this.strict == other.strict && this.type == other.type && this.sortIndex == other.sortIndex) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SingleTypedFallbackCondition[").append("Type=").append(this.type.getName()).append("|IsStrict=").append(this.strict).append("]");
        return sb.toString();
    }

    @Override
    public boolean isMatch(Class<? extends Convex> type1, Class<? extends Convex> type2) {
        if (this.strict) {
            return this.type == type1 || this.type == type2;
        }
        return this.type.isAssignableFrom(type1) || this.type.isAssignableFrom(type2);
    }

    public Class<? extends Convex> getType() {
        return this.type;
    }

    public boolean isStrict() {
        return this.strict;
    }
}

