/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.collision.AbstractCollidable;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Collisions;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.ContactEdge;
import org.dyn4j.dynamics.Force;
import org.dyn4j.dynamics.JointEdge;
import org.dyn4j.dynamics.Torque;
import org.dyn4j.dynamics.World;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactPoint;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.MassType;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Body
extends AbstractCollidable<BodyFixture>
implements Collidable<BodyFixture>,
Transformable,
DataContainer {
    public static final double DEFAULT_LINEAR_DAMPING = 0.0;
    public static final double DEFAULT_ANGULAR_DAMPING = 0.01;
    private static final int AUTO_SLEEP = 1;
    private static final int ASLEEP = 2;
    private static final int ACTIVE = 4;
    private static final int ISLAND = 8;
    private static final int BULLET = 16;
    protected Mass mass;
    protected Vector2 velocity;
    protected double angularVelocity;
    protected double linearDamping;
    protected double angularDamping;
    protected double gravityScale;
    Transform transform0;
    private int state;
    World world = null;
    double sleepTime;
    Vector2 force;
    double torque;
    final List<Force> forces;
    final List<Torque> torques;
    final List<ContactEdge> contacts;
    final List<JointEdge> joints;

    public Body() {
        this(1);
    }

    public Body(int fixtureCount) {
        super(fixtureCount);
        this.radius = 0.0;
        this.mass = new Mass();
        this.transform0 = new Transform();
        this.velocity = new Vector2();
        this.angularVelocity = 0.0;
        this.force = new Vector2();
        this.torque = 0.0;
        this.forces = new ArrayList<Force>(1);
        this.torques = new ArrayList<Torque>(1);
        this.state = 0;
        this.state |= 1;
        this.state |= 4;
        this.sleepTime = 0.0;
        this.linearDamping = 0.0;
        this.angularDamping = 0.01;
        this.gravityScale = 1.0;
        this.contacts = new ArrayList<ContactEdge>(Collisions.getEstimatedCollisionsPerObject());
        this.joints = new ArrayList<JointEdge>(0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Body[Id=").append(this.id).append("|Fixtures={");
        int size = this.fixtures.size();
        int i = 0;
        while (i < size) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.fixtures.get(i));
            ++i;
        }
        sb.append("}|InitialTransform=").append(this.transform0).append("|Transform=").append(this.transform).append("|RotationDiscRadius=").append(this.radius).append("|Mass=").append(this.mass).append("|Velocity=").append(this.velocity).append("|AngularVelocity=").append(this.angularVelocity).append("|Force=").append(this.force).append("|Torque=").append(this.torque).append("|AccumulatedForce=").append(this.getAccumulatedForce()).append("|AccumulatedTorque=").append(this.getAccumulatedTorque()).append("|IsAutoSleepingEnabled=").append(this.isAutoSleepingEnabled()).append("|IsAsleep=").append(this.isAsleep()).append("|IsActive=").append(this.isActive()).append("|IsBullet=").append(this.isBullet()).append("|LinearDamping=").append(this.linearDamping).append("|AngularDamping").append(this.angularDamping).append("|GravityScale=").append(this.gravityScale).append("]");
        return sb.toString();
    }

    @Override
    public BodyFixture addFixture(Convex convex) {
        return this.addFixture(convex, 1.0, 0.2, 0.0);
    }

    public BodyFixture addFixture(Convex convex, double density) {
        return this.addFixture(convex, density, 0.2, 0.0);
    }

    public BodyFixture addFixture(Convex convex, double density, double friction, double restitution) {
        if (convex == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.addNullShape"));
        }
        BodyFixture fixture = new BodyFixture(convex);
        fixture.setDensity(density);
        fixture.setFriction(friction);
        fixture.setRestitution(restitution);
        this.fixtures.add(fixture);
        if (this.world != null) {
            this.world.broadphaseDetector.add(this, fixture);
        }
        return fixture;
    }

    public Body addFixture(BodyFixture fixture) {
        if (fixture == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.addNullFixture"));
        }
        this.fixtures.add(fixture);
        if (this.world != null) {
            this.world.broadphaseDetector.add(this, fixture);
        }
        return this;
    }

    @Override
    public boolean removeFixture(BodyFixture fixture) {
        if (this.world != null) {
            this.world.broadphaseDetector.remove(this, fixture);
        }
        return super.removeFixture(fixture);
    }

    @Override
    public BodyFixture removeFixture(int index) {
        BodyFixture fixture = (BodyFixture)super.removeFixture(index);
        if (this.world != null) {
            this.world.broadphaseDetector.remove(this, fixture);
        }
        return fixture;
    }

    @Override
    public BodyFixture removeFixture(Vector2 point) {
        BodyFixture fixture = (BodyFixture)super.removeFixture(point);
        if (this.world != null) {
            this.world.broadphaseDetector.remove(this, fixture);
        }
        return fixture;
    }

    @Override
    public List<BodyFixture> removeAllFixtures() {
        List<BodyFixture> fixtures = super.removeAllFixtures();
        int size = fixtures.size();
        if (this.world != null) {
            int i = 0;
            while (i < size) {
                this.world.broadphaseDetector.remove(this, fixtures.get(i));
                ++i;
            }
        }
        return fixtures;
    }

    @Override
    public List<BodyFixture> removeFixtures(Vector2 point) {
        List<BodyFixture> fixtures = super.removeFixtures(point);
        int size = fixtures.size();
        if (this.world != null) {
            int i = 0;
            while (i < size) {
                this.world.broadphaseDetector.remove(this, fixtures.get(i));
                ++i;
            }
        }
        return fixtures;
    }

    @Deprecated
    public Body setMass() {
        return this.setMass(MassType.NORMAL);
    }

    public Body updateMass() {
        return this.setMass(this.mass.getType());
    }

    public Body setMass(MassType type) {
        int size;
        if (type == null) {
            type = this.mass.getType();
        }
        if ((size = this.fixtures.size()) == 0) {
            this.mass = new Mass();
        } else if (size == 1) {
            this.mass = ((BodyFixture)this.fixtures.get(0)).createMass();
        } else {
            ArrayList<Mass> masses = new ArrayList<Mass>(size);
            int i = 0;
            while (i < size) {
                Mass mass = ((BodyFixture)this.fixtures.get(i)).createMass();
                masses.add(mass);
                ++i;
            }
            this.mass = Mass.create(masses);
        }
        this.mass.setType(type);
        this.setRotationDiscRadius();
        return this;
    }

    public Body setMass(Mass mass) {
        if (mass == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullMass"));
        }
        this.mass = mass;
        this.setRotationDiscRadius();
        return this;
    }

    public Body setMassType(MassType type) {
        if (type == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullMassType"));
        }
        this.mass.setType(type);
        return this;
    }

    protected void setRotationDiscRadius() {
        double r = 0.0;
        int size = this.fixtures.size();
        if (size == 0) {
            this.radius = 0.0;
            return;
        }
        Vector2 c = this.mass.getCenter();
        int i = 0;
        while (i < size) {
            BodyFixture fixture = (BodyFixture)this.fixtures.get(i);
            Convex convex = fixture.getShape();
            double cr = convex.getRadius(c);
            r = Math.max(r, cr);
            ++i;
        }
        this.radius = r;
    }

    public Mass getMass() {
        return this.mass;
    }

    public Body applyForce(Vector2 force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullForce"));
        }
        if (this.mass.getMass() == 0.0) {
            return this;
        }
        this.forces.add(new Force(force));
        this.setAsleep(false);
        return this;
    }

    public Body applyForce(Force force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullForce"));
        }
        if (this.mass.getMass() == 0.0) {
            return this;
        }
        this.forces.add(force);
        this.setAsleep(false);
        return this;
    }

    public Body applyTorque(double torque) {
        this.torques.add(new Torque(torque));
        if (this.mass.getInertia() == 0.0) {
            return this;
        }
        this.setAsleep(false);
        return this;
    }

    public Body applyTorque(Torque torque) {
        if (torque == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullTorque"));
        }
        if (this.mass.getInertia() == 0.0) {
            return this;
        }
        this.torques.add(torque);
        this.setAsleep(false);
        return this;
    }

    public Body applyForce(Vector2 force, Vector2 point) {
        Vector2 r;
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullForceForTorque"));
        }
        if (point == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullPointForTorque"));
        }
        boolean awaken = false;
        if (this.mass.getMass() != 0.0) {
            this.forces.add(new Force(force));
            awaken = true;
        }
        if (this.mass.getInertia() != 0.0 && !(r = this.getWorldCenter().to(point)).isZero()) {
            double tao = r.cross(force);
            this.torques.add(new Torque(tao));
            awaken = true;
        }
        if (awaken) {
            this.setAsleep(false);
        }
        return this;
    }

    public Body applyImpulse(Vector2 impulse) {
        if (impulse == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullImpulse"));
        }
        double invM = this.mass.getInverseMass();
        if (invM == 0.0) {
            return this;
        }
        this.velocity.add(impulse.x * invM, impulse.y * invM);
        this.setAsleep(false);
        return this;
    }

    public Body applyImpulse(double impulse) {
        double invI = this.mass.getInverseInertia();
        if (invI == 0.0) {
            return this;
        }
        this.angularVelocity += invI * impulse;
        this.setAsleep(false);
        return this;
    }

    public Body applyImpulse(Vector2 impulse, Vector2 point) {
        if (impulse == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullImpulse"));
        }
        if (point == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullPointForImpulse"));
        }
        boolean awaken = false;
        double invM = this.mass.getInverseMass();
        double invI = this.mass.getInverseInertia();
        if (invM != 0.0) {
            this.velocity.add(impulse.x * invM, impulse.y * invM);
            awaken = true;
        }
        if (invI != 0.0) {
            Vector2 r = this.getWorldCenter().to(point);
            this.angularVelocity += invI * r.cross(impulse);
            awaken = true;
        }
        if (awaken) {
            this.setAsleep(false);
        }
        return this;
    }

    public void clearForce() {
        this.force.zero();
    }

    public void clearAccumulatedForce() {
        this.forces.clear();
    }

    public void clearTorque() {
        this.torque = 0.0;
    }

    public void clearAccumulatedTorque() {
        this.torques.clear();
    }

    void accumulate(double elapsedTime) {
        Iterator<Object> it;
        this.force.zero();
        int size = this.forces.size();
        if (size > 0) {
            it = this.forces.iterator();
            while (it.hasNext()) {
                Force force = it.next();
                this.force.add(force.force);
                if (!force.isComplete(elapsedTime)) continue;
                it.remove();
            }
        }
        this.torque = 0.0;
        size = this.torques.size();
        if (size > 0) {
            it = this.torques.iterator();
            while (it.hasNext()) {
                Torque torque = (Torque)it.next();
                this.torque += torque.torque;
                if (!torque.isComplete(elapsedTime)) continue;
                it.remove();
            }
        }
    }

    public boolean isStatic() {
        return this.mass.isInfinite() && this.velocity.isZero() && Math.abs(this.angularVelocity) <= Epsilon.E;
    }

    public boolean isKinematic() {
        return this.mass.isInfinite() && (!this.velocity.isZero() || Math.abs(this.angularVelocity) > Epsilon.E);
    }

    public boolean isDynamic() {
        return this.mass.getType() != MassType.INFINITE;
    }

    public void setAutoSleepingEnabled(boolean flag) {
        this.state = flag ? (this.state |= 1) : (this.state &= 0xFFFFFFFE);
    }

    public boolean isAutoSleepingEnabled() {
        return (this.state & 1) == 1;
    }

    public boolean isAsleep() {
        return (this.state & 2) == 2;
    }

    public void setAsleep(boolean flag) {
        if (flag) {
            this.state |= 2;
            this.velocity.zero();
            this.angularVelocity = 0.0;
            this.forces.clear();
            this.torques.clear();
        } else if ((this.state & 2) == 2) {
            this.sleepTime = 0.0;
            this.state &= 0xFFFFFFFD;
        }
    }

    public boolean isActive() {
        return (this.state & 4) == 4;
    }

    public void setActive(boolean flag) {
        this.state = flag ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
    }

    boolean isOnIsland() {
        return (this.state & 8) == 8;
    }

    void setOnIsland(boolean flag) {
        this.state = flag ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
    }

    public boolean isBullet() {
        return (this.state & 0x10) == 16;
    }

    public void setBullet(boolean flag) {
        this.state = flag ? (this.state |= 0x10) : (this.state &= 0xFFFFFFEF);
    }

    public boolean isConnected(Body body) {
        if (body == null) {
            return false;
        }
        int size = this.joints.size();
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            JointEdge je = this.joints.get(i);
            if (je.other == body) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isConnected(Body body, boolean collisionAllowed) {
        if (body == null) {
            return false;
        }
        int size = this.joints.size();
        if (size == 0) {
            return false;
        }
        boolean allowed = false;
        boolean connected = false;
        int i = 0;
        while (i < size) {
            JointEdge je = this.joints.get(i);
            if (je.other == body) {
                Joint joint = (Joint)je.interaction;
                connected = true;
                allowed |= joint.isCollisionAllowed();
            }
            ++i;
        }
        if (!connected) {
            return false;
        }
        return allowed == collisionAllowed;
    }

    public boolean isInContact(Body body) {
        if (body == null) {
            return false;
        }
        int size = this.contacts.size();
        if (size == 0) {
            return false;
        }
        int i = 0;
        while (i < size) {
            ContactEdge ce = this.contacts.get(i);
            if (ce.other == body) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Transform getInitialTransform() {
        return this.transform0;
    }

    public AABB createSweptAABB() {
        return this.createSweptAABB(this.transform0, this.transform);
    }

    public AABB createSweptAABB(Transform initialTransform, Transform finalTransform) {
        Vector2 iCenter = initialTransform.getTransformed(this.mass.getCenter());
        Vector2 fCenter = finalTransform.getTransformed(this.mass.getCenter());
        return new AABB(new Vector2(Math.min(iCenter.x, fCenter.x) - this.radius, Math.min(iCenter.y, fCenter.y) - this.radius), new Vector2(Math.max(iCenter.x, fCenter.x) + this.radius, Math.max(iCenter.y, fCenter.y) + this.radius));
    }

    public Vector2 getChangeInPosition() {
        return this.transform.getTranslation().subtract(this.transform0.getTranslation());
    }

    public double getChangeInOrientation() {
        double ri = this.transform0.getRotation();
        double rf = this.transform.getRotation();
        double twopi = Math.PI * 2;
        if (ri < 0.0) {
            ri += Math.PI * 2;
        }
        if (rf < 0.0) {
            rf += Math.PI * 2;
        }
        double r = rf - ri;
        if (rf < ri && this.angularVelocity > 0.0) {
            r += Math.PI * 2;
        }
        if (rf > ri && this.angularVelocity < 0.0) {
            r -= Math.PI * 2;
        }
        return r;
    }

    @Override
    public Vector2 getLocalCenter() {
        return this.mass.getCenter();
    }

    @Override
    public Vector2 getWorldCenter() {
        return this.transform.getTransformed(this.mass.getCenter());
    }

    public Vector2 getLinearVelocity() {
        return this.velocity;
    }

    public Vector2 getLinearVelocity(Vector2 point) {
        Vector2 c = this.getWorldCenter();
        Vector2 r = c.to(point);
        return r.cross(this.angularVelocity).add(this.velocity);
    }

    public void setLinearVelocity(Vector2 velocity) {
        if (velocity == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullVelocity"));
        }
        this.velocity.set(velocity);
    }

    public void setLinearVelocity(double x, double y) {
        this.velocity.x = x;
        this.velocity.y = y;
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(double angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public Vector2 getForce() {
        return this.force.copy();
    }

    public Vector2 getAccumulatedForce() {
        int fSize = this.forces.size();
        Vector2 force = new Vector2();
        int i = 0;
        while (i < fSize) {
            Vector2 tf = this.forces.get((int)i).force;
            force.add(tf);
            ++i;
        }
        return force;
    }

    public double getTorque() {
        return this.torque;
    }

    public double getAccumulatedTorque() {
        int tSize = this.torques.size();
        double torque = 0.0;
        int i = 0;
        while (i < tSize) {
            torque += this.torques.get((int)i).torque;
            ++i;
        }
        return torque;
    }

    public double getLinearDamping() {
        return this.linearDamping;
    }

    public void setLinearDamping(double linearDamping) {
        if (linearDamping < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.body.invalidLinearDamping"));
        }
        this.linearDamping = linearDamping;
    }

    public double getAngularDamping() {
        return this.angularDamping;
    }

    public void setAngularDamping(double angularDamping) {
        if (angularDamping < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.body.invalidAngularDamping"));
        }
        this.angularDamping = angularDamping;
    }

    public double getGravityScale() {
        return this.gravityScale;
    }

    public void setGravityScale(double scale) {
        this.gravityScale = scale;
    }

    public List<Body> getJoinedBodies() {
        int size = this.joints.size();
        ArrayList<Body> bodies = new ArrayList<Body>(size);
        int i = 0;
        while (i < size) {
            JointEdge je = this.joints.get(i);
            Body other = je.other;
            if (!bodies.contains(other)) {
                bodies.add(other);
            }
            ++i;
        }
        return bodies;
    }

    public List<Joint> getJoints() {
        int size = this.joints.size();
        ArrayList<Joint> joints = new ArrayList<Joint>(size);
        int i = 0;
        while (i < size) {
            JointEdge je = this.joints.get(i);
            joints.add((Joint)je.interaction);
            ++i;
        }
        return joints;
    }

    public List<Body> getInContactBodies(boolean sensed) {
        int size = this.contacts.size();
        ArrayList<Body> bodies = new ArrayList<Body>(size);
        int i = 0;
        while (i < size) {
            Body other;
            ContactEdge ce = this.contacts.get(i);
            ContactConstraint constraint = (ContactConstraint)ce.interaction;
            if (sensed == constraint.isSensor() && !bodies.contains(other = ce.other)) {
                bodies.add(other);
            }
            ++i;
        }
        return bodies;
    }

    public List<ContactPoint> getContacts(boolean sensed) {
        int size = this.contacts.size();
        ArrayList<ContactPoint> contactPoints = new ArrayList<ContactPoint>(size * 2);
        int i = 0;
        while (i < size) {
            ContactEdge ce = this.contacts.get(i);
            ContactConstraint constraint = (ContactConstraint)ce.interaction;
            if (sensed == constraint.isSensor()) {
                List<Contact> contacts = constraint.getContacts();
                int csize = contacts.size();
                int j = 0;
                while (j < csize) {
                    Contact contact = contacts.get(j);
                    ContactPoint contactPoint = new ContactPoint(new ContactPointId(constraint.getId(), contact.getId()), constraint.getBody1(), constraint.getFixture1(), constraint.getBody2(), constraint.getFixture2(), contact.getPoint(), constraint.getNormal(), contact.getDepth());
                    contactPoints.add(contactPoint);
                    ++j;
                }
            }
            ++i;
        }
        return contactPoints;
    }
}

