/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.World;

final class BodyIterator
implements Iterator<Body> {
    private final World world;
    private int index;

    public BodyIterator(World world) {
        this.world = world;
        this.index = -1;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.world.getBodyCount();
    }

    @Override
    public Body next() {
        if (this.index >= this.world.getBodyCount()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            ++this.index;
            Body body = this.world.getBody(this.index);
            return body;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        if (this.index < 0) {
            throw new IllegalStateException();
        }
        if (this.index >= this.world.getBodyCount()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.world.removeBody(this.index);
            --this.index;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }
}

