/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import org.dyn4j.collision.continuous.TimeOfImpact;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;

public class ConvexCastResult
implements Comparable<ConvexCastResult> {
    protected Body body;
    protected BodyFixture fixture;
    protected TimeOfImpact timeOfImpact;

    public ConvexCastResult() {
    }

    public ConvexCastResult(Body body, BodyFixture fixture, TimeOfImpact timeOfImpact) {
        this.body = body;
        this.fixture = fixture;
        this.timeOfImpact = timeOfImpact;
    }

    @Override
    public int compareTo(ConvexCastResult o) {
        return (int)Math.signum(this.timeOfImpact.getTime() - o.timeOfImpact.getTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConvexCastResult[Body=").append(this.body).append("|Fixture=").append(this.fixture).append("|TimeOfImpact=").append(this.timeOfImpact).append("]");
        return sb.toString();
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public BodyFixture getFixture() {
        return this.fixture;
    }

    public TimeOfImpact getTimeOfImpact() {
        return this.timeOfImpact;
    }

    public void setFixture(BodyFixture fixture) {
        this.fixture = fixture;
    }

    public void setTimeOfImpact(TimeOfImpact timeOfImpact) {
        this.timeOfImpact = timeOfImpact;
    }
}

