/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Force {
    protected Vector2 force;

    public Force() {
        this.force = new Vector2();
    }

    public Force(double x, double y) {
        this.force = new Vector2(x, y);
    }

    public Force(Vector2 force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.force.nullVector"));
        }
        this.force = force;
    }

    public Force(Force force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.force.nullForce"));
        }
        this.force = force.force.copy();
    }

    public void set(double x, double y) {
        this.force.set(x, y);
    }

    public void set(Vector2 force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.force.setNullVector"));
        }
        this.force.set(force);
    }

    public void set(Force force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.force.setNullForce"));
        }
        this.force.set(force.force);
    }

    public boolean isComplete(double elapsedTime) {
        return true;
    }

    public String toString() {
        return this.force.toString();
    }

    public Vector2 getForce() {
        return this.force;
    }
}

