/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.collision.Collisions;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Capacity;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactConstraintSolver;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

final class Island {
    final List<Body> bodies;
    final List<Joint> joints;
    final List<ContactConstraint> contactConstraints;

    public Island() {
        this(Capacity.DEFAULT_CAPACITY);
    }

    public Island(Capacity initialCapacity) {
        if (initialCapacity == null) {
            throw new NullPointerException(Messages.getString("dynamics.nullCapacity"));
        }
        this.bodies = new ArrayList<Body>(initialCapacity.getBodyCount());
        this.joints = new ArrayList<Joint>(initialCapacity.getJointCount());
        int eSize = Collisions.getEstimatedCollisionPairs(initialCapacity.getBodyCount());
        this.contactConstraints = new ArrayList<ContactConstraint>(eSize);
    }

    public void clear() {
        this.bodies.clear();
        this.joints.clear();
        this.contactConstraints.clear();
    }

    public void add(Body body) {
        this.bodies.add(body);
    }

    public void add(ContactConstraint contactConstraint) {
        this.contactConstraints.add(contactConstraint);
    }

    public void add(Joint joint) {
        this.joints.add(joint);
    }

    public void solve(ContactConstraintSolver solver, Vector2 gravity, Step step, Settings settings) {
        int velocitySolverIterations = settings.getVelocityConstraintSolverIterations();
        int positionSolverIterations = settings.getPositionConstraintSolverIterations();
        double sleepAngularVelocitySquared = settings.getSleepAngularVelocitySquared();
        double sleepLinearVelocitySquared = settings.getSleepLinearVelocitySquared();
        double sleepTime = settings.getSleepTime();
        int size = this.bodies.size();
        int jSize = this.joints.size();
        double dt = step.dt;
        int i = 0;
        while (i < size) {
            Body body = this.bodies.get(i);
            if (body.isDynamic()) {
                body.accumulate(dt);
                double invM = body.mass.getInverseMass();
                double invI = body.mass.getInverseInertia();
                if (invM > Epsilon.E) {
                    body.velocity.x += (body.force.x * invM + gravity.x * body.gravityScale) * dt;
                    body.velocity.y += (body.force.y * invM + gravity.y * body.gravityScale) * dt;
                }
                if (invI > Epsilon.E) {
                    body.angularVelocity += dt * invI * body.torque;
                }
                double linear = 1.0 - dt * body.linearDamping;
                double angular = 1.0 - dt * body.angularDamping;
                linear = Interval.clamp(linear, 0.0, 1.0);
                angular = Interval.clamp(angular, 0.0, 1.0);
                body.velocity.x *= linear;
                body.velocity.y *= linear;
                body.angularVelocity *= angular;
            }
            ++i;
        }
        solver.initialize(this.contactConstraints, step, settings);
        i = 0;
        while (i < jSize) {
            Joint joint = this.joints.get(i);
            joint.initializeConstraints(step, settings);
            ++i;
        }
        i = 0;
        while (i < velocitySolverIterations) {
            int j = 0;
            while (j < jSize) {
                Joint joint = this.joints.get(j);
                joint.solveVelocityConstraints(step, settings);
                ++j;
            }
            solver.solveVelocityContraints(this.contactConstraints, step, settings);
            ++i;
        }
        double maxTranslation = settings.getMaximumTranslation();
        double maxRotation = settings.getMaximumRotation();
        double maxTranslationSqrd = settings.getMaximumTranslationSquared();
        double maxRotationSqrd = settings.getMaximumRotationSquared();
        int i2 = 0;
        while (i2 < size) {
            Body body = this.bodies.get(i2);
            if (!body.isStatic()) {
                double ratio;
                Vector2 translation = body.velocity.product(dt);
                double rotation = body.angularVelocity * dt;
                if (translation.getMagnitudeSquared() > maxTranslationSqrd) {
                    ratio = maxTranslation / translation.getMagnitude();
                    body.velocity.multiply(ratio);
                }
                if (rotation * rotation > maxRotationSqrd) {
                    ratio = maxRotation / Math.abs(rotation);
                    body.angularVelocity *= ratio;
                }
                body.translate(body.velocity.x * dt, body.velocity.y * dt);
                body.rotateAboutCenter(body.angularVelocity * dt);
            }
            ++i2;
        }
        boolean positionConstraintsSolved = false;
        int i3 = 0;
        while (i3 < positionSolverIterations) {
            boolean contactsSolved = solver.solvePositionContraints(this.contactConstraints, step, settings);
            boolean jointsSolved = true;
            int j = 0;
            while (j < jSize) {
                Joint joint = this.joints.get(j);
                boolean jointSolved = joint.solvePositionConstraints(step, settings);
                jointsSolved = jointsSolved && jointSolved;
                ++j;
            }
            if (contactsSolved && jointsSolved) {
                positionConstraintsSolved = true;
                break;
            }
            ++i3;
        }
        if (settings.isAutoSleepingEnabled()) {
            double minSleepTime = Double.MAX_VALUE;
            int i4 = 0;
            while (i4 < size) {
                Body body = this.bodies.get(i4);
                if (!body.isStatic()) {
                    if (body.isAutoSleepingEnabled()) {
                        if (body.velocity.dot(body.velocity) > sleepLinearVelocitySquared || body.angularVelocity * body.angularVelocity > sleepAngularVelocitySquared) {
                            body.sleepTime = 0.0;
                            minSleepTime = 0.0;
                        } else {
                            body.sleepTime += step.dt;
                            minSleepTime = Math.min(minSleepTime, body.sleepTime);
                        }
                    } else {
                        body.sleepTime = 0.0;
                        minSleepTime = 0.0;
                    }
                }
                ++i4;
            }
            if (minSleepTime >= sleepTime && positionConstraintsSolved) {
                i4 = 0;
                while (i4 < size) {
                    Body body = this.bodies.get(i4);
                    body.setAsleep(true);
                    ++i4;
                }
            }
        }
    }
}

