/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import org.dyn4j.dynamics.ContinuousDetectionMode;
import org.dyn4j.resources.Messages;

public class Settings {
    public static final double DEFAULT_STEP_FREQUENCY = 0.016666666666666666;
    public static final double DEFAULT_MAXIMUM_TRANSLATION = 2.0;
    public static final double DEFAULT_MAXIMUM_ROTATION = 1.5707963267948966;
    public static final double DEFAULT_SLEEP_LINEAR_VELOCITY = 0.01;
    public static final double DEFAULT_SLEEP_ANGULAR_VELOCITY = Math.toRadians(2.0);
    public static final double DEFAULT_SLEEP_TIME = 0.5;
    public static final int DEFAULT_SOLVER_ITERATIONS = 10;
    public static final double DEFAULT_WARM_START_DISTANCE = 0.01;
    public static final double DEFAULT_RESTITUTION_VELOCITY = 1.0;
    public static final double DEFAULT_LINEAR_TOLERANCE = 0.005;
    public static final double DEFAULT_ANGULAR_TOLERANCE = Math.toRadians(2.0);
    public static final double DEFAULT_MAXIMUM_LINEAR_CORRECTION = 0.2;
    public static final double DEFAULT_MAXIMUM_ANGULAR_CORRECTION = Math.toRadians(8.0);
    public static final double DEFAULT_BAUMGARTE = 0.2;
    private double stepFrequency = 0.016666666666666666;
    private double maximumTranslation = 2.0;
    private double maximumTranslationSquared = 4.0;
    private double maximumRotation = 1.5707963267948966;
    private double maximumRotationSquared = 2.4674011002723395;
    private boolean autoSleepingEnabled = true;
    private double sleepLinearVelocity = 0.01;
    private double sleepLinearVelocitySquared = 1.0E-4;
    private double sleepAngularVelocity = DEFAULT_SLEEP_ANGULAR_VELOCITY;
    private double sleepAngularVelocitySquared = DEFAULT_SLEEP_ANGULAR_VELOCITY * DEFAULT_SLEEP_ANGULAR_VELOCITY;
    private double sleepTime = 0.5;
    private int velocityConstraintSolverIterations = 10;
    private int positionConstraintSolverIterations = 10;
    private double warmStartDistance = 0.01;
    private double warmStartDistanceSquared = 1.0E-4;
    private double restitutionVelocity = 1.0;
    private double restitutionVelocitySquared = 1.0;
    private double linearTolerance = 0.005;
    private double linearToleranceSquared = 2.5E-5;
    private double angularTolerance = DEFAULT_ANGULAR_TOLERANCE;
    private double angularToleranceSquared = DEFAULT_ANGULAR_TOLERANCE * DEFAULT_ANGULAR_TOLERANCE;
    private double maximumLinearCorrection = 0.2;
    private double maximumLinearCorrectionSquared = 0.04000000000000001;
    private double maximumAngularCorrection = DEFAULT_MAXIMUM_ANGULAR_CORRECTION;
    private double maximumAngularCorrectionSquared = DEFAULT_MAXIMUM_ANGULAR_CORRECTION * DEFAULT_MAXIMUM_ANGULAR_CORRECTION;
    private double baumgarte = 0.2;
    private ContinuousDetectionMode continuousDetectionMode = ContinuousDetectionMode.ALL;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Settings[StepFrequency=").append(this.stepFrequency).append("|MaximumTranslation=").append(this.maximumTranslation).append("|MaximumRotation=").append(this.maximumRotation).append("|AutoSleepingEnabled=").append(this.autoSleepingEnabled).append("|SleepLinearVelocity=").append(this.sleepLinearVelocity).append("|SleepAngularVelocity=").append(this.sleepAngularVelocity).append("|SleepTime=").append(this.sleepTime).append("|VelocityConstraintSolverIterations=").append(this.velocityConstraintSolverIterations).append("|PositionConstraintSolverIterations=").append(this.positionConstraintSolverIterations).append("|WarmStartDistance=").append(this.warmStartDistance).append("|RestitutionVelocity=").append(this.restitutionVelocity).append("|LinearTolerance=").append(this.linearTolerance).append("|AngularTolerance=").append(this.angularTolerance).append("|MaximumLinearCorrection=").append(this.maximumLinearCorrection).append("|MaximumAngularCorrection=").append(this.maximumAngularCorrection).append("|Baumgarte=").append(this.baumgarte).append("|ContinuousDetectionMode=").append((Object)this.continuousDetectionMode).append("]");
        return sb.toString();
    }

    public void reset() {
        this.stepFrequency = 0.016666666666666666;
        this.maximumTranslation = 2.0;
        this.maximumTranslationSquared = 4.0;
        this.maximumRotation = 1.5707963267948966;
        this.maximumRotationSquared = 2.4674011002723395;
        this.autoSleepingEnabled = true;
        this.sleepLinearVelocity = 0.01;
        this.sleepLinearVelocitySquared = 1.0E-4;
        this.sleepAngularVelocity = DEFAULT_SLEEP_ANGULAR_VELOCITY;
        this.sleepAngularVelocitySquared = DEFAULT_SLEEP_ANGULAR_VELOCITY * DEFAULT_SLEEP_ANGULAR_VELOCITY;
        this.sleepTime = 0.5;
        this.velocityConstraintSolverIterations = 10;
        this.positionConstraintSolverIterations = 10;
        this.warmStartDistance = 0.01;
        this.warmStartDistanceSquared = 1.0E-4;
        this.restitutionVelocity = 1.0;
        this.restitutionVelocitySquared = 1.0;
        this.linearTolerance = 0.005;
        this.linearToleranceSquared = 2.5E-5;
        this.maximumLinearCorrection = 0.2;
        this.maximumLinearCorrectionSquared = 0.04000000000000001;
        this.angularTolerance = DEFAULT_ANGULAR_TOLERANCE;
        this.angularToleranceSquared = DEFAULT_ANGULAR_TOLERANCE * DEFAULT_ANGULAR_TOLERANCE;
        this.baumgarte = 0.2;
        this.continuousDetectionMode = ContinuousDetectionMode.ALL;
    }

    public double getStepFrequency() {
        return this.stepFrequency;
    }

    public void setStepFrequency(double stepFrequency) {
        if (stepFrequency <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidStepFrequency"));
        }
        this.stepFrequency = stepFrequency;
    }

    public double getMaximumTranslation() {
        return this.maximumTranslation;
    }

    public double getMaximumTranslationSquared() {
        return this.maximumTranslationSquared;
    }

    public void setMaximumTranslation(double maximumTranslation) {
        if (maximumTranslation < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidMaximumTranslation"));
        }
        this.maximumTranslation = maximumTranslation;
        this.maximumTranslationSquared = maximumTranslation * maximumTranslation;
    }

    public double getMaximumRotation() {
        return this.maximumRotation;
    }

    public double getMaximumRotationSquared() {
        return this.maximumRotationSquared;
    }

    public void setMaximumRotation(double maximumRotation) {
        if (maximumRotation < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidMaximumRotation"));
        }
        this.maximumRotation = maximumRotation;
        this.maximumRotationSquared = maximumRotation * maximumRotation;
    }

    public boolean isAutoSleepingEnabled() {
        return this.autoSleepingEnabled;
    }

    public void setAutoSleepingEnabled(boolean flag) {
        this.autoSleepingEnabled = flag;
    }

    public double getSleepLinearVelocity() {
        return this.sleepLinearVelocity;
    }

    public double getSleepLinearVelocitySquared() {
        return this.sleepLinearVelocitySquared;
    }

    public void setSleepLinearVelocity(double sleepLinearVelocity) {
        if (sleepLinearVelocity < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidSleepLinearVelocity"));
        }
        this.sleepLinearVelocity = sleepLinearVelocity;
        this.sleepLinearVelocitySquared = sleepLinearVelocity * sleepLinearVelocity;
    }

    public double getSleepAngularVelocity() {
        return this.sleepAngularVelocity;
    }

    public double getSleepAngularVelocitySquared() {
        return this.sleepAngularVelocitySquared;
    }

    public void setSleepAngularVelocity(double sleepAngularVelocity) {
        if (sleepAngularVelocity < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidSleepAngularVelocity"));
        }
        this.sleepAngularVelocity = sleepAngularVelocity;
        this.sleepAngularVelocitySquared = sleepAngularVelocity * sleepAngularVelocity;
    }

    public double getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(double sleepTime) {
        if (sleepTime < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidSleepTime"));
        }
        this.sleepTime = sleepTime;
    }

    public int getVelocityConstraintSolverIterations() {
        return this.velocityConstraintSolverIterations;
    }

    public void setVelocityConstraintSolverIterations(int velocityConstraintSolverIterations) {
        if (velocityConstraintSolverIterations < 1) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidVelocityIterations"));
        }
        this.velocityConstraintSolverIterations = velocityConstraintSolverIterations;
    }

    public int getPositionConstraintSolverIterations() {
        return this.positionConstraintSolverIterations;
    }

    public void setPositionConstraintSolverIterations(int positionConstraintSolverIterations) {
        if (positionConstraintSolverIterations < 1) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidPositionIterations"));
        }
        this.positionConstraintSolverIterations = positionConstraintSolverIterations;
    }

    public double getWarmStartDistance() {
        return this.warmStartDistance;
    }

    public double getWarmStartDistanceSquared() {
        return this.warmStartDistanceSquared;
    }

    public void setWarmStartDistance(double warmStartDistance) {
        if (warmStartDistance < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidWarmStartDistance"));
        }
        this.warmStartDistance = warmStartDistance;
        this.warmStartDistanceSquared = this.warmStartDistance * this.warmStartDistance;
    }

    public double getRestitutionVelocity() {
        return this.restitutionVelocity;
    }

    public double getRestitutionVelocitySquared() {
        return this.restitutionVelocitySquared;
    }

    public void setRestitutionVelocity(double restitutionVelocity) {
        if (restitutionVelocity < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidRestitutionVelocity"));
        }
        this.restitutionVelocity = restitutionVelocity;
        this.restitutionVelocitySquared = restitutionVelocity * restitutionVelocity;
    }

    public double getLinearTolerance() {
        return this.linearTolerance;
    }

    public double getLinearToleranceSquared() {
        return this.linearToleranceSquared;
    }

    public void setLinearTolerance(double linearTolerance) {
        if (linearTolerance < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidLinearTolerance"));
        }
        this.linearTolerance = linearTolerance;
        this.linearToleranceSquared = linearTolerance * linearTolerance;
    }

    public double getAngularTolerance() {
        return this.angularTolerance;
    }

    public double getAngularToleranceSquared() {
        return this.angularToleranceSquared;
    }

    public void setAngularTolerance(double angularTolerance) {
        if (angularTolerance < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidAngularTolerance"));
        }
        this.angularTolerance = angularTolerance;
        this.angularToleranceSquared = angularTolerance * angularTolerance;
    }

    public double getMaximumLinearCorrection() {
        return this.maximumLinearCorrection;
    }

    public double getMaximumLinearCorrectionSquared() {
        return this.maximumLinearCorrectionSquared;
    }

    public void setMaximumLinearCorrection(double maximumLinearCorrection) {
        if (maximumLinearCorrection < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidMaximumLinearCorrection"));
        }
        this.maximumLinearCorrection = maximumLinearCorrection;
        this.maximumLinearCorrectionSquared = maximumLinearCorrection * maximumLinearCorrection;
    }

    public double getMaximumAngularCorrection() {
        return this.maximumAngularCorrection;
    }

    public double getMaximumAngularCorrectionSquared() {
        return this.maximumAngularCorrectionSquared;
    }

    public void setMaximumAngularCorrection(double maximumAngularCorrection) {
        if (maximumAngularCorrection < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidMaximumAngularCorrection"));
        }
        this.maximumAngularCorrection = maximumAngularCorrection;
        this.maximumAngularCorrectionSquared = maximumAngularCorrection * maximumAngularCorrection;
    }

    public double getBaumgarte() {
        return this.baumgarte;
    }

    public void setBaumgarte(double baumgarte) {
        if (baumgarte < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.settings.invalidBaumgarte"));
        }
        this.baumgarte = baumgarte;
    }

    public ContinuousDetectionMode getContinuousDetectionMode() {
        return this.continuousDetectionMode;
    }

    public void setContinuousDetectionMode(ContinuousDetectionMode mode) {
        if (mode == null) {
            throw new NullPointerException(Messages.getString("dynamics.settings.invalidCCDMode"));
        }
        this.continuousDetectionMode = mode;
    }
}

