/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

public class Step {
    protected double dt0;
    protected double invdt0;
    protected double dt;
    protected double invdt;
    protected double dtRatio;

    public Step(double dt) {
        this.dt = dt;
        this.invdt = 1.0 / dt;
        this.dt0 = this.dt;
        this.invdt0 = this.invdt;
        this.dtRatio = 1.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Step[DeltaTime=").append(this.dt).append("|InverseDeltaTime=").append(this.invdt).append("|PreviousDeltaTime=").append(this.dt0).append("|PreviousInverseDeltaTime=").append(this.invdt0).append("|DeltaTimeRatio=").append(this.dtRatio).append("]");
        return sb.toString();
    }

    protected void update(double dt) {
        this.dt0 = this.dt;
        this.invdt0 = this.invdt;
        this.dt = dt;
        this.invdt = 1.0 / dt;
        this.dtRatio = this.invdt0 * dt;
    }

    public double getDeltaTime() {
        return this.dt;
    }

    public double getInverseDeltaTime() {
        return this.invdt;
    }

    public double getDeltaTimeRatio() {
        return this.dtRatio;
    }

    public double getPrevousDeltaTime() {
        return this.dt0;
    }

    public double getPreviousInverseDeltaTime() {
        return this.invdt0;
    }
}

