/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dyn4j.DataContainer;
import org.dyn4j.Listener;
import org.dyn4j.collision.Bounds;
import org.dyn4j.collision.BoundsListener;
import org.dyn4j.collision.Filter;
import org.dyn4j.collision.broadphase.BroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphaseItem;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.collision.broadphase.DynamicAABBTree;
import org.dyn4j.collision.continuous.ConservativeAdvancement;
import org.dyn4j.collision.continuous.TimeOfImpact;
import org.dyn4j.collision.continuous.TimeOfImpactDetector;
import org.dyn4j.collision.manifold.ClippingManifoldSolver;
import org.dyn4j.collision.manifold.Manifold;
import org.dyn4j.collision.manifold.ManifoldSolver;
import org.dyn4j.collision.narrowphase.Gjk;
import org.dyn4j.collision.narrowphase.NarrowphaseDetector;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.collision.narrowphase.RaycastDetector;
import org.dyn4j.dynamics.AABBBroadphaseFilter;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.BodyIterator;
import org.dyn4j.dynamics.Capacity;
import org.dyn4j.dynamics.CoefficientMixer;
import org.dyn4j.dynamics.CollisionListener;
import org.dyn4j.dynamics.Constraint;
import org.dyn4j.dynamics.ContactEdge;
import org.dyn4j.dynamics.ContinuousDetectionMode;
import org.dyn4j.dynamics.ConvexCastListener;
import org.dyn4j.dynamics.ConvexCastResult;
import org.dyn4j.dynamics.DestructionListener;
import org.dyn4j.dynamics.DetectBroadphaseFilter;
import org.dyn4j.dynamics.DetectListener;
import org.dyn4j.dynamics.DetectResult;
import org.dyn4j.dynamics.Island;
import org.dyn4j.dynamics.JointEdge;
import org.dyn4j.dynamics.JointIterator;
import org.dyn4j.dynamics.RaycastBroadphaseFilter;
import org.dyn4j.dynamics.RaycastListener;
import org.dyn4j.dynamics.RaycastResult;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.StepListener;
import org.dyn4j.dynamics.TimeOfImpactListener;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactConstraintSolver;
import org.dyn4j.dynamics.contact.ContactListener;
import org.dyn4j.dynamics.contact.ContactManager;
import org.dyn4j.dynamics.contact.ContactPoint;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.dynamics.contact.SequentialImpulses;
import org.dyn4j.dynamics.contact.TimeOfImpactSolver;
import org.dyn4j.dynamics.contact.WarmStartingContactManager;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class World
implements Shiftable,
DataContainer {
    public static final Vector2 EARTH_GRAVITY = new Vector2(0.0, -9.8);
    public static final Vector2 ZERO_GRAVITY = new Vector2(0.0, 0.0);
    protected final UUID id = UUID.randomUUID();
    protected Settings settings;
    protected Step step;
    protected Vector2 gravity;
    protected Bounds bounds;
    protected BroadphaseDetector<Body, BodyFixture> broadphaseDetector;
    protected NarrowphaseDetector narrowphaseDetector;
    protected ManifoldSolver manifoldSolver;
    protected TimeOfImpactDetector timeOfImpactDetector;
    protected RaycastDetector raycastDetector;
    protected ContactManager contactManager;
    protected CoefficientMixer coefficientMixer;
    protected ContactConstraintSolver contactConstraintSolver;
    protected TimeOfImpactSolver timeOfImpactSolver;
    protected Object userData;
    private final List<Listener> listeners;
    private final List<Body> bodies;
    private final List<Joint> joints;
    private Island island;
    private double time;
    private boolean updateRequired;

    public World() {
        this(Capacity.DEFAULT_CAPACITY, null);
    }

    public World(Capacity initialCapacity) {
        this(initialCapacity, null);
    }

    public World(Bounds bounds) {
        this(Capacity.DEFAULT_CAPACITY, bounds);
    }

    public World(Capacity initialCapacity, Bounds bounds) {
        if (initialCapacity == null) {
            initialCapacity = new Capacity();
        }
        this.settings = new Settings();
        this.step = new Step(this.settings.getStepFrequency());
        this.gravity = EARTH_GRAVITY;
        this.bounds = bounds;
        this.broadphaseDetector = new DynamicAABBTree<Body, BodyFixture>(initialCapacity.getBodyCount());
        this.narrowphaseDetector = new Gjk();
        this.manifoldSolver = new ClippingManifoldSolver();
        this.timeOfImpactDetector = new ConservativeAdvancement();
        this.raycastDetector = new Gjk();
        this.coefficientMixer = CoefficientMixer.DEFAULT_MIXER;
        this.contactManager = new WarmStartingContactManager(initialCapacity);
        this.contactConstraintSolver = new SequentialImpulses();
        this.timeOfImpactSolver = new TimeOfImpactSolver();
        this.bodies = new ArrayList<Body>(initialCapacity.getBodyCount());
        this.joints = new ArrayList<Joint>(initialCapacity.getJointCount());
        this.listeners = new ArrayList<Listener>(initialCapacity.getListenerCount());
        this.island = new Island(initialCapacity);
        this.time = 0.0;
        this.updateRequired = true;
    }

    public boolean update(double elapsedTime) {
        if (elapsedTime < 0.0) {
            elapsedTime = 0.0;
        }
        this.time += elapsedTime;
        double invhz = this.settings.getStepFrequency();
        if (this.time >= invhz) {
            this.step.update(invhz);
            this.time -= invhz;
            this.step();
            return true;
        }
        return false;
    }

    public boolean update(double elapsedTime, int maximumSteps) {
        if (elapsedTime < 0.0) {
            elapsedTime = 0.0;
        }
        this.time += elapsedTime;
        double invhz = this.settings.getStepFrequency();
        int steps = 0;
        while (this.time >= invhz && steps < maximumSteps) {
            this.step.update(invhz);
            this.time -= invhz;
            this.step();
            ++steps;
        }
        return steps > 0;
    }

    public void updatev(double elapsedTime) {
        if (elapsedTime <= 0.0) {
            return;
        }
        this.step.update(elapsedTime);
        this.step();
    }

    public void step(int steps) {
        double invhz = this.settings.getStepFrequency();
        this.step(steps, invhz);
    }

    public void step(int steps, double elapsedTime) {
        if (steps <= 0) {
            return;
        }
        if (elapsedTime <= 0.0) {
            return;
        }
        int i = 0;
        while (i < steps) {
            this.step.update(elapsedTime);
            this.step();
            ++i;
        }
    }

    protected void step() {
        StepListener sl;
        Constraint joint;
        StepListener sl2;
        List<StepListener> stepListeners = this.getListeners(StepListener.class);
        List<ContactListener> contactListeners = this.getListeners(ContactListener.class);
        int sSize = stepListeners.size();
        int i = 0;
        while (i < sSize) {
            sl2 = stepListeners.get(i);
            sl2.begin(this.step, this);
            ++i;
        }
        if (this.updateRequired) {
            this.detect();
            i = 0;
            while (i < sSize) {
                sl2 = stepListeners.get(i);
                sl2.updatePerformed(this.step, this);
                ++i;
            }
            this.updateRequired = false;
        }
        this.contactManager.preSolveNotify(contactListeners);
        ContinuousDetectionMode continuousDetectionMode = this.settings.getContinuousDetectionMode();
        int size = this.bodies.size();
        int i2 = 0;
        while (i2 < size) {
            Body body = this.bodies.get(i2);
            body.setOnIsland(false);
            if (continuousDetectionMode != ContinuousDetectionMode.NONE) {
                body.transform0.set(body.getTransform());
            }
            ++i2;
        }
        int jSize = this.joints.size();
        int i3 = 0;
        while (i3 < jSize) {
            joint = this.joints.get(i3);
            joint.setOnIsland(false);
            ++i3;
        }
        ArrayDeque<Body> stack = new ArrayDeque<Body>(size);
        int i4 = 0;
        while (i4 < size) {
            Body seed = this.bodies.get(i4);
            if (!seed.isOnIsland() && !seed.isAsleep() && seed.isActive() && !seed.isStatic()) {
                Island island = this.island;
                island.clear();
                stack.clear();
                stack.push(seed);
                while (stack.size() > 0) {
                    Constraint constraint;
                    Body body = (Body)stack.pop();
                    island.add(body);
                    body.setOnIsland(true);
                    body.setAsleep(false);
                    if (body.isStatic()) continue;
                    int ceSize = body.contacts.size();
                    int j = 0;
                    while (j < ceSize) {
                        ContactEdge contactEdge = body.contacts.get(j);
                        ContactConstraint contactConstraint = (ContactConstraint)contactEdge.interaction;
                        constraint = contactConstraint;
                        if (!contactConstraint.isSensor()) {
                            Body other = contactEdge.other;
                            if (!constraint.isOnIsland()) {
                                island.add(contactConstraint);
                                constraint.setOnIsland(true);
                                if (!other.isOnIsland()) {
                                    stack.push(other);
                                    other.setOnIsland(true);
                                }
                            }
                        }
                        ++j;
                    }
                    int jeSize = body.joints.size();
                    int j2 = 0;
                    while (j2 < jeSize) {
                        JointEdge jointEdge = body.joints.get(j2);
                        constraint = joint = (Joint)jointEdge.interaction;
                        if (((Joint)joint).isActive()) {
                            Body other = jointEdge.other;
                            if (!constraint.isOnIsland() && other.isActive()) {
                                island.add((Joint)joint);
                                constraint.setOnIsland(true);
                                if (!other.isOnIsland()) {
                                    stack.push(other);
                                    other.setOnIsland(true);
                                }
                            }
                        }
                        ++j2;
                    }
                }
                island.solve(this.contactConstraintSolver, this.gravity, this.step, this.settings);
                int j = 0;
                while (j < size) {
                    Body body = this.bodies.get(j);
                    if (body.isStatic()) {
                        body.setOnIsland(false);
                    }
                    ++j;
                }
            }
            ++i4;
        }
        stack.clear();
        this.island.clear();
        this.contactManager.postSolveNotify(contactListeners);
        if (continuousDetectionMode != ContinuousDetectionMode.NONE) {
            this.solveTOI(continuousDetectionMode);
        }
        i4 = 0;
        while (i4 < sSize) {
            sl = stepListeners.get(i4);
            sl.postSolve(this.step, this);
            ++i4;
        }
        this.detect();
        this.updateRequired = false;
        i4 = 0;
        while (i4 < sSize) {
            sl = stepListeners.get(i4);
            sl.end(this.step, this);
            ++i4;
        }
    }

    protected void detect() {
        List<BoundsListener> boundsListeners = this.getListeners(BoundsListener.class);
        List<CollisionListener> collisionListeners = this.getListeners(CollisionListener.class);
        int size = this.bodies.size();
        int blSize = boundsListeners.size();
        int clSize = collisionListeners.size();
        int i = 0;
        while (i < size) {
            Body body = this.bodies.get(i);
            if (body.isActive()) {
                body.contacts.clear();
                if (this.bounds != null && this.bounds.isOutside(body)) {
                    body.setActive(false);
                    int j = 0;
                    while (j < blSize) {
                        BoundsListener bl = boundsListeners.get(j);
                        bl.outside(body);
                        ++j;
                    }
                }
                this.broadphaseDetector.update(body);
            }
            ++i;
        }
        if (size > 0) {
            DetectBroadphaseFilter filter = new DetectBroadphaseFilter();
            List<BroadphasePair<Body, BodyFixture>> pairs = this.broadphaseDetector.detect(filter);
            int pSize = pairs.size();
            boolean allow = true;
            int i2 = 0;
            while (i2 < pSize) {
                BroadphasePair<Body, BodyFixture> pair = pairs.get(i2);
                Body body1 = pair.getCollidable1();
                Body body2 = pair.getCollidable2();
                BodyFixture fixture1 = pair.getFixture1();
                BodyFixture fixture2 = pair.getFixture2();
                allow = true;
                int j = 0;
                while (j < clSize) {
                    CollisionListener cl = collisionListeners.get(j);
                    if (!cl.collision(body1, fixture1, body2, fixture2)) {
                        allow = false;
                    }
                    ++j;
                }
                if (allow) {
                    Penetration penetration;
                    Transform transform1 = body1.getTransform();
                    Transform transform2 = body2.getTransform();
                    Convex convex2 = fixture2.getShape();
                    Convex convex1 = fixture1.getShape();
                    if (this.narrowphaseDetector.detect(convex1, transform1, convex2, transform2, penetration = new Penetration()) && penetration.getDepth() != 0.0) {
                        Manifold manifold;
                        allow = true;
                        int j2 = 0;
                        while (j2 < clSize) {
                            CollisionListener cl = collisionListeners.get(j2);
                            if (!cl.collision(body1, fixture1, body2, fixture2, penetration)) {
                                allow = false;
                            }
                            ++j2;
                        }
                        if (allow && this.manifoldSolver.getManifold(penetration, convex1, transform1, convex2, transform2, manifold = new Manifold()) && manifold.getPoints().size() != 0) {
                            allow = true;
                            int j3 = 0;
                            while (j3 < clSize) {
                                CollisionListener cl = collisionListeners.get(j3);
                                if (!cl.collision(body1, fixture1, body2, fixture2, manifold)) {
                                    allow = false;
                                }
                                ++j3;
                            }
                            if (allow) {
                                ContactConstraint contactConstraint = new ContactConstraint(body1, fixture1, body2, fixture2, manifold, this.coefficientMixer.mixFriction(fixture1.getFriction(), fixture2.getFriction()), this.coefficientMixer.mixRestitution(fixture1.getRestitution(), fixture2.getRestitution()));
                                allow = true;
                                int j4 = 0;
                                while (j4 < clSize) {
                                    CollisionListener cl = collisionListeners.get(j4);
                                    if (!cl.collision(contactConstraint)) {
                                        allow = false;
                                    }
                                    ++j4;
                                }
                                if (allow) {
                                    ContactEdge contactEdge1 = new ContactEdge(body2, contactConstraint);
                                    ContactEdge contactEdge2 = new ContactEdge(body1, contactConstraint);
                                    body1.contacts.add(contactEdge1);
                                    body2.contacts.add(contactEdge2);
                                    this.contactManager.queue(contactConstraint);
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
        }
        this.contactManager.updateAndNotify(this.getListeners(ContactListener.class), this.settings);
    }

    protected void solveTOI(ContinuousDetectionMode mode) {
        List<TimeOfImpactListener> listeners = this.getListeners(TimeOfImpactListener.class);
        int size = this.bodies.size();
        boolean bulletsOnly = mode == ContinuousDetectionMode.BULLETS_ONLY;
        int i = 0;
        while (i < size) {
            Body body = this.bodies.get(i);
            if (!(bulletsOnly && !body.isBullet() || body.isKinematic() || body.isStatic() || !body.isOnIsland() || body.isAsleep())) {
                this.solveTOI(body, listeners);
            }
            ++i;
        }
    }

    protected void solveTOI(Body body1, List<TimeOfImpactListener> listeners) {
        int size = this.bodies.size();
        AABB aabb1 = body1.createSweptAABB();
        boolean bullet = body1.isBullet();
        double t1 = 0.0;
        double t2 = 1.0;
        TimeOfImpact minToi = null;
        Body minBody = null;
        int i = 0;
        while (i < size) {
            AABB aabb2;
            Body body2 = this.bodies.get(i);
            if (body1 != body2 && body2.isActive() && (!body2.isDynamic() || bullet) && !body1.isConnected(body2, false) && !body1.isInContact(body2) && aabb1.overlaps(aabb2 = body2.createSweptAABB())) {
                TimeOfImpact toi = new TimeOfImpact();
                int fc1 = body1.getFixtureCount();
                int fc2 = body2.getFixtureCount();
                double dt = this.step.getDeltaTime();
                Vector2 v1 = body1.getLinearVelocity().product(dt);
                Vector2 v2 = body2.getLinearVelocity().product(dt);
                double av1 = body1.getAngularVelocity() * dt;
                double av2 = body2.getAngularVelocity() * dt;
                Transform tx1 = body1.getInitialTransform();
                Transform tx2 = body2.getInitialTransform();
                int j = 0;
                while (j < fc1) {
                    BodyFixture f1 = (BodyFixture)body1.getFixture(j);
                    if (!f1.isSensor()) {
                        int k = 0;
                        while (k < fc2) {
                            double t;
                            Convex c2;
                            Convex c1;
                            Filter filter2;
                            Filter filter1;
                            BodyFixture f2 = (BodyFixture)body2.getFixture(k);
                            if (!f2.isSensor() && (filter1 = f1.getFilter()).isAllowed(filter2 = f2.getFilter()) && this.timeOfImpactDetector.getTimeOfImpact(c1 = f1.getShape(), tx1, v1, av1, c2 = f2.getShape(), tx2, v2, av2, t1, t2, toi) && (t = toi.getTime()) < t2) {
                                boolean allow = true;
                                for (TimeOfImpactListener tl : listeners) {
                                    if (tl.collision(body1, f1, body2, f2, toi)) continue;
                                    allow = false;
                                }
                                if (allow) {
                                    t2 = t;
                                    minToi = toi;
                                    minBody = body2;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (minToi != null) {
            double t = minToi.getTime();
            body1.transform0.lerp(body1.getTransform(), t, body1.getTransform());
            if (minBody.isDynamic()) {
                minBody.transform0.lerp(minBody.getTransform(), t, minBody.getTransform());
            }
            this.timeOfImpactSolver.solve(body1, minBody, minToi, this.settings);
        }
    }

    public boolean raycast(Vector2 start, Vector2 end, boolean ignoreSensors, boolean all, List<RaycastResult> results) {
        return this.raycast(start, end, null, ignoreSensors, true, all, results);
    }

    public boolean raycast(Vector2 start, Vector2 end, boolean ignoreSensors, boolean ignoreInactive, boolean all, List<RaycastResult> results) {
        return this.raycast(start, end, null, ignoreSensors, ignoreInactive, all, results);
    }

    public boolean raycast(Vector2 start, Vector2 end, Filter filter, boolean ignoreSensors, boolean ignoreInactive, boolean all, List<RaycastResult> results) {
        Vector2 d = start.to(end);
        double maxLength = d.normalize();
        Ray ray = new Ray(start, d);
        return this.raycast(ray, maxLength, filter, ignoreSensors, ignoreInactive, all, results);
    }

    public boolean raycast(Ray ray, double maxLength, boolean ignoreSensors, boolean all, List<RaycastResult> results) {
        return this.raycast(ray, maxLength, null, ignoreSensors, true, all, results);
    }

    public boolean raycast(Ray ray, double maxLength, boolean ignoreSensors, boolean ignoreInactive, boolean all, List<RaycastResult> results) {
        return this.raycast(ray, maxLength, null, ignoreSensors, ignoreInactive, all, results);
    }

    public boolean raycast(Ray ray, double maxLength, Filter filter, boolean ignoreSensors, boolean ignoreInactive, boolean all, List<RaycastResult> results) {
        List<RaycastListener> listeners = this.getListeners(RaycastListener.class);
        int rlSize = listeners.size();
        double max = 0.0;
        if (maxLength > 0.0) {
            max = maxLength;
        }
        RaycastResult result = null;
        RaycastBroadphaseFilter bpFilter = new RaycastBroadphaseFilter(ignoreInactive, ignoreSensors, filter);
        List<BroadphaseItem<Body, BodyFixture>> items = this.broadphaseDetector.raycast(ray, maxLength, bpFilter);
        int size = items.size();
        boolean found = false;
        boolean allow = true;
        int i = 0;
        while (i < size) {
            Convex convex;
            BroadphaseItem<Body, BodyFixture> item = items.get(i);
            Body body = item.getCollidable();
            BodyFixture fixture = item.getFixture();
            Transform transform = body.getTransform();
            Raycast raycast = new Raycast();
            allow = true;
            int j = 0;
            while (j < rlSize) {
                RaycastListener rl = listeners.get(j);
                if (!rl.allow(ray, body, fixture)) {
                    allow = false;
                }
                ++j;
            }
            if (allow && this.raycastDetector.raycast(ray, max, convex = fixture.getShape(), transform, raycast)) {
                allow = true;
                int j2 = 0;
                while (j2 < rlSize) {
                    RaycastListener rl = listeners.get(j2);
                    if (!rl.allow(ray, body, fixture, raycast)) {
                        allow = false;
                    }
                    ++j2;
                }
                if (allow) {
                    if (!all) {
                        if (result == null) {
                            result = new RaycastResult(body, fixture, raycast);
                            results.add(result);
                            found = true;
                        } else {
                            result.body = body;
                            result.fixture = fixture;
                            result.raycast = raycast;
                        }
                        max = result.raycast.getDistance();
                    } else {
                        results.add(new RaycastResult(body, fixture, raycast));
                        found = true;
                    }
                }
            }
            ++i;
        }
        return found;
    }

    public boolean raycast(Vector2 start, Vector2 end, Body body, boolean ignoreSensors, RaycastResult result) {
        return this.raycast(start, end, body, null, ignoreSensors, result);
    }

    public boolean raycast(Vector2 start, Vector2 end, Body body, Filter filter, boolean ignoreSensors, RaycastResult result) {
        Vector2 d = start.to(end);
        double maxLength = d.normalize();
        Ray ray = new Ray(start, d);
        return this.raycast(ray, body, maxLength, filter, ignoreSensors, result);
    }

    public boolean raycast(Ray ray, Body body, double maxLength, boolean ignoreSensors, RaycastResult result) {
        return this.raycast(ray, body, maxLength, null, ignoreSensors, result);
    }

    public boolean raycast(Ray ray, Body body, double maxLength, Filter filter, boolean ignoreSensors, RaycastResult result) {
        List<RaycastListener> listeners = this.getListeners(RaycastListener.class);
        int rlSize = listeners.size();
        boolean allow = true;
        int size = body.getFixtureCount();
        Transform transform = body.getTransform();
        double max = 0.0;
        if (maxLength > 0.0) {
            max = maxLength;
        }
        Raycast raycast = new Raycast();
        boolean found = false;
        int i = 0;
        while (i < size) {
            BodyFixture fixture = (BodyFixture)body.getFixture(i);
            if (!(ignoreSensors && fixture.isSensor() || filter != null && !filter.isAllowed(fixture.getFilter()))) {
                Convex convex;
                allow = true;
                int j = 0;
                while (j < rlSize) {
                    RaycastListener rl = listeners.get(j);
                    if (!rl.allow(ray, body, fixture)) {
                        allow = false;
                    }
                    ++j;
                }
                if (allow && this.raycastDetector.raycast(ray, max, convex = fixture.getShape(), transform, raycast)) {
                    allow = true;
                    int j2 = 0;
                    while (j2 < rlSize) {
                        RaycastListener rl = listeners.get(j2);
                        if (!rl.allow(ray, body, fixture, raycast)) {
                            allow = false;
                        }
                        ++j2;
                    }
                    if (allow) {
                        max = raycast.getDistance();
                        result.fixture = fixture;
                        found = true;
                    }
                }
            }
            ++i;
        }
        if (found) {
            result.body = body;
            result.raycast = raycast;
        }
        return found;
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 deltaPosition, boolean ignoreSensors, boolean all, List<ConvexCastResult> results) {
        return this.convexCast(convex, transform, deltaPosition, 0.0, null, ignoreSensors, true, all, results);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 deltaPosition, boolean ignoreSensors, boolean ignoreInactive, boolean all, List<ConvexCastResult> results) {
        return this.convexCast(convex, transform, deltaPosition, 0.0, null, ignoreSensors, ignoreInactive, all, results);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 deltaPosition, double deltaAngle, boolean ignoreSensors, boolean all, List<ConvexCastResult> results) {
        return this.convexCast(convex, transform, deltaPosition, deltaAngle, null, ignoreSensors, true, all, results);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 deltaPosition, double deltaAngle, boolean ignoreSensors, boolean ignoreInactive, boolean all, List<ConvexCastResult> results) {
        return this.convexCast(convex, transform, deltaPosition, deltaAngle, null, ignoreSensors, ignoreInactive, all, results);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 deltaPosition, double deltaAngle, Filter filter, boolean ignoreSensors, boolean ignoreInactive, boolean all, List<ConvexCastResult> results) {
        List<ConvexCastListener> listeners = this.getListeners(ConvexCastListener.class);
        int clSize = listeners.size();
        double radius = convex.getRadius();
        Vector2 startWorldCenter = transform.getTransformed(convex.getCenter());
        AABB startAABB = new AABB(startWorldCenter, radius);
        Transform finalTransform = transform.lerped(deltaPosition, deltaAngle, 1.0);
        Vector2 endWorldCenter = finalTransform.getTransformed(convex.getCenter());
        AABB endAABB = new AABB(endWorldCenter, radius);
        AABB aabb = startAABB.getUnion(endAABB);
        ConvexCastResult min = null;
        Vector2 dp2 = new Vector2();
        double t2 = 1.0;
        boolean found = false;
        boolean allow = true;
        AABBBroadphaseFilter bpFilter = new AABBBroadphaseFilter(ignoreInactive, ignoreSensors, filter);
        List<BroadphaseItem<Body, BodyFixture>> items = this.broadphaseDetector.detect(aabb, bpFilter);
        for (BroadphaseItem<Body, BodyFixture> item : items) {
            TimeOfImpact timeOfImpact;
            Body body = item.getCollidable();
            BodyFixture fixture = item.getFixture();
            double ft2 = t2;
            TimeOfImpact bodyMinToi = null;
            BodyFixture bodyMinFixture = null;
            Transform bodyTransform = body.getTransform();
            allow = true;
            int j = 0;
            while (j < clSize) {
                ConvexCastListener ccl = listeners.get(j);
                if (!ccl.allow(convex, body, fixture)) {
                    allow = false;
                }
                ++j;
            }
            if (!allow) continue;
            Convex c = fixture.getShape();
            if (this.timeOfImpactDetector.getTimeOfImpact(convex, transform, deltaPosition, deltaAngle, c, bodyTransform, dp2, 0.0, 0.0, ft2, timeOfImpact = new TimeOfImpact())) {
                allow = true;
                int j2 = 0;
                while (j2 < clSize) {
                    ConvexCastListener ccl = listeners.get(j2);
                    if (!ccl.allow(convex, body, fixture, timeOfImpact)) {
                        allow = false;
                    }
                    ++j2;
                }
                if (!allow) continue;
                if (bodyMinToi == null || timeOfImpact.getTime() < bodyMinToi.getTime()) {
                    ft2 = timeOfImpact.getTime();
                    bodyMinToi = timeOfImpact;
                    bodyMinFixture = fixture;
                }
            }
            if (bodyMinToi == null) continue;
            if (!all) {
                t2 = bodyMinToi.getTime();
                if (min == null || bodyMinToi.getTime() < min.timeOfImpact.getTime()) {
                    min = new ConvexCastResult(body, bodyMinFixture, bodyMinToi);
                }
            } else {
                ConvexCastResult result = new ConvexCastResult(body, fixture, timeOfImpact);
                results.add(result);
            }
            found = true;
        }
        if (min != null) {
            results.add(min);
        }
        return found;
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 deltaPosition, Body body, boolean ignoreSensors, ConvexCastResult result) {
        return this.convexCast(convex, transform, deltaPosition, 0.0, body, null, ignoreSensors, result);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 deltaPosition, double deltaAngle, Body body, boolean ignoreSensors, ConvexCastResult result) {
        return this.convexCast(convex, transform, deltaPosition, deltaAngle, body, null, ignoreSensors, result);
    }

    public boolean convexCast(Convex convex, Transform transform, Vector2 deltaPosition, double deltaAngle, Body body, Filter filter, boolean ignoreSensors, ConvexCastResult result) {
        List<ConvexCastListener> listeners = this.getListeners(ConvexCastListener.class);
        int clSize = listeners.size();
        boolean allow = true;
        boolean found = false;
        Vector2 dp2 = new Vector2();
        double t2 = 1.0;
        int bSize = body.getFixtureCount();
        Transform bodyTransform = body.getTransform();
        int i = 0;
        while (i < bSize) {
            BodyFixture bodyFixture = (BodyFixture)body.getFixture(i);
            if (!(ignoreSensors && bodyFixture.isSensor() || filter != null && !filter.isAllowed(bodyFixture.getFilter()))) {
                TimeOfImpact toi;
                allow = true;
                int j = 0;
                while (j < clSize) {
                    ConvexCastListener ccl = listeners.get(j);
                    if (!ccl.allow(convex, body, bodyFixture)) {
                        allow = false;
                    }
                    ++j;
                }
                if (!allow) {
                    return false;
                }
                Convex c = bodyFixture.getShape();
                if (this.timeOfImpactDetector.getTimeOfImpact(convex, transform, deltaPosition, deltaAngle, c, bodyTransform, dp2, 0.0, 0.0, t2, toi = new TimeOfImpact())) {
                    allow = true;
                    int j2 = 0;
                    while (j2 < clSize) {
                        ConvexCastListener ccl = listeners.get(j2);
                        if (!ccl.allow(convex, body, bodyFixture, toi)) {
                            allow = false;
                        }
                        ++j2;
                    }
                    if (allow) {
                        t2 = toi.getTime();
                        result.fixture = bodyFixture;
                        result.timeOfImpact = toi;
                        result.body = body;
                        found = true;
                    }
                }
            }
            ++i;
        }
        return found;
    }

    public boolean detect(AABB aabb, List<DetectResult> results) {
        return this.detect(aabb, null, false, true, results);
    }

    public boolean detect(AABB aabb, boolean ignoreInactive, List<DetectResult> results) {
        return this.detect(aabb, null, false, ignoreInactive, results);
    }

    public boolean detect(AABB aabb, boolean ignoreSensors, boolean ignoreInactive, List<DetectResult> results) {
        return this.detect(aabb, null, ignoreSensors, ignoreInactive, results);
    }

    public boolean detect(AABB aabb, Filter filter, boolean ignoreSensors, boolean ignoreInactive, List<DetectResult> results) {
        List<DetectListener> listeners = this.getListeners(DetectListener.class);
        int dlSize = listeners.size();
        AABBBroadphaseFilter bpFilter = new AABBBroadphaseFilter(ignoreInactive, ignoreSensors, filter);
        List<BroadphaseItem<Body, BodyFixture>> collisions = this.broadphaseDetector.detect(aabb, bpFilter);
        boolean found = false;
        int bSize = collisions.size();
        int i = 0;
        while (i < bSize) {
            AABB faabb;
            BroadphaseItem<Body, BodyFixture> item = collisions.get(i);
            Body body = item.getCollidable();
            BodyFixture fixture = item.getFixture();
            Transform transform = body.getTransform();
            boolean allow = true;
            int j = 0;
            while (j < dlSize) {
                DetectListener dl = listeners.get(j);
                if (!dl.allow(aabb, body, fixture)) {
                    allow = false;
                }
                ++j;
            }
            if (allow && aabb.overlaps(faabb = fixture.getShape().createAABB(transform))) {
                DetectResult result = new DetectResult(body, fixture);
                results.add(result);
                found = true;
            }
            ++i;
        }
        return found;
    }

    public boolean detect(Convex convex, List<DetectResult> results) {
        return this.detect(convex, Transform.IDENTITY, null, false, true, false, results);
    }

    public boolean detect(Convex convex, boolean ignoreSensors, List<DetectResult> results) {
        return this.detect(convex, Transform.IDENTITY, null, ignoreSensors, true, false, results);
    }

    public boolean detect(Convex convex, boolean ignoreSensors, boolean ignoreInactive, List<DetectResult> results) {
        return this.detect(convex, Transform.IDENTITY, null, ignoreSensors, ignoreInactive, false, results);
    }

    public boolean detect(Convex convex, Filter filter, boolean ignoreSensors, boolean ignoreInactive, List<DetectResult> results) {
        return this.detect(convex, Transform.IDENTITY, filter, ignoreSensors, ignoreInactive, false, results);
    }

    public boolean detect(Convex convex, Filter filter, boolean ignoreSensors, boolean ignoreInactive, boolean includeCollisionData, List<DetectResult> results) {
        return this.detect(convex, Transform.IDENTITY, filter, ignoreSensors, ignoreInactive, includeCollisionData, results);
    }

    public boolean detect(Convex convex, Transform transform, List<DetectResult> results) {
        return this.detect(convex, transform, null, false, true, false, results);
    }

    public boolean detect(Convex convex, Transform transform, boolean ignoreSensors, List<DetectResult> results) {
        return this.detect(convex, transform, null, ignoreSensors, true, false, results);
    }

    public boolean detect(Convex convex, Transform transform, boolean ignoreSensors, boolean ignoreInactive, List<DetectResult> results) {
        return this.detect(convex, transform, null, ignoreSensors, ignoreInactive, false, results);
    }

    public boolean detect(Convex convex, Transform transform, Filter filter, boolean ignoreSensors, boolean ignoreInactive, List<DetectResult> results) {
        return this.detect(convex, transform, filter, ignoreSensors, ignoreInactive, false, results);
    }

    public boolean detect(Convex convex, Transform transform, Filter filter, boolean ignoreSensors, boolean ignoreInactive, boolean includeCollisionData, List<DetectResult> results) {
        List<DetectListener> listeners = this.getListeners(DetectListener.class);
        int dlSize = listeners.size();
        boolean allow = true;
        AABB aabb = convex.createAABB(transform);
        AABBBroadphaseFilter bpFilter = new AABBBroadphaseFilter(ignoreInactive, ignoreSensors, filter);
        List<BroadphaseItem<Body, BodyFixture>> items = this.broadphaseDetector.detect(aabb, bpFilter);
        int bSize = items.size();
        boolean found = false;
        int i = 0;
        while (i < bSize) {
            BroadphaseItem<Body, BodyFixture> item = items.get(i);
            Body body = item.getCollidable();
            BodyFixture fixture = item.getFixture();
            Transform bt = body.getTransform();
            allow = true;
            int j = 0;
            while (j < dlSize) {
                DetectListener dl = listeners.get(j);
                if (!dl.allow(convex, transform, body, fixture)) {
                    allow = false;
                }
                ++j;
            }
            if (allow) {
                Convex bc = fixture.getShape();
                boolean collision = false;
                Penetration penetration = includeCollisionData ? new Penetration() : null;
                collision = includeCollisionData ? this.narrowphaseDetector.detect(convex, transform, bc, bt, penetration) : this.narrowphaseDetector.detect(convex, transform, bc, bt);
                if (collision) {
                    DetectResult result = new DetectResult(body, fixture, penetration);
                    results.add(result);
                    found = true;
                }
            }
            ++i;
        }
        return found;
    }

    public boolean detect(AABB aabb, Body body, boolean ignoreSensors, List<DetectResult> results) {
        return this.detect(aabb, body, null, ignoreSensors, results);
    }

    public boolean detect(AABB aabb, Body body, Filter filter, boolean ignoreSensors, List<DetectResult> results) {
        List<DetectListener> listeners = this.getListeners(DetectListener.class);
        int dlSize = listeners.size();
        boolean allow = true;
        boolean found = false;
        AABB baabb = this.broadphaseDetector.getAABB(body);
        if (baabb == null) {
            baabb = body.createAABB();
        }
        if (aabb.overlaps(baabb)) {
            Transform transform = body.getTransform();
            int fSize = body.getFixtureCount();
            int j = 0;
            while (j < fSize) {
                BodyFixture fixture = (BodyFixture)body.getFixture(j);
                if (!(ignoreSensors && fixture.isSensor() || filter != null && !filter.isAllowed(fixture.getFilter()))) {
                    AABB faabb;
                    allow = true;
                    int k = 0;
                    while (k < dlSize) {
                        DetectListener dl = listeners.get(k);
                        if (!dl.allow(aabb, body, fixture)) {
                            allow = false;
                        }
                        ++k;
                    }
                    if (allow && aabb.overlaps(faabb = fixture.getShape().createAABB(transform))) {
                        DetectResult result = new DetectResult(body, fixture);
                        results.add(result);
                        found = true;
                    }
                }
                ++j;
            }
        }
        return found;
    }

    public boolean detect(Convex convex, Body body, boolean ignoreSensors, List<DetectResult> results) {
        return this.detect(convex, Transform.IDENTITY, body, null, ignoreSensors, false, results);
    }

    public boolean detect(Convex convex, Body body, Filter filter, boolean ignoreSensors, List<DetectResult> results) {
        return this.detect(convex, Transform.IDENTITY, body, filter, ignoreSensors, false, results);
    }

    public boolean detect(Convex convex, Body body, Filter filter, boolean ignoreSensors, boolean includeCollisionData, List<DetectResult> results) {
        return this.detect(convex, Transform.IDENTITY, body, filter, ignoreSensors, includeCollisionData, results);
    }

    public boolean detect(Convex convex, Transform transform, Body body, boolean ignoreSensors, List<DetectResult> results) {
        return this.detect(convex, transform, body, null, ignoreSensors, false, results);
    }

    public boolean detect(Convex convex, Transform transform, Body body, Filter filter, boolean ignoreSensors, List<DetectResult> results) {
        return this.detect(convex, transform, body, filter, ignoreSensors, false, results);
    }

    public boolean detect(Convex convex, Transform transform, Body body, Filter filter, boolean ignoreSensors, boolean includeCollisionData, List<DetectResult> results) {
        List<DetectListener> listeners = this.getListeners(DetectListener.class);
        int dlSize = listeners.size();
        boolean allow = true;
        int i = 0;
        while (i < dlSize) {
            DetectListener dl = listeners.get(i);
            if (!dl.allow(convex, transform, body)) {
                allow = false;
            }
            ++i;
        }
        if (!allow) {
            return false;
        }
        AABB aabb = convex.createAABB(transform);
        AABB baabb = this.broadphaseDetector.getAABB(body);
        if (baabb == null) {
            baabb = body.createAABB();
        }
        boolean found = false;
        if (aabb.overlaps(baabb)) {
            Transform bt = body.getTransform();
            int fSize = body.getFixtureCount();
            int i2 = 0;
            while (i2 < fSize) {
                BodyFixture fixture = (BodyFixture)body.getFixture(i2);
                if (!ignoreSensors || !fixture.isSensor()) {
                    Filter ff = fixture.getFilter();
                    if (filter == null || ff.isAllowed(filter)) {
                        allow = true;
                        int j = 0;
                        while (j < dlSize) {
                            DetectListener dl = listeners.get(j);
                            if (!dl.allow(convex, transform, body, fixture)) {
                                allow = false;
                            }
                            ++j;
                        }
                        if (allow) {
                            Convex bc = fixture.getShape();
                            boolean collision = false;
                            Penetration penetration = includeCollisionData ? new Penetration() : null;
                            collision = includeCollisionData ? this.narrowphaseDetector.detect(convex, transform, bc, bt, penetration) : this.narrowphaseDetector.detect(convex, transform, bc, bt);
                            if (collision) {
                                DetectResult result = new DetectResult(body, fixture, penetration);
                                results.add(result);
                                found = true;
                            }
                        }
                    }
                }
                ++i2;
            }
        }
        return found;
    }

    @Override
    public void shift(Vector2 shift) {
        int bSize = this.bodies.size();
        int i = 0;
        while (i < bSize) {
            Body body = this.bodies.get(i);
            body.shift(shift);
            ++i;
        }
        int jSize = this.joints.size();
        int i2 = 0;
        while (i2 < jSize) {
            Joint joint = this.joints.get(i2);
            joint.shift(shift);
            ++i2;
        }
        this.broadphaseDetector.shift(shift);
        if (this.bounds != null) {
            this.bounds.shift(shift);
        }
        this.contactManager.shift(shift);
    }

    public void addBody(Body body) {
        if (body == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.addNullBody"));
        }
        if (body.world == this) {
            throw new IllegalArgumentException(Messages.getString("dynamics.world.addExistingBody"));
        }
        if (body.world != null) {
            throw new IllegalArgumentException(Messages.getString("dynamics.world.addOtherWorldBody"));
        }
        this.bodies.add(body);
        body.world = this;
        this.broadphaseDetector.add(body);
    }

    public void addJoint(Joint joint) {
        if (joint == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.addNullJoint"));
        }
        Joint constraint = joint;
        if (constraint.world == this) {
            throw new IllegalArgumentException(Messages.getString("dynamics.world.addExistingBody"));
        }
        if (constraint.world != null) {
            throw new IllegalArgumentException(Messages.getString("dynamics.world.addOtherWorldBody"));
        }
        this.joints.add(joint);
        constraint.world = this;
        Body body1 = joint.getBody1();
        Body body2 = joint.getBody2();
        JointEdge jointEdge1 = new JointEdge(body2, joint);
        body1.joints.add(jointEdge1);
        JointEdge jointEdge2 = new JointEdge(body1, joint);
        body2.joints.add(jointEdge2);
    }

    public boolean containsBody(Body body) {
        return this.bodies.contains(body);
    }

    public boolean containsJoint(Joint joint) {
        return this.joints.contains(joint);
    }

    public boolean removeBody(int index) {
        return this.removeBody(index, false);
    }

    public boolean removeBody(int index, boolean notify) {
        Body body = this.bodies.get(index);
        return this.removeBody(body, notify);
    }

    public boolean removeBody(Body body) {
        return this.removeBody(body, false);
    }

    public boolean removeBody(Body body, boolean notify) {
        List<DestructionListener> listeners = null;
        if (notify) {
            listeners = this.getListeners(DestructionListener.class);
        }
        if (body == null) {
            return false;
        }
        boolean removed = this.bodies.remove(body);
        if (removed) {
            body.world = null;
            this.broadphaseDetector.remove(body);
            Iterator<JointEdge> aIterator = body.joints.iterator();
            while (aIterator.hasNext()) {
                JointEdge jointEdge = aIterator.next();
                aIterator.remove();
                Joint joint = (Joint)jointEdge.interaction;
                Body other = jointEdge.other;
                other.setAsleep(false);
                Iterator<JointEdge> bIterator = other.joints.iterator();
                while (bIterator.hasNext()) {
                    JointEdge otherJointEdge = bIterator.next();
                    Joint otherJoint = (Joint)otherJointEdge.interaction;
                    if (otherJoint != joint) continue;
                    bIterator.remove();
                    break;
                }
                if (notify) {
                    for (DestructionListener dl : listeners) {
                        dl.destroyed(joint);
                    }
                }
                this.joints.remove(joint);
            }
            Iterator<ContactEdge> acIterator = body.contacts.iterator();
            while (acIterator.hasNext()) {
                ContactEdge contactEdge = acIterator.next();
                acIterator.remove();
                ContactConstraint contactConstraint = (ContactConstraint)contactEdge.interaction;
                Body other = contactEdge.other;
                other.setAsleep(false);
                Iterator<ContactEdge> iterator = other.contacts.iterator();
                while (iterator.hasNext()) {
                    ContactEdge otherContactEdge = iterator.next();
                    ContactConstraint otherContactConstraint = (ContactConstraint)otherContactEdge.interaction;
                    if (otherContactConstraint != contactConstraint) continue;
                    iterator.remove();
                    break;
                }
                this.contactManager.end(contactConstraint);
                List<Contact> contacts = contactConstraint.getContacts();
                int size = contacts.size();
                int j = 0;
                while (j < size) {
                    Contact contact = contacts.get(j);
                    ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.getId(), contact.getId()), contactConstraint.getBody1(), contactConstraint.getFixture1(), contactConstraint.getBody2(), contactConstraint.getFixture2(), contact.getPoint(), contactConstraint.getNormal(), contact.getDepth());
                    if (notify) {
                        for (DestructionListener dl : listeners) {
                            dl.destroyed(contactPoint);
                        }
                    }
                    ++j;
                }
            }
        }
        return removed;
    }

    public boolean removeJoint(int index) {
        Joint joint = this.joints.get(index);
        return this.removeJoint(joint);
    }

    public boolean removeJoint(Joint joint) {
        if (joint == null) {
            return false;
        }
        boolean removed = this.joints.remove(joint);
        if (removed) {
            JointEdge jointEdge;
            Body body1 = joint.getBody1();
            Body body2 = joint.getBody2();
            Iterator<JointEdge> iterator = body1.joints.iterator();
            while (iterator.hasNext()) {
                jointEdge = iterator.next();
                if (jointEdge.interaction != joint) continue;
                iterator.remove();
                break;
            }
            iterator = body2.joints.iterator();
            while (iterator.hasNext()) {
                jointEdge = iterator.next();
                if (jointEdge.interaction != joint) continue;
                iterator.remove();
                break;
            }
            body1.setAsleep(false);
            body2.setAsleep(false);
        }
        return removed;
    }

    public void removeAllBodiesAndJoints() {
        this.removeAllBodiesAndJoints(false);
    }

    public void removeAllBodiesAndJoints(boolean notify) {
        List<DestructionListener> listeners = null;
        if (notify) {
            listeners = this.getListeners(DestructionListener.class);
        }
        int bsize = this.bodies.size();
        int i = 0;
        while (i < bsize) {
            Body body = this.bodies.get(i);
            body.joints.clear();
            if (notify) {
                for (ContactEdge contactEdge : body.contacts) {
                    Body other = contactEdge.other;
                    ContactConstraint contactConstraint = (ContactConstraint)contactEdge.interaction;
                    Iterator<ContactEdge> bIterator = other.contacts.iterator();
                    while (bIterator.hasNext()) {
                        ContactEdge otherContactEdge = bIterator.next();
                        ContactConstraint otherContactConstraint = (ContactConstraint)otherContactEdge.interaction;
                        if (otherContactConstraint != contactConstraint) continue;
                        bIterator.remove();
                        break;
                    }
                    List<Contact> contacts = contactConstraint.getContacts();
                    int csize = contacts.size();
                    int j = 0;
                    while (j < csize) {
                        Contact contact = contacts.get(j);
                        ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.getId(), contact.getId()), contactConstraint.getBody1(), contactConstraint.getFixture1(), contactConstraint.getBody2(), contactConstraint.getFixture2(), contact.getPoint(), contactConstraint.getNormal(), contact.getDepth());
                        for (DestructionListener dl : listeners) {
                            dl.destroyed(contactPoint);
                        }
                        ++j;
                    }
                }
                for (DestructionListener dl : listeners) {
                    dl.destroyed(body);
                }
            }
            body.contacts.clear();
            body.world = null;
            ++i;
        }
        if (notify) {
            int jsize = this.joints.size();
            int i2 = 0;
            while (i2 < jsize) {
                Joint joint = this.joints.get(i2);
                for (DestructionListener dl : listeners) {
                    dl.destroyed(joint);
                }
                ++i2;
            }
        }
        this.broadphaseDetector.clear();
        this.joints.clear();
        this.bodies.clear();
        this.contactManager.clear();
    }

    public void removeAllBodies() {
        this.removeAllBodiesAndJoints(false);
    }

    public void removeAllBodies(boolean notify) {
        this.removeAllBodiesAndJoints(notify);
    }

    public void removeAllJoints() {
        this.removeAllJoints(false);
    }

    public void removeAllJoints(boolean notify) {
        List<DestructionListener> listeners = null;
        if (notify) {
            listeners = this.getListeners(DestructionListener.class);
        }
        int jSize = this.joints.size();
        int i = 0;
        while (i < jSize) {
            JointEdge jointEdge;
            Joint joint = this.joints.get(i);
            Body body1 = joint.getBody1();
            Body body2 = joint.getBody2();
            Iterator<JointEdge> iterator = body1.joints.iterator();
            while (iterator.hasNext()) {
                jointEdge = iterator.next();
                if (jointEdge.interaction != joint) continue;
                iterator.remove();
                break;
            }
            iterator = body2.joints.iterator();
            while (iterator.hasNext()) {
                jointEdge = iterator.next();
                if (jointEdge.interaction != joint) continue;
                iterator.remove();
                break;
            }
            body1.setAsleep(false);
            body2.setAsleep(false);
            if (notify) {
                for (DestructionListener dl : listeners) {
                    dl.destroyed(joint);
                }
            }
            ++i;
        }
        this.joints.clear();
    }

    public boolean isUpdateRequired() {
        return this.updateRequired;
    }

    public void setUpdateRequired(boolean flag) {
        this.updateRequired = flag;
    }

    public UUID getId() {
        return this.id;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        if (settings == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullSettings"));
        }
        this.settings = settings;
    }

    public void setGravity(Vector2 gravity) {
        if (gravity == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullGravity"));
        }
        this.gravity = gravity;
    }

    public Vector2 getGravity() {
        return this.gravity;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public <T extends Listener> List<T> getListeners(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList<Listener> listeners = new ArrayList<Listener>();
        int lSize = this.listeners.size();
        int i = 0;
        while (i < lSize) {
            Listener listener = this.listeners.get(i);
            if (clazz.isInstance(listener)) {
                listeners.add((Listener)clazz.cast(listener));
            }
            ++i;
        }
        return listeners;
    }

    public <T extends Listener> void getListeners(Class<T> clazz, List<T> listeners) {
        if (clazz == null || listeners == null) {
            return;
        }
        int lSize = this.listeners.size();
        int i = 0;
        while (i < lSize) {
            Listener listener = this.listeners.get(i);
            if (clazz.isInstance(listener)) {
                listeners.add((Listener)clazz.cast(listener));
            }
            ++i;
        }
    }

    public void addListener(Listener listener) {
        if (listener == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullListener"));
        }
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("dynamics.world.addExistingListener");
        }
        this.listeners.add(listener);
    }

    public boolean containsListener(Listener listener) {
        return this.listeners.contains(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public int removeAllListeners() {
        int count = this.listeners.size();
        this.listeners.clear();
        return count;
    }

    public <T extends Listener> int removeAllListeners(Class<T> clazz) {
        if (clazz == null) {
            return 0;
        }
        if (this.listeners.isEmpty()) {
            return 0;
        }
        int count = 0;
        Iterator<Listener> listenerIterator = this.listeners.iterator();
        while (listenerIterator.hasNext()) {
            Listener listener = listenerIterator.next();
            if (!clazz.isInstance(listener)) continue;
            listenerIterator.remove();
            ++count;
        }
        return count;
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public <T extends Listener> int getListenerCount(Class<T> clazz) {
        if (clazz == null) {
            return 0;
        }
        int count = 0;
        int lSize = this.listeners.size();
        int i = 0;
        while (i < lSize) {
            Listener listener = this.listeners.get(i);
            if (clazz.isInstance(listener)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void setBroadphaseDetector(BroadphaseDetector<Body, BodyFixture> broadphaseDetector) {
        if (broadphaseDetector == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullBroadphaseDetector"));
        }
        this.broadphaseDetector = broadphaseDetector;
        int size = this.bodies.size();
        int i = 0;
        while (i < size) {
            this.broadphaseDetector.add(this.bodies.get(i));
            ++i;
        }
    }

    public BroadphaseDetector<Body, BodyFixture> getBroadphaseDetector() {
        return this.broadphaseDetector;
    }

    public void setNarrowphaseDetector(NarrowphaseDetector narrowphaseDetector) {
        if (narrowphaseDetector == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullNarrowphaseDetector"));
        }
        this.narrowphaseDetector = narrowphaseDetector;
    }

    public NarrowphaseDetector getNarrowphaseDetector() {
        return this.narrowphaseDetector;
    }

    public void setManifoldSolver(ManifoldSolver manifoldSolver) {
        if (manifoldSolver == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullManifoldSolver"));
        }
        this.manifoldSolver = manifoldSolver;
    }

    public ManifoldSolver getManifoldSolver() {
        return this.manifoldSolver;
    }

    public void setTimeOfImpactDetector(TimeOfImpactDetector timeOfImpactDetector) {
        if (timeOfImpactDetector == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullTimeOfImpactDetector"));
        }
        this.timeOfImpactDetector = timeOfImpactDetector;
    }

    public TimeOfImpactDetector getTimeOfImpactDetector() {
        return this.timeOfImpactDetector;
    }

    public void setRaycastDetector(RaycastDetector raycastDetector) {
        if (raycastDetector == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullRaycastDetector"));
        }
        this.raycastDetector = raycastDetector;
    }

    public RaycastDetector getRaycastDetector() {
        return this.raycastDetector;
    }

    public CoefficientMixer getCoefficientMixer() {
        return this.coefficientMixer;
    }

    public void setCoefficientMixer(CoefficientMixer coefficientMixer) {
        if (coefficientMixer == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullCoefficientMixer"));
        }
        this.coefficientMixer = coefficientMixer;
    }

    public void setContactManager(ContactManager contactManager) {
        if (contactManager == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullContactManager"));
        }
        this.contactManager = contactManager;
        this.updateRequired = true;
    }

    public ContactManager getContactManager() {
        return this.contactManager;
    }

    public void setContactConstraintSolver(ContactConstraintSolver constraintSolver) {
        if (constraintSolver == null) {
            throw new NullPointerException(Messages.getString("dynamics.world.nullContactConstraintSolver"));
        }
        this.contactConstraintSolver = constraintSolver;
    }

    public ContactConstraintSolver getContactConstraintSolver() {
        return this.contactConstraintSolver;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public int getBodyCount() {
        return this.bodies.size();
    }

    public Body getBody(int index) {
        return this.bodies.get(index);
    }

    public List<Body> getBodies() {
        return Collections.unmodifiableList(this.bodies);
    }

    public Iterator<Body> getBodyIterator() {
        return new BodyIterator(this);
    }

    public int getJointCount() {
        return this.joints.size();
    }

    public Joint getJoint(int index) {
        return this.joints.get(index);
    }

    public List<Joint> getJoints() {
        return Collections.unmodifiableList(this.joints);
    }

    public Iterator<Joint> getJointIterator() {
        return new JointIterator(this);
    }

    public Step getStep() {
        return this.step;
    }

    public boolean isEmpty() {
        int bSize = this.bodies.size();
        int jSize = this.joints.size();
        return bSize == 0 && jSize == 0;
    }

    public double getAccumulatedTime() {
        return this.time;
    }

    public void setAccumulatedTime(double elapsedTime) {
        if (elapsedTime < 0.0) {
            return;
        }
        this.time = elapsedTime;
    }
}

