/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.collision.manifold.Manifold;
import org.dyn4j.collision.manifold.ManifoldPoint;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.Constraint;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraintId;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Vector2;

public class ContactConstraint
extends Constraint
implements Shiftable {
    protected final ContactConstraintId id;
    protected final BodyFixture fixture1;
    protected final BodyFixture fixture2;
    protected final List<Contact> contacts;
    protected Vector2 normal;
    protected Vector2 tangent;
    protected double friction;
    protected double restitution;
    protected boolean sensor;
    protected double tangentSpeed;
    Matrix22 K;
    Matrix22 invK;

    public ContactConstraint(Body body1, BodyFixture fixture1, Body body2, BodyFixture fixture2, Manifold manifold, double friction, double restitution) {
        super(body1, body2);
        this.fixture1 = fixture1;
        this.fixture2 = fixture2;
        this.id = new ContactConstraintId(body1, fixture1, body2, fixture2);
        List<ManifoldPoint> points = manifold.getPoints();
        int mSize = points.size();
        this.contacts = new ArrayList<Contact>(mSize);
        int l = 0;
        while (l < mSize) {
            ManifoldPoint point = points.get(l);
            Contact contact = new Contact(point.getId(), point.getPoint(), point.getDepth(), this.body1.getLocalPoint(point.getPoint()), this.body2.getLocalPoint(point.getPoint()));
            this.contacts.add(contact);
            ++l;
        }
        this.normal = manifold.getNormal();
        this.tangent = this.normal.cross(1.0);
        this.friction = friction;
        this.restitution = restitution;
        this.sensor = fixture1.isSensor() || fixture2.isSensor();
        this.tangentSpeed = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ContactConstraint[").append(super.toString()).append("|Body1=").append(this.body1.getId()).append("|Fixture1=").append(this.fixture1.getId()).append("|Body2=").append(this.body2.getId()).append("|Fixture2=").append(this.fixture2.getId()).append("|Normal=").append(this.normal).append("|Tangent=").append(this.tangent).append("|Friction=").append(this.friction).append("|Restitution=").append(this.restitution).append("|IsSensor=").append(this.sensor).append("|TangentSpeed=").append(this.tangentSpeed).append("|Contacts={");
        int size = this.contacts.size();
        int i = 0;
        while (i < size) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.contacts.get(i));
            ++i;
        }
        sb.append("}]");
        return sb.toString();
    }

    @Override
    public void shift(Vector2 shift) {
        int size = this.contacts.size();
        int i = 0;
        while (i < size) {
            Contact c = this.contacts.get(i);
            c.p.add(shift);
            ++i;
        }
    }

    public ContactConstraintId getId() {
        return this.id;
    }

    public Vector2 getNormal() {
        return this.normal;
    }

    public Vector2 getTangent() {
        return this.tangent;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    @Override
    public Body getBody1() {
        return this.body1;
    }

    public BodyFixture getFixture1() {
        return this.fixture1;
    }

    @Override
    public Body getBody2() {
        return this.body2;
    }

    public BodyFixture getFixture2() {
        return this.fixture2;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double friction) {
        this.friction = friction;
    }

    public double getRestitution() {
        return this.restitution;
    }

    public void setRestitution(double restitution) {
        this.restitution = restitution;
    }

    public boolean isSensor() {
        return this.sensor;
    }

    public void setSensor(boolean flag) {
        this.sensor = flag;
    }

    public double getTangentSpeed() {
        return this.tangentSpeed;
    }

    public void setTangentSpeed(double speed) {
        this.tangentSpeed = speed;
    }
}

