/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class ContactPoint {
    protected final ContactPointId id;
    protected final Body body1;
    protected final Body body2;
    protected final BodyFixture fixture1;
    protected final BodyFixture fixture2;
    protected Vector2 point;
    protected Vector2 normal;
    protected double depth;

    public ContactPoint(ContactPointId id, Body body1, BodyFixture fixture1, Body body2, BodyFixture fixture2, Vector2 point, Vector2 normal, double depth) {
        this.id = id;
        this.body1 = body1;
        this.fixture1 = fixture1;
        this.body2 = body2;
        this.fixture2 = fixture2;
        this.point = point;
        this.normal = normal;
        this.depth = depth;
    }

    public ContactPoint(ContactPoint contactPoint) {
        if (contactPoint == null) {
            throw new NullPointerException(Messages.getString("dynamics.contact.contactPoint.nullContactPoint"));
        }
        this.id = contactPoint.id;
        this.body1 = contactPoint.body1;
        this.fixture1 = contactPoint.fixture1;
        this.body2 = contactPoint.body2;
        this.fixture2 = contactPoint.fixture2;
        this.point = contactPoint.point;
        this.normal = contactPoint.normal;
        this.depth = contactPoint.depth;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ContactPoint[Id=").append(this.id).append("|Body1=").append(this.body1.getId()).append("|Fixture1=").append(this.fixture1.getId()).append("|Body2=").append(this.body2.getId()).append("|Fixture2=").append(this.fixture2.getId()).append("|Point=").append(this.point).append("|Normal=").append(this.normal).append("|Depth=").append(this.depth).append("]");
        return sb.toString();
    }

    public ContactPointId getId() {
        return this.id;
    }

    public Vector2 getPoint() {
        return this.point;
    }

    public Vector2 getNormal() {
        return this.normal;
    }

    public double getDepth() {
        return this.depth;
    }

    public Body getBody1() {
        return this.body1;
    }

    public Body getBody2() {
        return this.body2;
    }

    public BodyFixture getFixture1() {
        return this.fixture1;
    }

    public BodyFixture getFixture2() {
        return this.fixture2;
    }
}

