/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactConstraintSolver;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class SequentialImpulses
implements ContactConstraintSolver {
    @Override
    public void initialize(List<ContactConstraint> contactConstraints, Step step, Settings settings) {
        double restitutionVelocity = settings.getRestitutionVelocity();
        int size = contactConstraints.size();
        int i = 0;
        while (i < size) {
            ContactConstraint contactConstraint = contactConstraints.get(i);
            Body b1 = contactConstraint.getBody1();
            Body b2 = contactConstraint.getBody2();
            Transform t1 = b1.getTransform();
            Transform t2 = b2.getTransform();
            Mass m1 = b1.getMass();
            Mass m2 = b2.getMass();
            double invM1 = m1.getInverseMass();
            double invM2 = m2.getInverseMass();
            double invI1 = m1.getInverseInertia();
            double invI2 = m2.getInverseInertia();
            Vector2 c1 = t1.getTransformed(m1.getCenter());
            Vector2 c2 = t2.getTransformed(m2.getCenter());
            List<Contact> contacts = contactConstraint.contacts;
            int cSize = contacts.size();
            Vector2 N = contactConstraint.normal;
            Vector2 T = contactConstraint.tangent;
            int j = 0;
            while (j < cSize) {
                Vector2 lv2;
                Contact contact = contacts.get(j);
                Vector2 r1 = c1.to(contact.p);
                Vector2 r2 = c2.to(contact.p);
                contact.r1 = r1;
                contact.r2 = r2;
                double r1CrossN = r1.cross(N);
                double r2CrossN = r2.cross(N);
                contact.massN = 1.0 / (invM1 + invM2 + invI1 * r1CrossN * r1CrossN + invI2 * r2CrossN * r2CrossN);
                double r1CrossT = r1.cross(T);
                double r2CrossT = r2.cross(T);
                contact.massT = 1.0 / (invM1 + invM2 + invI1 * r1CrossT * r1CrossT + invI2 * r2CrossT * r2CrossT);
                contact.vb = 0.0;
                Vector2 lv1 = r1.cross(b1.getAngularVelocity()).add(b1.getLinearVelocity());
                Vector2 rv = lv1.subtract(lv2 = r2.cross(b2.getAngularVelocity()).add(b2.getLinearVelocity()));
                double rvn = N.dot(rv);
                if (rvn < -restitutionVelocity) {
                    contact.vb += -contactConstraint.restitution * rvn;
                }
                ++j;
            }
            if (cSize == 2) {
                Contact contact1 = contacts.get(0);
                Contact contact2 = contacts.get(1);
                double rn1A = contact1.r1.cross(N);
                double rn1B = contact1.r2.cross(N);
                double rn2A = contact2.r1.cross(N);
                double rn2B = contact2.r2.cross(N);
                Matrix22 K = new Matrix22();
                K.m00 = invM1 + invM2 + invI1 * rn1A * rn1A + invI2 * rn1B * rn1B;
                K.m10 = K.m01 = invM1 + invM2 + invI1 * rn1A * rn2A + invI2 * rn1B * rn2B;
                K.m11 = invM1 + invM2 + invI1 * rn2A * rn2A + invI2 * rn2B * rn2B;
                double maxCondition = 1000.0;
                if (K.m00 * K.m00 < 1000.0 * K.determinant()) {
                    contactConstraint.K = K;
                    contactConstraint.invK = K.getInverse();
                } else if (contact1.depth > contact2.depth) {
                    contactConstraint.contacts.remove(1);
                } else {
                    contactConstraint.contacts.remove(0);
                }
            }
            ++i;
        }
        this.warmStart(contactConstraints, step, settings);
    }

    protected void warmStart(List<ContactConstraint> contactConstraints, Step step, Settings settings) {
        double ratio = 1.0 / step.getDeltaTimeRatio();
        int size = contactConstraints.size();
        int i = 0;
        while (i < size) {
            ContactConstraint contactConstraint = contactConstraints.get(i);
            Body b1 = contactConstraint.getBody1();
            Body b2 = contactConstraint.getBody2();
            Mass m1 = b1.getMass();
            Mass m2 = b2.getMass();
            double invM1 = m1.getInverseMass();
            double invM2 = m2.getInverseMass();
            double invI1 = m1.getInverseInertia();
            double invI2 = m2.getInverseInertia();
            Vector2 N = contactConstraint.normal;
            Vector2 T = contactConstraint.tangent;
            List<Contact> contacts = contactConstraint.getContacts();
            int cSize = contacts.size();
            if (cSize != 0) {
                int j = 0;
                while (j < cSize) {
                    Contact contact = contacts.get(j);
                    contact.jn *= ratio;
                    contact.jt *= ratio;
                    Vector2 J = new Vector2(N.x * contact.jn + T.x * contact.jt, N.y * contact.jn + T.y * contact.jt);
                    b1.getLinearVelocity().add(J.x * invM1, J.y * invM1);
                    b1.setAngularVelocity(b1.getAngularVelocity() + invI1 * contact.r1.cross(J));
                    b2.getLinearVelocity().subtract(J.x * invM2, J.y * invM2);
                    b2.setAngularVelocity(b2.getAngularVelocity() - invI2 * contact.r2.cross(J));
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void solveVelocityContraints(List<ContactConstraint> contactConstraints, Step step, Settings settings) {
        int size = contactConstraints.size();
        int i = 0;
        while (i < size) {
            ContactConstraint contactConstraint = contactConstraints.get(i);
            Body b1 = contactConstraint.getBody1();
            Body b2 = contactConstraint.getBody2();
            Mass m1 = b1.getMass();
            Mass m2 = b2.getMass();
            double invM1 = m1.getInverseMass();
            double invM2 = m2.getInverseMass();
            double invI1 = m1.getInverseInertia();
            double invI2 = m2.getInverseInertia();
            List<Contact> contacts = contactConstraint.contacts;
            int cSize = contacts.size();
            if (cSize != 0) {
                Vector2 N = contactConstraint.normal;
                Vector2 T = contactConstraint.tangent;
                double tangentSpeed = contactConstraint.tangentSpeed;
                int k = 0;
                while (k < cSize) {
                    Contact contact = contacts.get(k);
                    Vector2 r1 = contact.r1;
                    Vector2 r2 = contact.r2;
                    Vector2 lv1 = r1.cross(b1.getAngularVelocity()).add(b1.getLinearVelocity());
                    Vector2 lv2 = r2.cross(b2.getAngularVelocity()).add(b2.getLinearVelocity());
                    Vector2 rv = lv1.subtract(lv2);
                    double rvt = T.dot(rv) - tangentSpeed;
                    double jt = contact.massT * -rvt;
                    double maxJt = contactConstraint.friction * contact.jn;
                    double Jt0 = contact.jt;
                    contact.jt = Math.max(-maxJt, Math.min(Jt0 + jt, maxJt));
                    jt = contact.jt - Jt0;
                    Vector2 J = new Vector2(T.x * jt, T.y * jt);
                    b1.getLinearVelocity().add(J.x * invM1, J.y * invM1);
                    b1.setAngularVelocity(b1.getAngularVelocity() + invI1 * r1.cross(J));
                    b2.getLinearVelocity().subtract(J.x * invM2, J.y * invM2);
                    b2.setAngularVelocity(b2.getAngularVelocity() - invI2 * r2.cross(J));
                    ++k;
                }
                if (cSize == 1) {
                    Contact contact = contacts.get(0);
                    Vector2 r1 = contact.r1;
                    Vector2 r2 = contact.r2;
                    Vector2 lv1 = r1.cross(b1.getAngularVelocity()).add(b1.getLinearVelocity());
                    Vector2 lv2 = r2.cross(b2.getAngularVelocity()).add(b2.getLinearVelocity());
                    Vector2 rv = lv1.subtract(lv2);
                    double rvn = N.dot(rv);
                    double j = -contact.massN * (rvn - contact.vb);
                    double j0 = contact.jn;
                    contact.jn = Math.max(j0 + j, 0.0);
                    j = contact.jn - j0;
                    Vector2 J = new Vector2(N.x * j, N.y * j);
                    b1.getLinearVelocity().add(J.x * invM1, J.y * invM1);
                    b1.setAngularVelocity(b1.getAngularVelocity() + invI1 * r1.cross(J));
                    b2.getLinearVelocity().subtract(J.x * invM2, J.y * invM2);
                    b2.setAngularVelocity(b2.getAngularVelocity() - invI2 * r2.cross(J));
                } else {
                    Vector2 J2;
                    Vector2 J1;
                    Vector2 d;
                    Contact contact1 = contacts.get(0);
                    Contact contact2 = contacts.get(1);
                    Vector2 r11 = contact1.r1;
                    Vector2 r21 = contact1.r2;
                    Vector2 r12 = contact2.r1;
                    Vector2 r22 = contact2.r2;
                    Vector2 v1 = b1.getLinearVelocity();
                    Vector2 v2 = b2.getLinearVelocity();
                    double av1 = b1.getAngularVelocity();
                    double av2 = b2.getAngularVelocity();
                    Vector2 a = new Vector2(contact1.jn, contact2.jn);
                    Vector2 rv1 = new Vector2();
                    rv1.x = -r11.y * av1 + v1.x + r21.y * av2 - v2.x;
                    rv1.y = r11.x * av1 + v1.y - r21.x * av2 - v2.y;
                    Vector2 rv2 = new Vector2();
                    rv2.x = -r12.y * av1 + v1.x + r22.y * av2 - v2.x;
                    rv2.y = r12.x * av1 + v1.y - r22.x * av2 - v2.y;
                    double rvn1 = N.dot(rv1);
                    double rvn2 = N.dot(rv2);
                    Vector2 b = new Vector2();
                    b.x = rvn1 - contact1.vb;
                    b.y = rvn2 - contact2.vb;
                    b.subtract(contactConstraint.K.product(a));
                    Vector2 x = contactConstraint.invK.product(b).negate();
                    if (x.x >= 0.0 && x.y >= 0.0) {
                        d = x.difference(a);
                        J1 = N.product(d.x);
                        J2 = N.product(d.y);
                        v1.add((J1.x + J2.x) * invM1, (J1.y + J2.y) * invM1);
                        b1.setAngularVelocity(av1 + invI1 * (r11.cross(J1) + r12.cross(J2)));
                        v2.subtract((J1.x + J2.x) * invM2, (J1.y + J2.y) * invM2);
                        b2.setAngularVelocity(av2 - invI2 * (r21.cross(J1) + r22.cross(J2)));
                        contact1.jn = x.x;
                        contact2.jn = x.y;
                    } else {
                        x.x = -contact1.massN * b.x;
                        x.y = 0.0;
                        rvn1 = 0.0;
                        rvn2 = contactConstraint.K.m10 * x.x + b.y;
                        if (x.x >= 0.0 && rvn2 >= 0.0) {
                            d = x.difference(a);
                            J1 = N.product(d.x);
                            J2 = N.product(d.y);
                            v1.add((J1.x + J2.x) * invM1, (J1.y + J2.y) * invM1);
                            b1.setAngularVelocity(av1 + invI1 * (r11.cross(J1) + r12.cross(J2)));
                            v2.subtract((J1.x + J2.x) * invM2, (J1.y + J2.y) * invM2);
                            b2.setAngularVelocity(av2 - invI2 * (r21.cross(J1) + r22.cross(J2)));
                            contact1.jn = x.x;
                            contact2.jn = x.y;
                        } else {
                            x.x = 0.0;
                            x.y = -contact2.massN * b.y;
                            rvn1 = contactConstraint.K.m01 * x.y + b.x;
                            rvn2 = 0.0;
                            if (x.y >= 0.0 && rvn1 >= 0.0) {
                                d = x.difference(a);
                                J1 = N.product(d.x);
                                J2 = N.product(d.y);
                                v1.add((J1.x + J2.x) * invM1, (J1.y + J2.y) * invM1);
                                b1.setAngularVelocity(av1 + invI1 * (r11.cross(J1) + r12.cross(J2)));
                                v2.subtract((J1.x + J2.x) * invM2, (J1.y + J2.y) * invM2);
                                b2.setAngularVelocity(av2 - invI2 * (r21.cross(J1) + r22.cross(J2)));
                                contact1.jn = x.x;
                                contact2.jn = x.y;
                            } else {
                                x.x = 0.0;
                                x.y = 0.0;
                                rvn1 = b.x;
                                rvn2 = b.y;
                                if (rvn1 >= 0.0 && rvn2 >= 0.0) {
                                    d = x.difference(a);
                                    J1 = N.product(d.x);
                                    J2 = N.product(d.y);
                                    v1.add((J1.x + J2.x) * invM1, (J1.y + J2.y) * invM1);
                                    b1.setAngularVelocity(av1 + invI1 * (r11.cross(J1) + r12.cross(J2)));
                                    v2.subtract((J1.x + J2.x) * invM2, (J1.y + J2.y) * invM2);
                                    b2.setAngularVelocity(av2 - invI2 * (r21.cross(J1) + r22.cross(J2)));
                                    contact1.jn = x.x;
                                    contact2.jn = x.y;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public boolean solvePositionContraints(List<ContactConstraint> contactConstraints, Step step, Settings settings) {
        if (contactConstraints.isEmpty()) {
            return true;
        }
        double minSeparation = 0.0;
        double maxLinearCorrection = settings.getMaximumLinearCorrection();
        double allowedPenetration = settings.getLinearTolerance();
        double baumgarte = settings.getBaumgarte();
        int size = contactConstraints.size();
        int i = 0;
        while (i < size) {
            ContactConstraint contactConstraint = contactConstraints.get(i);
            Body b1 = contactConstraint.getBody1();
            Body b2 = contactConstraint.getBody2();
            Transform t1 = b1.getTransform();
            Transform t2 = b2.getTransform();
            Mass m1 = b1.getMass();
            Mass m2 = b2.getMass();
            double mass1 = m1.getMass();
            double mass2 = m2.getMass();
            List<Contact> contacts = contactConstraint.contacts;
            int cSize = contacts.size();
            if (cSize != 0) {
                Vector2 N = contactConstraint.normal;
                double invMass1 = mass1 * m1.getInverseMass();
                double invI1 = mass1 * m1.getInverseInertia();
                double invMass2 = mass2 * m2.getInverseMass();
                double invI2 = mass2 * m2.getInverseInertia();
                int k = 0;
                while (k < cSize) {
                    Contact contact = contacts.get(k);
                    Vector2 c1 = t1.getTransformed(m1.getCenter());
                    Vector2 c2 = t2.getTransformed(m2.getCenter());
                    Vector2 r1 = contact.p1.difference(m1.getCenter());
                    t1.transformR(r1);
                    Vector2 r2 = contact.p2.difference(m2.getCenter());
                    t2.transformR(r2);
                    Vector2 p1 = c1.sum(r1);
                    Vector2 p2 = c2.sum(r2);
                    Vector2 dp = p1.subtract(p2);
                    double penetration = dp.dot(N) - contact.depth;
                    minSeparation = Math.min(minSeparation, penetration);
                    double cp = baumgarte * Interval.clamp(penetration + allowedPenetration, -maxLinearCorrection, 0.0);
                    double rn1 = r1.cross(N);
                    double rn2 = r2.cross(N);
                    double K = invMass1 + invMass2 + invI1 * rn1 * rn1 + invI2 * rn2 * rn2;
                    double jp = 0.0;
                    if (K > Epsilon.E) {
                        jp = -cp / K;
                    }
                    double jp0 = contact.jp;
                    contact.jp = Math.max(jp0 + jp, 0.0);
                    jp = contact.jp - jp0;
                    Vector2 J = N.product(jp);
                    b1.translate(J.product(invMass1));
                    b1.rotate(invI1 * r1.cross(J), c1.x, c1.y);
                    b2.translate(J.product(-invMass2));
                    b2.rotate(-invI2 * r2.cross(J), c2.x, c2.y);
                    ++k;
                }
            }
            ++i;
        }
        return minSeparation >= -3.0 * allowedPenetration;
    }
}

