/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dyn4j.collision.Collisions;
import org.dyn4j.collision.manifold.ManifoldPointId;
import org.dyn4j.dynamics.Capacity;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactConstraintId;
import org.dyn4j.dynamics.contact.ContactListener;
import org.dyn4j.dynamics.contact.ContactManager;
import org.dyn4j.dynamics.contact.ContactPoint;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.dynamics.contact.PersistedContactPoint;
import org.dyn4j.dynamics.contact.SimpleContactManager;
import org.dyn4j.geometry.Shiftable;

public class WarmStartingContactManager
extends SimpleContactManager
implements ContactManager,
Shiftable {
    Map<ContactConstraintId, ContactConstraint> constraints1 = null;

    public WarmStartingContactManager() {
        this(Capacity.DEFAULT_CAPACITY);
    }

    public WarmStartingContactManager(Capacity initialCapacity) {
        super(initialCapacity);
        int eSize = Collisions.getEstimatedCollisionPairs(initialCapacity.getBodyCount());
        this.constraints1 = new HashMap<ContactConstraintId, ContactConstraint>(eSize * 4 / 3 + 1, 0.75f);
    }

    @Override
    public void updateAndNotify(List<ContactListener> listeners, Settings settings) {
        int size = this.constraintQueue.size();
        int lsize = listeners != null ? listeners.size() : 0;
        double warmStartDistanceSquared = settings.getWarmStartDistanceSquared();
        Map<ContactConstraintId, ContactConstraint> newMap = this.constraints1;
        int i = 0;
        while (i < size) {
            ContactPoint point;
            Contact contact;
            ContactConstraint newContactConstraint = (ContactConstraint)this.constraintQueue.get(i);
            ContactConstraint oldContactConstraint = null;
            List<Contact> contacts = newContactConstraint.contacts;
            int nsize = contacts.size();
            if (newContactConstraint.sensor) {
                int j = 0;
                while (j < nsize) {
                    contact = contacts.get(j);
                    point = new ContactPoint(new ContactPointId(newContactConstraint.id, contact.id), newContactConstraint.getBody1(), newContactConstraint.fixture1, newContactConstraint.getBody2(), newContactConstraint.fixture2, contact.p, newContactConstraint.normal, contact.depth);
                    int l = 0;
                    while (l < lsize) {
                        ContactListener listener = listeners.get(l);
                        listener.sensed(point);
                        ++l;
                    }
                    ++j;
                }
            } else {
                oldContactConstraint = (ContactConstraint)this.constraints.remove(newContactConstraint.id);
                if (oldContactConstraint != null) {
                    List<Contact> ocontacts = oldContactConstraint.contacts;
                    int osize = ocontacts.size();
                    boolean[] persisted = new boolean[osize];
                    int j = nsize - 1;
                    while (j >= 0) {
                        Contact newContact = contacts.get(j);
                        boolean found = false;
                        int k = 0;
                        while (k < osize) {
                            Contact oldContact = ocontacts.get(k);
                            if (newContact.id == ManifoldPointId.DISTANCE && newContact.p.distanceSquared(oldContact.p) <= warmStartDistanceSquared || newContact.id.equals(oldContact.id)) {
                                newContact.jn = oldContact.jn;
                                newContact.jt = oldContact.jt;
                                PersistedContactPoint point2 = new PersistedContactPoint(new ContactPointId(newContactConstraint.id, newContact.id), newContactConstraint.getBody1(), newContactConstraint.fixture1, newContactConstraint.getBody2(), newContactConstraint.fixture2, newContact.p, newContactConstraint.normal, newContact.depth, oldContact.p, oldContactConstraint.normal, oldContact.depth);
                                boolean allow = true;
                                int l = 0;
                                while (l < lsize) {
                                    ContactListener listener = listeners.get(l);
                                    if (!listener.persist(point2)) {
                                        allow = false;
                                    }
                                    ++l;
                                }
                                if (!allow) {
                                    contacts.remove(j);
                                }
                                persisted[k] = true;
                                found = true;
                                break;
                            }
                            ++k;
                        }
                        if (!found) {
                            ContactPoint point3 = new ContactPoint(new ContactPointId(newContactConstraint.id, newContact.id), newContactConstraint.getBody1(), newContactConstraint.fixture1, newContactConstraint.getBody2(), newContactConstraint.fixture2, newContact.p, newContactConstraint.normal, newContact.depth);
                            boolean allow = true;
                            int l = 0;
                            while (l < lsize) {
                                ContactListener listener = listeners.get(l);
                                if (!listener.begin(point3)) {
                                    allow = false;
                                }
                                ++l;
                            }
                            if (!allow) {
                                contacts.remove(j);
                            }
                        }
                        --j;
                    }
                    int rsize = persisted.length;
                    int j2 = 0;
                    while (j2 < rsize) {
                        if (!persisted[j2]) {
                            Contact contact2 = ocontacts.get(j2);
                            ContactPoint point4 = new ContactPoint(new ContactPointId(newContactConstraint.id, contact2.id), newContactConstraint.getBody1(), newContactConstraint.fixture1, newContactConstraint.getBody2(), newContactConstraint.fixture2, contact2.p, newContactConstraint.normal, contact2.depth);
                            int l = 0;
                            while (l < lsize) {
                                ContactListener listener = listeners.get(l);
                                listener.end(point4);
                                ++l;
                            }
                        }
                        ++j2;
                    }
                } else {
                    int j = nsize - 1;
                    while (j >= 0) {
                        contact = contacts.get(j);
                        point = new ContactPoint(new ContactPointId(newContactConstraint.id, contact.id), newContactConstraint.getBody1(), newContactConstraint.fixture1, newContactConstraint.getBody2(), newContactConstraint.fixture2, contact.p, newContactConstraint.normal, contact.depth);
                        boolean allow = true;
                        int l = 0;
                        while (l < lsize) {
                            ContactListener listener = listeners.get(l);
                            if (!listener.begin(point)) {
                                allow = false;
                            }
                            ++l;
                        }
                        if (!allow) {
                            contacts.remove(j);
                        }
                        --j;
                    }
                }
                if (newContactConstraint.contacts.size() > 0) {
                    newMap.put(newContactConstraint.id, newContactConstraint);
                }
            }
            ++i;
        }
        if (!this.constraints.isEmpty()) {
            for (ContactConstraint contactConstraint : this.constraints.values()) {
                int rsize = contactConstraint.contacts.size();
                int i2 = 0;
                while (i2 < rsize) {
                    Contact contact = contactConstraint.contacts.get(i2);
                    ContactPoint point = new ContactPoint(new ContactPointId(contactConstraint.id, contact.id), contactConstraint.getBody1(), contactConstraint.fixture1, contactConstraint.getBody2(), contactConstraint.fixture2, contact.p, contactConstraint.normal, contact.depth);
                    int l = 0;
                    while (l < lsize) {
                        ContactListener listener = listeners.get(l);
                        listener.end(point);
                        ++l;
                    }
                    ++i2;
                }
            }
        }
        if (size > 0) {
            this.constraints.clear();
            this.constraints1 = this.constraints;
            this.constraints = newMap;
        } else {
            this.constraints.clear();
        }
        this.constraintQueue.clear();
    }
}

