/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.dynamics.joint.LimitState;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class AngleJoint
extends Joint
implements Shiftable,
DataContainer {
    protected double ratio;
    protected double lowerLimit;
    protected double upperLimit;
    protected boolean limitEnabled;
    protected double referenceAngle;
    private LimitState limitState;
    private double invK;
    private double impulse;

    public AngleJoint(Body body1, Body body2) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        this.ratio = 1.0;
        this.impulse = 0.0;
        this.upperLimit = this.referenceAngle = body1.getTransform().getRotation() - body2.getTransform().getRotation();
        this.lowerLimit = this.referenceAngle;
        this.limitEnabled = true;
        this.limitState = LimitState.EQUAL;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AngleJoint[").append(super.toString()).append("|Ratio=").append(this.ratio).append("|LowerLimit=").append(this.lowerLimit).append("|UpperLimit=").append(this.upperLimit).append("|IsLimitEnabled=").append(this.limitEnabled).append("|ReferenceAngle=").append(this.referenceAngle).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        double angularTolerance = settings.getAngularTolerance();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        if (this.limitEnabled) {
            double angle = this.getRelativeRotation();
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * angularTolerance) {
                this.limitState = LimitState.EQUAL;
            } else if (this.upperLimit > this.lowerLimit) {
                if (angle >= this.upperLimit) {
                    if (this.limitState != LimitState.AT_UPPER) {
                        this.impulse = 0.0;
                    }
                    this.limitState = LimitState.AT_UPPER;
                } else if (angle <= this.lowerLimit) {
                    if (this.limitState != LimitState.AT_LOWER) {
                        this.impulse = 0.0;
                    }
                    this.limitState = LimitState.AT_LOWER;
                } else {
                    this.limitState = LimitState.INACTIVE;
                    this.impulse = 0.0;
                }
            }
        } else {
            this.limitState = LimitState.INACTIVE;
            this.impulse = 0.0;
        }
        this.invK = this.limitState == LimitState.INACTIVE ? invI1 + this.ratio * this.ratio * invI2 : invI1 + invI2;
        if (this.invK > Epsilon.E) {
            this.invK = 1.0 / this.invK;
        }
        this.impulse *= step.getDeltaTimeRatio();
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * this.impulse);
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * this.impulse * (this.limitState == LimitState.INACTIVE ? this.ratio : 1.0));
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        if (this.limitState != LimitState.INACTIVE) {
            double newImpulse;
            double C = this.body1.getAngularVelocity() - this.body2.getAngularVelocity();
            double impulse = this.invK * -C;
            if (this.limitState == LimitState.EQUAL) {
                this.impulse += impulse;
            } else if (this.limitState == LimitState.AT_LOWER) {
                double newImpulse2 = this.impulse + impulse;
                if (newImpulse2 < 0.0) {
                    impulse = -this.impulse;
                    this.impulse = 0.0;
                }
            } else if (this.limitState == LimitState.AT_UPPER && (newImpulse = this.impulse + impulse) > 0.0) {
                impulse = -this.impulse;
                this.impulse = 0.0;
            }
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * impulse);
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * impulse);
        } else if (this.ratio != 1.0) {
            double C = this.body1.getAngularVelocity() - this.ratio * this.body2.getAngularVelocity();
            double impulse = this.invK * -C;
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * impulse);
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * impulse * this.ratio);
        }
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        if (this.limitState != LimitState.INACTIVE) {
            double angularTolerance = settings.getAngularTolerance();
            double maxAngularCorrection = settings.getMaximumAngularCorrection();
            Mass m1 = this.body1.getMass();
            Mass m2 = this.body2.getMass();
            double invI1 = m1.getInverseInertia();
            double invI2 = m2.getInverseInertia();
            double angle = this.getRelativeRotation();
            double impulse = 0.0;
            double angularError = 0.0;
            if (this.limitState == LimitState.EQUAL) {
                double j = Interval.clamp(angle - this.lowerLimit, -maxAngularCorrection, maxAngularCorrection);
                impulse = -j * this.invK;
                angularError = Math.abs(j);
            } else if (this.limitState == LimitState.AT_LOWER) {
                double j = angle - this.lowerLimit;
                angularError = -j;
                j = Interval.clamp(j + angularTolerance, -maxAngularCorrection, 0.0);
                impulse = -j * this.invK;
            } else if (this.limitState == LimitState.AT_UPPER) {
                double j;
                angularError = j = angle - this.upperLimit;
                j = Interval.clamp(j - angularTolerance, 0.0, maxAngularCorrection);
                impulse = -j * this.invK;
            }
            this.body1.rotateAboutCenter(invI1 * impulse);
            this.body2.rotateAboutCenter(-invI2 * impulse);
            return angularError <= angularTolerance;
        }
        return true;
    }

    private double getRelativeRotation() {
        double rr = this.body1.getTransform().getRotation() - this.body2.getTransform().getRotation() - this.referenceAngle;
        if (rr < -Math.PI) {
            rr += Math.PI * 2;
        }
        if (rr > Math.PI) {
            rr -= Math.PI * 2;
        }
        return rr;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldCenter();
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldCenter();
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        return new Vector2();
    }

    @Override
    public double getReactionTorque(double invdt) {
        return this.impulse * invdt;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    public double getJointAngle() {
        return this.getRelativeRotation();
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public void setLimitEnabled(boolean flag) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.limitEnabled = flag;
    }

    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        if (upperLimit < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimit = upperLimit;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        if (lowerLimit > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.lowerLimit = lowerLimit;
    }

    public void setLimits(double lowerLimit, double upperLimit) {
        if (lowerLimit > upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimit = upperLimit;
        this.lowerLimit = lowerLimit;
    }

    public void setLimitsEnabled(double lowerLimit, double upperLimit) {
        this.setLimits(lowerLimit, upperLimit);
        this.limitEnabled = true;
    }

    public void setLimits(double limit) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimit = limit;
        this.lowerLimit = limit;
    }

    public void setLimitsEnabled(double limit) {
        this.setLimits(limit);
        this.limitEnabled = true;
    }

    public double getReferenceAngle() {
        return this.referenceAngle;
    }

    public void setReferenceAngle(double angle) {
        this.referenceAngle = angle;
    }

    public LimitState getLimitState() {
        return this.limitState;
    }
}

