/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class DistanceJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double frequency;
    protected double dampingRatio;
    protected double distance;
    private double invK;
    private Vector2 n;
    private double bias;
    private double gamma;
    private double impulse;

    public DistanceJoint(Body body1, Body body2, Vector2 anchor1, Vector2 anchor2) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (anchor1 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor1"));
        }
        if (anchor2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor2"));
        }
        this.localAnchor1 = body1.getLocalPoint(anchor1);
        this.localAnchor2 = body2.getLocalPoint(anchor2);
        this.distance = anchor1.distance(anchor2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DistanceJoint[").append(super.toString()).append("|Anchor1=").append(this.getAnchor1()).append("|Anchor2=").append(this.getAnchor2()).append("|Frequency=").append(this.frequency).append("|DampingRatio=").append(this.dampingRatio).append("|Distance=").append(this.distance).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        double linearTolerance = settings.getLinearTolerance();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.n = r1.sum(this.body1.getWorldCenter()).subtract(r2.sum(this.body2.getWorldCenter()));
        double length = this.n.getMagnitude();
        if (length < linearTolerance) {
            this.n.zero();
        } else {
            this.n.multiply(1.0 / length);
        }
        double cr1n = r1.cross(this.n);
        double cr2n = r2.cross(this.n);
        double invMass = invM1 + invI1 * cr1n * cr1n;
        double d = this.invK = invMass <= Epsilon.E ? 0.0 : 1.0 / (invMass += invM2 + invI2 * cr2n * cr2n);
        if (this.frequency > 0.0) {
            double dt = step.getDeltaTime();
            double x = length - this.distance;
            double w = Math.PI * 2 * this.frequency;
            double d2 = 2.0 * this.invK * this.dampingRatio * w;
            double k = this.invK * w * w;
            this.gamma = dt * (d2 + dt * k);
            this.gamma = this.gamma <= Epsilon.E ? 0.0 : 1.0 / this.gamma;
            this.bias = x * dt * k * this.gamma;
            this.invK = invMass <= Epsilon.E ? 0.0 : 1.0 / (invMass += this.gamma);
        } else {
            this.gamma = 0.0;
            this.bias = 0.0;
        }
        this.impulse *= step.getDeltaTimeRatio();
        Vector2 J = this.n.product(this.impulse);
        this.body1.getLinearVelocity().add(J.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(J));
        this.body2.getLinearVelocity().subtract(J.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * r2.cross(J));
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 v1 = this.body1.getLinearVelocity().sum(r1.cross(this.body1.getAngularVelocity()));
        Vector2 v2 = this.body2.getLinearVelocity().sum(r2.cross(this.body2.getAngularVelocity()));
        double Jv = this.n.dot(v1.difference(v2));
        double j = -this.invK * (Jv + this.bias + this.gamma * this.impulse);
        this.impulse += j;
        Vector2 J = this.n.product(j);
        this.body1.getLinearVelocity().add(J.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(J));
        this.body2.getLinearVelocity().subtract(J.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * r2.cross(J));
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        if (this.frequency > 0.0) {
            return true;
        }
        double linearTolerance = settings.getLinearTolerance();
        double maxLinearCorrection = settings.getMaximumLinearCorrection();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 c1 = this.body1.getWorldCenter();
        Vector2 c2 = this.body2.getWorldCenter();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.n = r1.sum(this.body1.getWorldCenter()).subtract(r2.sum(this.body2.getWorldCenter()));
        double l = this.n.normalize();
        double C = l - this.distance;
        C = Interval.clamp(C, -maxLinearCorrection, maxLinearCorrection);
        double impulse = -this.invK * C;
        Vector2 J = this.n.product(impulse);
        this.body1.translate(J.product(invM1));
        this.body1.rotate(invI1 * r1.cross(J), c1);
        this.body2.translate(J.product(-invM2));
        this.body2.rotate(-invI2 * r2.cross(J), c2);
        return Math.abs(C) < linearTolerance;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        return this.n.product(this.impulse * invdt);
    }

    @Override
    public double getReactionTorque(double invdt) {
        return 0.0;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    public boolean isSpring() {
        return this.frequency > 0.0;
    }

    public boolean isSpringDamper() {
        return this.frequency > 0.0 && this.dampingRatio > 0.0;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.distance.invalidDistance"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.distance = distance;
    }

    public double getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(double dampingRatio) {
        if (dampingRatio < 0.0 || dampingRatio > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        this.dampingRatio = dampingRatio;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        if (frequency < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequency"));
        }
        this.frequency = frequency;
    }
}

