/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import java.util.UUID;
import org.dyn4j.DataContainer;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Constraint;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Vector2;

public abstract class Joint
extends Constraint
implements Shiftable,
DataContainer {
    protected final UUID id = UUID.randomUUID();
    protected boolean collisionAllowed;
    protected Object userData;

    public Joint(Body body1, Body body2) {
        this(body1, body2, false);
    }

    public Joint(Body body1, Body body2, boolean collisionAllowed) {
        super(body1, body2);
        this.collisionAllowed = collisionAllowed;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Id=").append(this.id).append("|").append(super.toString()).append("|IsCollisionAllowed=").append(this.collisionAllowed);
        return sb.toString();
    }

    public abstract void initializeConstraints(Step var1, Settings var2);

    public abstract void solveVelocityConstraints(Step var1, Settings var2);

    public abstract boolean solvePositionConstraints(Step var1, Settings var2);

    public abstract Vector2 getAnchor1();

    public abstract Vector2 getAnchor2();

    public abstract Vector2 getReactionForce(double var1);

    public abstract double getReactionTorque(double var1);

    public UUID getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.body1.isActive() && this.body2.isActive();
    }

    public boolean isCollisionAllowed() {
        return this.collisionAllowed;
    }

    public void setCollisionAllowed(boolean flag) {
        if (this.collisionAllowed != flag) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.collisionAllowed = flag;
        }
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }
}

