/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class MotorJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 linearTarget;
    protected double angularTarget;
    protected double correctionFactor;
    protected double maximumForce;
    protected double maximumTorque;
    private Matrix22 K;
    private double angularMass;
    private Vector2 linearError;
    private double angularError;
    private Vector2 linearImpulse;
    private double angularImpulse;

    public MotorJoint(Body body1, Body body2) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        this.linearTarget = body1.getLocalPoint(body2.getWorldCenter());
        this.angularTarget = body2.getTransform().getRotation() - body1.getTransform().getRotation();
        this.correctionFactor = 0.3;
        this.K = new Matrix22();
        this.linearImpulse = new Vector2();
        this.angularImpulse = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MotorJoint[").append(super.toString()).append("|LinearTarget=").append(this.linearTarget).append("|AngularTarget=").append(this.angularTarget).append("|CorrectionFactor=").append(this.correctionFactor).append("|MaximumForce=").append(this.maximumForce).append("|MaximumTorque=").append(this.maximumTorque).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().getNegative());
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().getNegative());
        this.K.m00 = invM1 + invM2 + r1.y * r1.y * invI1 + r2.y * r2.y * invI2;
        this.K.m10 = this.K.m01 = -invI1 * r1.x * r1.y - invI2 * r2.x * r2.y;
        this.K.m11 = invM1 + invM2 + r1.x * r1.x * invI1 + r2.x * r2.x * invI2;
        this.K.invert();
        this.angularMass = invI1 + invI2;
        if (this.angularMass > Epsilon.E) {
            this.angularMass = 1.0 / this.angularMass;
        }
        Vector2 d1 = r1.sum(this.body1.getWorldCenter());
        Vector2 d2 = r2.sum(this.body2.getWorldCenter());
        Vector2 d0 = t1.getTransformedR(this.linearTarget);
        this.linearError = d2.subtract(d1).subtract(d0);
        this.angularError = this.getAngularError();
        this.linearImpulse.multiply(step.getDeltaTimeRatio());
        this.angularImpulse *= step.getDeltaTimeRatio();
        this.body1.getLinearVelocity().subtract(this.linearImpulse.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() - invI1 * (r1.cross(this.linearImpulse) + this.angularImpulse));
        this.body2.getLinearVelocity().add(this.linearImpulse.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() + invI2 * (r2.cross(this.linearImpulse) + this.angularImpulse));
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        double dt = step.getDeltaTime();
        double invdt = step.getInverseDeltaTime();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        double C = this.body2.getAngularVelocity() - this.body1.getAngularVelocity() + invdt * this.correctionFactor * this.angularError;
        double impulse = this.angularMass * -C;
        double oldImpulse = this.angularImpulse;
        double maxImpulse = this.maximumTorque * dt;
        this.angularImpulse = Interval.clamp(this.angularImpulse + impulse, -maxImpulse, maxImpulse);
        impulse = this.angularImpulse - oldImpulse;
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() - invI1 * impulse);
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() + invI2 * impulse);
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().getNegative());
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().getNegative());
        Vector2 v1 = this.body1.getLinearVelocity().sum(r1.cross(this.body1.getAngularVelocity()));
        Vector2 v2 = this.body2.getLinearVelocity().sum(r2.cross(this.body2.getAngularVelocity()));
        Vector2 pivotV = v2.subtract(v1);
        pivotV.add(this.linearError.product(this.correctionFactor * invdt));
        Vector2 impulse2 = this.K.multiply(pivotV);
        impulse2.negate();
        Vector2 oldImpulse2 = this.linearImpulse.copy();
        this.linearImpulse.add(impulse2);
        double maxImpulse2 = this.maximumForce * dt;
        if (this.linearImpulse.getMagnitudeSquared() > maxImpulse2 * maxImpulse2) {
            this.linearImpulse.normalize();
            this.linearImpulse.multiply(maxImpulse2);
        }
        impulse2 = this.linearImpulse.difference(oldImpulse2);
        this.body1.getLinearVelocity().subtract(impulse2.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() - invI1 * r1.cross(impulse2));
        this.body2.getLinearVelocity().add(impulse2.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() + invI2 * r2.cross(impulse2));
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        return true;
    }

    private double getAngularError() {
        double rr = this.body2.getTransform().getRotation() - this.body1.getTransform().getRotation() - this.angularTarget;
        if (rr < -Math.PI) {
            rr += Math.PI * 2;
        }
        if (rr > Math.PI) {
            rr -= Math.PI * 2;
        }
        return rr;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldCenter();
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldCenter();
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        return this.linearImpulse.product(invdt);
    }

    @Override
    public double getReactionTorque(double invdt) {
        return this.angularImpulse * invdt;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    public Vector2 getLinearTarget() {
        return this.linearTarget;
    }

    public void setLinearTarget(Vector2 target) {
        if (!target.equals(this.linearTarget)) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.linearTarget = target;
        }
    }

    public double getAngularTarget() {
        return this.angularTarget;
    }

    public void setAngularTarget(double target) {
        if (target != this.angularTarget) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.angularTarget = target;
        }
    }

    public double getCorrectionFactor() {
        return this.correctionFactor;
    }

    public void setCorrectionFactor(double correctionFactor) {
        if (correctionFactor < 0.0 || correctionFactor > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.motor.invalidCorrectionFactor"));
        }
        this.correctionFactor = correctionFactor;
    }

    public double getMaximumTorque() {
        return this.maximumTorque;
    }

    public void setMaximumTorque(double maximumTorque) {
        if (maximumTorque < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.friction.invalidMaximumTorque"));
        }
        this.maximumTorque = maximumTorque;
    }

    public double getMaximumForce() {
        return this.maximumForce;
    }

    public void setMaximumForce(double maximumForce) {
        if (maximumForce < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.friction.invalidMaximumForce"));
        }
        this.maximumForce = maximumForce;
    }
}

