/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class PinJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 target;
    protected Vector2 anchor;
    protected double frequency;
    protected double dampingRatio;
    protected double maximumForce;
    private Matrix22 K;
    private Vector2 bias;
    private double gamma;
    private Vector2 impulse;

    public PinJoint(Body body, Vector2 anchor, double frequency, double dampingRatio, double maximumForce) {
        super(body, body, false);
        if (anchor == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pin.nullAnchor"));
        }
        if (frequency <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequencyZero"));
        }
        if (dampingRatio < 0.0 || dampingRatio > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        if (maximumForce < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.pin.invalidMaximumForce"));
        }
        this.target = anchor;
        this.anchor = body.getLocalPoint(anchor);
        this.frequency = frequency;
        this.dampingRatio = dampingRatio;
        this.maximumForce = maximumForce;
        this.K = new Matrix22();
        this.impulse = new Vector2();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PinJoint[").append(super.toString()).append("|Target=").append(this.target).append("|Anchor=").append(this.anchor).append("|Frequency=").append(this.frequency).append("|DampingRatio=").append(this.dampingRatio).append("|MaximumForce=").append(this.maximumForce).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        Body body = this.body2;
        Transform transform = body.getTransform();
        Mass mass = this.body2.getMass();
        double m = mass.getMass();
        double invM = mass.getInverseMass();
        double invI = mass.getInverseInertia();
        if (m <= Epsilon.E) {
            m = mass.getInertia();
        }
        double w = Math.PI * 2 * this.frequency;
        double d = 2.0 * m * this.dampingRatio * w;
        double k = m * w * w;
        double dt = step.getDeltaTime();
        this.gamma = dt * (d + dt * k);
        if (this.gamma > Epsilon.E) {
            this.gamma = 1.0 / this.gamma;
        }
        Vector2 r = transform.getTransformedR(body.getLocalCenter().to(this.anchor));
        this.bias = body.getWorldCenter().add(r).difference(this.target);
        this.bias.multiply(dt * k * this.gamma);
        this.K.m00 = invM + r.y * r.y * invI;
        this.K.m10 = this.K.m01 = -invI * r.x * r.y;
        this.K.m11 = invM + r.x * r.x * invI;
        this.K.m00 += this.gamma;
        this.K.m11 += this.gamma;
        this.impulse.multiply(step.getDeltaTimeRatio());
        body.getLinearVelocity().add(this.impulse.product(invM));
        body.setAngularVelocity(body.getAngularVelocity() + invI * r.cross(this.impulse));
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        Vector2 C;
        Body body = this.body2;
        Transform transform = body.getTransform();
        Mass mass = this.body2.getMass();
        double invM = mass.getInverseMass();
        double invI = mass.getInverseInertia();
        Vector2 r = transform.getTransformedR(body.getLocalCenter().to(this.anchor));
        Vector2 jvb = C = r.cross(body.getAngularVelocity()).add(body.getLinearVelocity());
        jvb.add(this.bias);
        jvb.add(this.impulse.product(this.gamma));
        jvb.negate();
        Vector2 J = this.K.solve(jvb);
        Vector2 oldImpulse = this.impulse.copy();
        this.impulse.add(J);
        double maxImpulse = step.getDeltaTime() * this.maximumForce;
        if (this.impulse.getMagnitudeSquared() > maxImpulse * maxImpulse) {
            this.impulse.normalize();
            this.impulse.multiply(maxImpulse);
        }
        J = this.impulse.difference(oldImpulse);
        body.getLinearVelocity().add(J.product(invM));
        body.setAngularVelocity(body.getAngularVelocity() + invI * r.cross(J));
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        return true;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.target;
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.anchor);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        return this.impulse.product(invdt);
    }

    @Override
    public double getReactionTorque(double invdt) {
        return 0.0;
    }

    @Override
    public boolean isCollisionAllowed() {
        return false;
    }

    @Override
    public void shift(Vector2 shift) {
        this.target.add(shift);
    }

    public void setTarget(Vector2 target) {
        if (target == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pin.nullTarget"));
        }
        this.body2.setAsleep(false);
        this.target = target;
    }

    public Vector2 getTarget() {
        return this.target;
    }

    public double getMaximumForce() {
        return this.maximumForce;
    }

    public void setMaximumForce(double maximumForce) {
        if (maximumForce < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.pin.invalidMaximumForce"));
        }
        this.maximumForce = maximumForce;
    }

    public double getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(double dampingRatio) {
        if (dampingRatio < 0.0 || dampingRatio > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        this.dampingRatio = dampingRatio;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        if (frequency <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequencyZero"));
        }
        this.frequency = frequency;
    }
}

