/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.dynamics.joint.LimitState;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix33;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vector3;
import org.dyn4j.resources.Messages;

public class PrismaticJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected boolean motorEnabled;
    protected double motorSpeed;
    protected double maximumMotorForce;
    protected boolean limitEnabled;
    protected double upperLimit;
    protected double lowerLimit;
    protected double referenceAngle;
    private final Vector2 xAxis;
    private final Vector2 yAxis;
    private LimitState limitState;
    private Matrix33 K;
    private double motorMass;
    private Vector2 perp;
    private Vector2 axis;
    private double s1;
    private double s2;
    private double a1;
    private double a2;
    private Vector3 impulse;
    private double motorImpulse;

    public PrismaticJoint(Body body1, Body body2, Vector2 anchor, Vector2 axis) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (anchor == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        if (axis == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAxis"));
        }
        this.localAnchor1 = body1.getLocalPoint(anchor);
        this.localAnchor2 = body2.getLocalPoint(anchor);
        Vector2 n = axis.getNormalized();
        this.xAxis = body2.getLocalVector(n);
        this.yAxis = this.xAxis.cross(1.0);
        this.referenceAngle = body1.getTransform().getRotation() - body2.getTransform().getRotation();
        this.K = new Matrix33();
        this.impulse = new Vector3();
        this.limitEnabled = false;
        this.motorEnabled = false;
        this.limitState = LimitState.INACTIVE;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrismaticJoint[").append(super.toString()).append("|Anchor=").append(this.getAnchor1()).append("|Axis=").append(this.getAxis()).append("|IsMotorEnabled=").append(this.motorEnabled).append("|MotorSpeed=").append(this.motorSpeed).append("|MaximumMotorForce=").append(this.maximumMotorForce).append("|ReferenceAngle=").append(this.referenceAngle).append("|IsLimitEnabled=").append(this.limitEnabled).append("|LowerLimit=").append(this.lowerLimit).append("|UpperLimit=").append(this.upperLimit).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        double linearTolerance = settings.getLinearTolerance();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 d = this.body1.getWorldCenter().sum(r1).subtract(this.body2.getWorldCenter().sum(r2));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        this.s1 = r1.cross(this.perp);
        this.s2 = r2.sum(d).cross(this.perp);
        this.a1 = r1.cross(this.axis);
        this.a2 = r2.sum(d).cross(this.axis);
        this.K.m00 = invM1 + invM2 + this.s1 * this.s1 * invI1 + this.s2 * this.s2 * invI2;
        this.K.m01 = this.s1 * invI1 + this.s2 * invI2;
        this.K.m02 = this.s1 * this.a1 * invI1 + this.s2 * this.a2 * invI2;
        this.K.m10 = this.K.m01;
        this.K.m11 = invI1 + invI2;
        if (this.K.m11 <= Epsilon.E) {
            this.K.m11 = 1.0;
        }
        this.K.m12 = this.a1 * invI1 + this.a2 * invI2;
        this.K.m20 = this.K.m02;
        this.K.m21 = this.K.m12;
        this.motorMass = this.K.m22 = invM1 + invM2 + this.a1 * this.a1 * invI1 + this.a2 * this.a2 * invI2;
        if (Math.abs(this.motorMass) > Epsilon.E) {
            this.motorMass = 1.0 / this.motorMass;
        }
        if (!this.motorEnabled) {
            this.motorImpulse = 0.0;
        }
        if (this.limitEnabled) {
            double dist = this.axis.dot(d);
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * linearTolerance) {
                this.limitState = LimitState.EQUAL;
            } else if (dist <= this.lowerLimit) {
                if (this.limitState != LimitState.AT_LOWER) {
                    this.limitState = LimitState.AT_LOWER;
                    this.impulse.z = 0.0;
                }
            } else if (dist >= this.upperLimit) {
                if (this.limitState != LimitState.AT_UPPER) {
                    this.limitState = LimitState.AT_UPPER;
                    this.impulse.z = 0.0;
                }
            } else {
                this.limitState = LimitState.INACTIVE;
                this.impulse.z = 0.0;
            }
        } else {
            this.limitState = LimitState.INACTIVE;
            this.impulse.z = 0.0;
        }
        this.impulse.multiply(step.getDeltaTimeRatio());
        this.motorImpulse *= step.getDeltaTimeRatio();
        Vector2 P = new Vector2();
        P.x = this.perp.x * this.impulse.x + (this.motorImpulse + this.impulse.z) * this.axis.x;
        P.y = this.perp.y * this.impulse.x + (this.motorImpulse + this.impulse.z) * this.axis.y;
        double l1 = this.impulse.x * this.s1 + this.impulse.y + (this.motorImpulse + this.impulse.z) * this.a1;
        double l2 = this.impulse.x * this.s2 + this.impulse.y + (this.motorImpulse + this.impulse.z) * this.a2;
        this.body1.getLinearVelocity().add(P.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * l1);
        this.body2.getLinearVelocity().subtract(P.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * l2);
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        double l2;
        double l1;
        Vector2 P;
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 v1 = this.body1.getLinearVelocity();
        Vector2 v2 = this.body2.getLinearVelocity();
        double w1 = this.body1.getAngularVelocity();
        double w2 = this.body2.getAngularVelocity();
        if (this.motorEnabled && this.limitState != LimitState.EQUAL) {
            double Cdt = this.axis.dot(v1.difference(v2)) + this.a1 * w1 - this.a2 * w2;
            double impulse = this.motorMass * (this.motorSpeed - Cdt);
            double oldImpulse = this.motorImpulse;
            double maxImpulse = this.maximumMotorForce * step.getDeltaTime();
            this.motorImpulse = Interval.clamp(this.motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.motorImpulse - oldImpulse;
            P = this.axis.product(impulse);
            l1 = impulse * this.a1;
            l2 = impulse * this.a2;
            v1.add(P.product(invM1));
            w1 += l1 * invI1;
            v2.subtract(P.product(invM2));
            w2 -= l2 * invI2;
        }
        Vector2 Cdt = new Vector2();
        Cdt.x = this.perp.dot(v1.difference(v2)) + this.s1 * w1 - this.s2 * w2;
        Cdt.y = w1 - w2;
        if (this.limitEnabled && this.limitState != LimitState.INACTIVE) {
            double Cdtl = this.axis.dot(v1.difference(v2)) + this.a1 * w1 - this.a2 * w2;
            Vector3 b = new Vector3(Cdt.x, Cdt.y, Cdtl);
            Vector3 impulse = this.K.solve33(b.negate());
            Vector3 f1 = this.impulse.copy();
            this.impulse.add(impulse);
            if (this.limitState == LimitState.AT_LOWER) {
                this.impulse.z = Math.max(this.impulse.z, 0.0);
            } else if (this.limitState == LimitState.AT_UPPER) {
                this.impulse.z = Math.min(this.impulse.z, 0.0);
            }
            Vector2 f2_1 = Cdt.negate().difference(new Vector2(this.K.m02, this.K.m12).multiply(this.impulse.z - f1.z));
            Vector2 f2r = this.K.solve22(f2_1).add(f1.x, f1.y);
            this.impulse.x = f2r.x;
            this.impulse.y = f2r.y;
            impulse = this.impulse.difference(f1);
            P = new Vector2();
            P.x = this.perp.x * impulse.x + impulse.z * this.axis.x;
            P.y = this.perp.y * impulse.x + impulse.z * this.axis.y;
            l1 = impulse.x * this.s1 + impulse.y + impulse.z * this.a1;
            l2 = impulse.x * this.s2 + impulse.y + impulse.z * this.a2;
            v1.add(P.product(invM1));
            w1 += l1 * invI1;
            v2.subtract(P.product(invM2));
            w2 -= l2 * invI2;
        } else {
            Vector2 f2r = this.K.solve22(Cdt.negate());
            this.impulse.x += f2r.x;
            this.impulse.y += f2r.y;
            Vector2 P2 = this.perp.product(f2r.x);
            double l12 = f2r.x * this.s1 + f2r.y;
            double l22 = f2r.x * this.s2 + f2r.y;
            v1.add(P2.product(invM1));
            w1 += l12 * invI1;
            v2.subtract(P2.product(invM2));
            w2 -= l22 * invI2;
        }
        this.body1.setAngularVelocity(w1);
        this.body2.setAngularVelocity(w2);
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        Vector3 impulse;
        double maxLinearCorrection = settings.getMaximumLinearCorrection();
        double linearTolerance = settings.getLinearTolerance();
        double angularTolerance = settings.getAngularTolerance();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 c1 = this.body1.getWorldCenter();
        Vector2 c2 = this.body2.getWorldCenter();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 d = c1.sum(r1).subtract(c2.sum(r2));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        Vector2 C = new Vector2();
        C.x = this.perp.dot(d);
        C.y = t1.getRotation() - t2.getRotation() - this.referenceAngle;
        double Cz = 0.0;
        double linearError = 0.0;
        double angularError = 0.0;
        boolean limitActive = false;
        if (this.limitEnabled) {
            this.a1 = r1.cross(this.axis);
            this.a2 = r2.sum(d).cross(this.axis);
            double dist = this.axis.dot(d);
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * linearTolerance) {
                Cz = Interval.clamp(dist, -maxLinearCorrection, maxLinearCorrection);
                linearError = Math.abs(dist);
                limitActive = true;
            } else if (dist <= this.lowerLimit) {
                Cz = Interval.clamp(dist - this.lowerLimit + linearTolerance, -maxLinearCorrection, 0.0);
                linearError = this.lowerLimit - dist;
                limitActive = true;
            } else if (dist >= this.upperLimit) {
                Cz = Interval.clamp(dist - this.upperLimit - linearTolerance, 0.0, maxLinearCorrection);
                linearError = dist - this.upperLimit;
                limitActive = true;
            }
        }
        this.s1 = r1.cross(this.perp);
        this.s2 = r2.sum(d).cross(this.perp);
        linearError = Math.max(linearError, Math.abs(C.x));
        angularError = Math.abs(C.y);
        if (limitActive) {
            this.K.m00 = invM1 + invM2 + this.s1 * this.s1 * invI1 + this.s2 * this.s2 * invI2;
            this.K.m01 = this.s1 * invI1 + this.s2 * invI2;
            this.K.m02 = this.s1 * this.a1 * invI1 + this.s2 * this.a2 * invI2;
            this.K.m10 = this.K.m01;
            this.K.m11 = invI1 + invI2;
            if (this.K.m11 <= Epsilon.E) {
                this.K.m11 = 1.0;
            }
            this.K.m12 = this.a1 * invI1 + this.a2 * invI2;
            this.K.m20 = this.K.m02;
            this.K.m21 = this.K.m12;
            this.K.m22 = invM1 + invM2 + this.a1 * this.a1 * invI1 + this.a2 * this.a2 * invI2;
            Vector3 Clim = new Vector3(C.x, C.y, Cz);
            impulse = this.K.solve33(Clim.negate());
        } else {
            this.K.m00 = invM1 + invM2 + this.s1 * this.s1 * invI1 + this.s2 * this.s2 * invI2;
            this.K.m01 = this.s1 * invI1 + this.s2 * invI2;
            this.K.m02 = 0.0;
            this.K.m10 = this.K.m01;
            this.K.m11 = invI1 + invI2;
            if (this.K.m11 <= Epsilon.E) {
                this.K.m11 = 1.0;
            }
            this.K.m12 = 0.0;
            this.K.m20 = 0.0;
            this.K.m21 = 0.0;
            this.K.m22 = 0.0;
            Vector2 impulsec = this.K.solve22(C.negate());
            impulse = new Vector3(impulsec.x, impulsec.y, 0.0);
        }
        Vector2 P = new Vector2();
        P.x = this.perp.x * impulse.x + impulse.z * this.axis.x;
        P.y = this.perp.y * impulse.x + impulse.z * this.axis.y;
        double l1 = impulse.x * this.s1 + impulse.y + impulse.z * this.a1;
        double l2 = impulse.x * this.s2 + impulse.y + impulse.z * this.a2;
        this.body1.translate(P.product(invM1));
        this.body1.rotateAboutCenter(l1 * invI1);
        this.body2.translate(P.product(-invM2));
        this.body2.rotateAboutCenter(-l2 * invI2);
        return linearError <= linearTolerance && angularError <= angularTolerance;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        Vector2 force = new Vector2();
        force.x = this.impulse.x * this.perp.x + (this.motorImpulse + this.impulse.z) * this.axis.x;
        force.y = this.impulse.x * this.perp.y + (this.motorImpulse + this.impulse.z) * this.axis.y;
        force.multiply(invdt);
        return force;
    }

    @Override
    public double getReactionTorque(double invdt) {
        return invdt * this.impulse.y;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    public double getJointSpeed() {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Vector2 c1 = this.body1.getWorldCenter();
        Vector2 c2 = this.body2.getWorldCenter();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 d = c1.sum(r1).subtract(c2.sum(r2));
        Vector2 axis = this.body2.getWorldVector(this.xAxis);
        Vector2 v1 = this.body1.getLinearVelocity();
        Vector2 v2 = this.body2.getLinearVelocity();
        double w1 = this.body1.getAngularVelocity();
        double w2 = this.body2.getAngularVelocity();
        double speed = d.dot(axis.cross(w2)) + axis.dot(v1.sum(r1.cross(w1)).subtract(v2.sum(r2.cross(w2))));
        return speed;
    }

    public double getJointTranslation() {
        Vector2 p1 = this.body1.getWorldPoint(this.localAnchor1);
        Vector2 p2 = this.body2.getWorldPoint(this.localAnchor2);
        Vector2 d = p2.difference(p1);
        Vector2 axis = this.body2.getWorldVector(this.xAxis);
        return d.dot(axis);
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void setMotorEnabled(boolean motorEnabled) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorEnabled = motorEnabled;
    }

    public double getMotorSpeed() {
        return this.motorSpeed;
    }

    public void setMotorSpeed(double motorSpeed) {
        if (this.motorEnabled) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.motorSpeed = motorSpeed;
    }

    public double getMaximumMotorForce() {
        return this.maximumMotorForce;
    }

    public void setMaximumMotorForce(double maximumMotorForce) {
        if (maximumMotorForce < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidMaximumMotorForce"));
        }
        this.maximumMotorForce = maximumMotorForce;
    }

    public double getMotorForce(double invdt) {
        return this.motorImpulse * invdt;
    }

    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    public void setLimitEnabled(boolean limitEnabled) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.limitEnabled = limitEnabled;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        if (lowerLimit > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        if (this.limitEnabled && lowerLimit != this.lowerLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.impulse.z = 0.0;
        }
        this.lowerLimit = lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        if (upperLimit < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        if (this.limitEnabled && upperLimit != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.impulse.z = 0.0;
        }
        this.upperLimit = upperLimit;
    }

    public void setLimits(double lowerLimit, double upperLimit) {
        if (lowerLimit > upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        if (this.limitEnabled) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.impulse.z = 0.0;
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public void setLimitsEnabled(double lowerLimit, double upperLimit) {
        if (lowerLimit > upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.limitEnabled = true;
    }

    public Vector2 getAxis() {
        return this.body2.getWorldVector(this.xAxis);
    }

    public double getReferenceAngle() {
        return this.referenceAngle;
    }

    public void setReferenceAngle(double angle) {
        this.referenceAngle = angle;
    }

    public LimitState getLimitState() {
        return this.limitState;
    }
}

