/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix33;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vector3;
import org.dyn4j.resources.Messages;

public class WeldJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double referenceAngle;
    protected double frequency;
    protected double dampingRatio;
    private Matrix33 K;
    private double bias;
    private double gamma;
    private Vector3 impulse;

    public WeldJoint(Body body1, Body body2, Vector2 anchor) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (anchor == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        this.localAnchor1 = body1.getLocalPoint(anchor);
        this.localAnchor2 = body2.getLocalPoint(anchor);
        this.referenceAngle = body1.getTransform().getRotation() - body2.getTransform().getRotation();
        this.K = new Matrix33();
        this.impulse = new Vector3();
        this.frequency = 0.0;
        this.dampingRatio = 0.0;
        this.gamma = 0.0;
        this.bias = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WeldJoint[").append(super.toString()).append("|Anchor=").append(this.getAnchor1()).append("|ReferenceAngle=").append(this.referenceAngle).append("|Frequency=").append(this.frequency).append("|DampingRatio=").append(this.dampingRatio).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.K.m00 = invM1 + invM2 + r1.y * r1.y * invI1 + r2.y * r2.y * invI2;
        this.K.m01 = -r1.y * r1.x * invI1 - r2.y * r2.x * invI2;
        this.K.m02 = -r1.y * invI1 - r2.y * invI2;
        this.K.m10 = this.K.m01;
        this.K.m11 = invM1 + invM2 + r1.x * r1.x * invI1 + r2.x * r2.x * invI2;
        this.K.m12 = r1.x * invI1 + r2.x * invI2;
        this.K.m20 = this.K.m02;
        this.K.m21 = this.K.m12;
        this.K.m22 = invI1 + invI2;
        if (this.frequency > 0.0 && this.K.m22 > 0.0) {
            double invI = invI1 + invI2;
            double i = invI <= Epsilon.E ? 0.0 : 1.0 / invI;
            double r = this.getRelativeRotation();
            double dt = step.getDeltaTime();
            double w = Math.PI * 2 * this.frequency;
            double d = 2.0 * i * this.dampingRatio * w;
            double k = i * w * w;
            this.gamma = dt * (d + dt * k);
            this.gamma = this.gamma <= Epsilon.E ? 0.0 : 1.0 / this.gamma;
            this.bias = r * dt * k * this.gamma;
            this.K.m22 = invI <= Epsilon.E ? 0.0 : 1.0 / (invI += this.gamma);
        } else {
            this.gamma = 0.0;
            this.bias = 0.0;
        }
        this.impulse.multiply(step.getDeltaTimeRatio());
        Vector2 impulse = new Vector2(this.impulse.x, this.impulse.y);
        this.body1.getLinearVelocity().add(impulse.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * (r1.cross(impulse) + this.impulse.z));
        this.body2.getLinearVelocity().subtract(impulse.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * (r2.cross(impulse) + this.impulse.z));
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        if (this.frequency > 0.0) {
            double rav = this.body1.getAngularVelocity() - this.body2.getAngularVelocity();
            double j2 = -this.K.m22 * (rav + this.bias + this.gamma * this.impulse.z);
            this.impulse.z += j2;
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * j2);
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * j2);
            Vector2 v1 = this.body1.getLinearVelocity().sum(r1.cross(this.body1.getAngularVelocity()));
            Vector2 v2 = this.body2.getLinearVelocity().sum(r2.cross(this.body2.getAngularVelocity()));
            Vector2 anchorV = v1.subtract(v2);
            Vector2 j1 = this.K.solve22(anchorV).negate();
            this.impulse.x += j1.x;
            this.impulse.y += j1.y;
            this.body1.getLinearVelocity().add(j1.product(invM1));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * r1.cross(j1));
            this.body2.getLinearVelocity().subtract(j1.product(invM2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * r2.cross(j1));
        } else {
            Vector2 v1 = this.body1.getLinearVelocity().sum(r1.cross(this.body1.getAngularVelocity()));
            Vector2 v2 = this.body2.getLinearVelocity().sum(r2.cross(this.body2.getAngularVelocity()));
            Vector2 anchorV = v1.subtract(v2);
            Vector3 C = new Vector3(anchorV.x, anchorV.y, this.body1.getAngularVelocity() - this.body2.getAngularVelocity());
            Vector3 impulse = null;
            if (this.K.m22 > 0.0) {
                impulse = this.K.solve33(C.negate());
            } else {
                Vector2 impulse2 = this.K.solve22(anchorV).negate();
                impulse = new Vector3(impulse2.x, impulse2.y, 0.0);
            }
            this.impulse.add(impulse);
            Vector2 imp = new Vector2(impulse.x, impulse.y);
            this.body1.getLinearVelocity().add(imp.product(invM1));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * (r1.cross(imp) + impulse.z));
            this.body2.getLinearVelocity().subtract(imp.product(invM2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * (r2.cross(imp) + impulse.z));
        }
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        double linearTolerance = settings.getLinearTolerance();
        double angularTolerance = settings.getAngularTolerance();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 p1 = this.body1.getWorldCenter().add(r1);
        Vector2 p2 = this.body2.getWorldCenter().add(r2);
        Vector2 C1 = p1.difference(p2);
        double C2 = this.getRelativeRotation();
        Vector3 C = new Vector3(C1.x, C1.y, C2);
        double linearError = C1.getMagnitude();
        double angularError = Math.abs(C2);
        this.K.m00 = invM1 + invM2 + r1.y * r1.y * invI1 + r2.y * r2.y * invI2;
        this.K.m01 = -r1.y * r1.x * invI1 - r2.y * r2.x * invI2;
        this.K.m02 = -r1.y * invI1 - r2.y * invI2;
        this.K.m10 = this.K.m01;
        this.K.m11 = invM1 + invM2 + r1.x * r1.x * invI1 + r2.x * r2.x * invI2;
        this.K.m12 = r1.x * invI1 + r2.x * invI2;
        this.K.m20 = this.K.m02;
        this.K.m21 = this.K.m12;
        this.K.m22 = invI1 + invI2;
        if (this.frequency > 0.0) {
            angularError = 0.0;
            Vector2 j = this.K.solve22(C1).negate();
            this.body1.translate(j.product(invM1));
            this.body1.rotateAboutCenter(invI1 * r1.cross(j));
            this.body2.translate(j.product(-invM2));
            this.body2.rotateAboutCenter(-invI2 * r2.cross(j));
        } else {
            Vector3 impulse = null;
            if (this.K.m22 > 0.0) {
                impulse = this.K.solve33(C.negate());
            } else {
                Vector2 impulse2 = this.K.solve22(C1).negate();
                impulse = new Vector3(impulse2.x, impulse2.y, 0.0);
            }
            Vector2 imp = new Vector2(impulse.x, impulse.y);
            this.body1.translate(imp.product(invM1));
            this.body1.rotateAboutCenter(invI1 * (r1.cross(imp) + impulse.z));
            this.body2.translate(imp.product(-invM2));
            this.body2.rotateAboutCenter(-invI2 * (r2.cross(imp) + impulse.z));
        }
        return linearError <= linearTolerance && angularError <= angularTolerance;
    }

    private double getRelativeRotation() {
        double rr = this.body1.getTransform().getRotation() - this.body2.getTransform().getRotation() - this.referenceAngle;
        if (rr < -Math.PI) {
            rr += Math.PI * 2;
        }
        if (rr > Math.PI) {
            rr -= Math.PI * 2;
        }
        return rr;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        Vector2 impulse = new Vector2(this.impulse.x, this.impulse.y);
        return impulse.multiply(invdt);
    }

    @Override
    public double getReactionTorque(double invdt) {
        return this.impulse.z * invdt;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    public boolean isSpring() {
        return this.frequency > 0.0;
    }

    public boolean isSpringDamper() {
        return this.frequency > 0.0 && this.dampingRatio > 0.0;
    }

    public double getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(double dampingRatio) {
        if (dampingRatio < 0.0 || dampingRatio > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        this.dampingRatio = dampingRatio;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        if (frequency < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequency"));
        }
        this.frequency = frequency;
    }

    public double getReferenceAngle() {
        return this.referenceAngle;
    }

    public void setReferenceAngle(double angle) {
        this.referenceAngle = angle;
    }
}

