/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class WheelJoint
extends Joint
implements Shiftable,
DataContainer {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected boolean motorEnabled;
    protected double motorSpeed;
    protected double maximumMotorTorque;
    protected double frequency;
    protected double dampingRatio;
    private final Vector2 xAxis;
    private final Vector2 yAxis;
    private double bias;
    private double gamma;
    private double invK;
    private double springMass;
    private double motorMass;
    private Vector2 perp;
    private Vector2 axis;
    private double s1;
    private double s2;
    private double a1;
    private double a2;
    private double impulse;
    private double springImpulse;
    private double motorImpulse;

    public WheelJoint(Body body1, Body body2, Vector2 anchor, Vector2 axis) {
        super(body1, body2, false);
        if (body1 == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (anchor == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        if (axis == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAxis"));
        }
        this.localAnchor1 = body1.getLocalPoint(anchor);
        this.localAnchor2 = body2.getLocalPoint(anchor);
        Vector2 n = axis.getNormalized();
        this.xAxis = body2.getLocalVector(n);
        this.yAxis = this.xAxis.cross(1.0);
        this.invK = 0.0;
        this.impulse = 0.0;
        this.motorMass = 0.0;
        this.motorImpulse = 0.0;
        this.springMass = 0.0;
        this.springImpulse = 0.0;
        this.frequency = 8.0;
        this.dampingRatio = 0.0;
        this.gamma = 0.0;
        this.bias = 0.0;
        this.motorEnabled = false;
        this.maximumMotorTorque = 0.0;
        this.motorSpeed = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WheelJoint[").append(super.toString()).append("|WorldAnchor=").append(this.getAnchor1()).append("|Axis=").append(this.getAxis()).append("|IsMotorEnabled=").append(this.motorEnabled).append("|MotorSpeed=").append(this.motorSpeed).append("|MaximumMotorTorque=").append(this.maximumMotorTorque).append("|Frequency=").append(this.frequency).append("|DampingRatio=").append(this.dampingRatio).append("]");
        return sb.toString();
    }

    @Override
    public void initializeConstraints(Step step, Settings settings) {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 d = this.body1.getWorldCenter().sum(r1).subtract(this.body2.getWorldCenter().sum(r2));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        this.s1 = r1.cross(this.perp);
        this.s2 = r2.sum(d).cross(this.perp);
        this.invK = invM1 + invM2 + this.s1 * this.s1 * invI1 + this.s2 * this.s2 * invI2;
        if (this.invK > Epsilon.E) {
            this.invK = 1.0 / this.invK;
        }
        if (this.frequency > 0.0) {
            this.a1 = r1.cross(this.axis);
            this.a2 = r2.sum(d).cross(this.axis);
            double invMass = invM1 + invM2 + this.a1 * this.a1 * invI1 + this.a2 * this.a2 * invI2;
            if (invMass > Epsilon.E) {
                this.springMass = 1.0 / invMass;
                double c = d.dot(this.axis);
                double dt = step.getDeltaTime();
                double w = Math.PI * 2 * this.frequency;
                double dc = 2.0 * this.springMass * this.dampingRatio * w;
                double k = this.springMass * w * w;
                this.gamma = dt * (dc + dt * k);
                this.gamma = Math.abs(this.gamma) <= Epsilon.E ? 0.0 : 1.0 / this.gamma;
                this.bias = c * dt * k * this.gamma;
                this.springMass = invMass + this.gamma;
                this.springMass = Math.abs(this.springMass) <= Epsilon.E ? 0.0 : 1.0 / this.springMass;
            }
        } else {
            this.springMass = 0.0;
            this.springImpulse = 0.0;
        }
        if (this.motorEnabled) {
            this.motorMass = invI1 + invI2;
            if (Math.abs(this.motorMass) > Epsilon.E) {
                this.motorMass = 1.0 / this.motorMass;
            }
        } else {
            this.motorMass = 0.0;
            this.motorImpulse = 0.0;
        }
        this.impulse *= step.getDeltaTimeRatio();
        this.springImpulse *= step.getDeltaTimeRatio();
        this.motorImpulse *= step.getDeltaTimeRatio();
        Vector2 P = new Vector2();
        P.x = this.perp.x * this.impulse + this.springImpulse * this.axis.x;
        P.y = this.perp.y * this.impulse + this.springImpulse * this.axis.y;
        double l1 = this.impulse * this.s1 + this.springImpulse * this.a1 + this.motorImpulse;
        double l2 = this.impulse * this.s2 + this.springImpulse * this.a2 + this.motorImpulse;
        this.body1.getLinearVelocity().add(P.product(invM1));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + invI1 * l1);
        this.body2.getLinearVelocity().subtract(P.product(invM2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - invI2 * l2);
    }

    @Override
    public void solveVelocityConstraints(Step step, Settings settings) {
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 v1 = this.body1.getLinearVelocity();
        Vector2 v2 = this.body2.getLinearVelocity();
        double w1 = this.body1.getAngularVelocity();
        double w2 = this.body2.getAngularVelocity();
        double Cdt = this.axis.dot(v1.difference(v2)) + this.a1 * w1 - this.a2 * w2;
        double impulse = -this.springMass * (Cdt + this.bias + this.gamma * this.springImpulse);
        this.springImpulse += impulse;
        Vector2 P = this.axis.product(impulse);
        double l1 = impulse * this.a1;
        double l2 = impulse * this.a2;
        v1.add(P.product(invM1));
        w1 += l1 * invI1;
        v2.subtract(P.product(invM2));
        w2 -= l2 * invI2;
        if (this.motorEnabled) {
            Cdt = w1 - w2 - this.motorSpeed;
            impulse = this.motorMass * -Cdt;
            double oldImpulse = this.motorImpulse;
            double maxImpulse = this.maximumMotorTorque * step.getDeltaTime();
            this.motorImpulse = Interval.clamp(this.motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.motorImpulse - oldImpulse;
            w1 += impulse * invI1;
            w2 -= impulse * invI2;
        }
        Cdt = this.perp.dot(v1.difference(v2)) + this.s1 * w1 - this.s2 * w2;
        impulse = this.invK * -Cdt;
        this.impulse += impulse;
        P = this.perp.product(impulse);
        l1 = impulse * this.s1;
        l2 = impulse * this.s2;
        v1.add(P.product(invM1));
        v2.subtract(P.product(invM2));
        this.body1.setAngularVelocity(w1 += l1 * invI1);
        this.body2.setAngularVelocity(w2 -= l2 * invI2);
    }

    @Override
    public boolean solvePositionConstraints(Step step, Settings settings) {
        double linearTolerance = settings.getLinearTolerance();
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Mass m1 = this.body1.getMass();
        Mass m2 = this.body2.getMass();
        double invM1 = m1.getInverseMass();
        double invM2 = m2.getInverseMass();
        double invI1 = m1.getInverseInertia();
        double invI2 = m2.getInverseInertia();
        Vector2 c1 = this.body1.getWorldCenter();
        Vector2 c2 = this.body2.getWorldCenter();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 d = c1.sum(r1).subtract(c2.sum(r2));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        double Cx = this.perp.dot(d);
        double k = invM1 + invM2 + this.s1 * this.s1 * invI1 + this.s2 * this.s2 * invI2;
        double impulse = 0.0;
        impulse = k > Epsilon.E ? -Cx / k : 0.0;
        Vector2 P = new Vector2();
        P.x = this.perp.x * impulse;
        P.y = this.perp.y * impulse;
        double l1 = this.s1 * impulse;
        double l2 = this.s2 * impulse;
        this.body1.translate(P.product(invM1));
        this.body1.rotateAboutCenter(l1 * invI1);
        this.body2.translate(P.product(-invM2));
        this.body2.rotateAboutCenter(-l2 * invI2);
        return Math.abs(Cx) <= linearTolerance;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double invdt) {
        Vector2 force = new Vector2();
        force.x = this.impulse * this.perp.x + this.springImpulse * this.axis.x;
        force.y = this.impulse * this.perp.y + this.springImpulse * this.axis.y;
        force.multiply(invdt);
        return force;
    }

    @Override
    public double getReactionTorque(double invdt) {
        return this.motorImpulse * invdt;
    }

    @Override
    public void shift(Vector2 shift) {
    }

    @Deprecated
    public double getJointSpeed() {
        return this.getAngularSpeed();
    }

    public double getLinearSpeed() {
        Transform t1 = this.body1.getTransform();
        Transform t2 = this.body2.getTransform();
        Vector2 r1 = t1.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 r2 = t2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 axis = this.body2.getWorldVector(this.xAxis);
        Vector2 v1 = r1.cross(this.body1.getAngularVelocity()).add(this.body1.getLinearVelocity());
        Vector2 v2 = r2.cross(this.body2.getAngularVelocity()).add(this.body2.getLinearVelocity());
        return v2.dot(axis) - v1.dot(axis);
    }

    public double getAngularSpeed() {
        double a1 = this.body1.getAngularVelocity();
        double a2 = this.body2.getAngularVelocity();
        return a2 - a1;
    }

    @Deprecated
    public double getJointTranslation() {
        return this.getLinearTranslation();
    }

    public double getLinearTranslation() {
        Vector2 p1 = this.body1.getWorldPoint(this.localAnchor1);
        Vector2 p2 = this.body2.getWorldPoint(this.localAnchor2);
        Vector2 d = p2.difference(p1);
        Vector2 axis = this.body2.getWorldVector(this.xAxis);
        return d.dot(axis);
    }

    public double getAngularTranslation() {
        double a1 = this.body1.getTransform().getRotation();
        double a2 = this.body2.getTransform().getRotation();
        return a2 - a1;
    }

    public boolean isSpring() {
        return this.frequency > 0.0;
    }

    public boolean isSpringDamper() {
        return this.frequency > 0.0 && this.dampingRatio > 0.0;
    }

    public double getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(double dampingRatio) {
        if (dampingRatio < 0.0 || dampingRatio > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.dampingRatio = dampingRatio;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        if (frequency <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequencyZero"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.frequency = frequency;
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void setMotorEnabled(boolean motorEnabled) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorEnabled = motorEnabled;
    }

    public double getMotorSpeed() {
        return this.motorSpeed;
    }

    public void setMotorSpeed(double motorSpeed) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorSpeed = motorSpeed;
    }

    public double getMaximumMotorTorque() {
        return this.maximumMotorTorque;
    }

    public void setMaximumMotorTorque(double maximumMotorTorque) {
        if (maximumMotorTorque < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidMaximumMotorTorque"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.maximumMotorTorque = maximumMotorTorque;
    }

    public double getMotorTorque(double invdt) {
        return this.motorImpulse * invdt;
    }

    public Vector2 getAxis() {
        return this.body2.getWorldVector(this.xAxis);
    }
}

