/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.Translatable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class AABB
implements Translatable {
    protected final Vector2 min;
    protected final Vector2 max;

    public AABB(double minX, double minY, double maxX, double maxY) {
        this(new Vector2(minX, minY), new Vector2(maxX, maxY));
    }

    public AABB(Vector2 min, Vector2 max) {
        if (min.x > max.x || min.y > max.y) {
            throw new IllegalArgumentException(Messages.getString("geometry.aabb.invalidMinMax"));
        }
        this.min = min;
        this.max = max;
    }

    public AABB(double radius) {
        this(null, radius);
    }

    public AABB(Vector2 center, double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.aabb.invalidRadius"));
        }
        if (center == null) {
            this.min = new Vector2(-radius, -radius);
            this.max = new Vector2(radius, radius);
        } else {
            this.min = new Vector2(center.x - radius, center.y - radius);
            this.max = new Vector2(center.x + radius, center.y + radius);
        }
    }

    public AABB(AABB aabb) {
        this.min = aabb.min.copy();
        this.max = aabb.max.copy();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AABB[Min=").append(this.min).append("|Max=").append(this.max).append("]");
        return sb.toString();
    }

    @Override
    public void translate(double x, double y) {
        this.max.add(x, y);
        this.min.add(x, y);
    }

    @Override
    public void translate(Vector2 translation) {
        this.max.add(translation);
        this.min.add(translation);
    }

    public AABB getTranslated(Vector2 translation) {
        return new AABB(this.min.sum(translation), this.max.sum(translation));
    }

    public double getWidth() {
        return this.max.x - this.min.x;
    }

    public double getHeight() {
        return this.max.y - this.min.y;
    }

    public double getPerimeter() {
        return 2.0 * (this.max.x - this.min.x + this.max.y - this.min.y);
    }

    public double getArea() {
        return (this.max.x - this.min.x) * (this.max.y - this.min.y);
    }

    public void union(AABB aabb) {
        this.min.x = Math.min(this.min.x, aabb.min.x);
        this.min.y = Math.min(this.min.y, aabb.min.y);
        this.max.x = Math.max(this.max.x, aabb.max.x);
        this.max.y = Math.max(this.max.y, aabb.max.y);
    }

    public AABB getUnion(AABB aabb) {
        Vector2 min = new Vector2();
        Vector2 max = new Vector2();
        min.x = Math.min(this.min.x, aabb.min.x);
        min.y = Math.min(this.min.y, aabb.min.y);
        max.x = Math.max(this.max.x, aabb.max.x);
        max.y = Math.max(this.max.y, aabb.max.y);
        return new AABB(min, max);
    }

    public void intersection(AABB aabb) {
        this.min.x = Math.max(this.min.x, aabb.min.x);
        this.min.y = Math.max(this.min.y, aabb.min.y);
        this.max.x = Math.min(this.max.x, aabb.max.x);
        this.max.y = Math.min(this.max.y, aabb.max.y);
        if (this.min.x > this.max.x || this.min.y > this.max.y) {
            this.min.x = 0.0;
            this.min.y = 0.0;
            this.max.x = 0.0;
            this.max.y = 0.0;
        }
    }

    public AABB getIntersection(AABB aabb) {
        Vector2 min = new Vector2();
        Vector2 max = new Vector2();
        min.x = Math.max(this.min.x, aabb.min.x);
        min.y = Math.max(this.min.y, aabb.min.y);
        max.x = Math.min(this.max.x, aabb.max.x);
        max.y = Math.min(this.max.y, aabb.max.y);
        if (min.x > max.x || min.y > max.y) {
            return new AABB(new Vector2(), new Vector2());
        }
        return new AABB(min, max);
    }

    public void expand(double expansion) {
        double e = expansion * 0.5;
        this.min.x -= e;
        this.min.y -= e;
        this.max.x += e;
        this.max.y += e;
        if (expansion < 0.0) {
            double mid;
            if (this.min.x > this.max.x) {
                this.min.x = mid = (this.min.x + this.max.x) * 0.5;
                this.max.x = mid;
            }
            if (this.min.y > this.max.y) {
                this.min.y = mid = (this.min.y + this.max.y) * 0.5;
                this.max.y = mid;
            }
        }
    }

    public AABB getExpanded(double expansion) {
        double e = expansion * 0.5;
        double minx = this.min.x - e;
        double miny = this.min.y - e;
        double maxx = this.max.x + e;
        double maxy = this.max.y + e;
        if (expansion < 0.0) {
            double mid;
            if (minx > maxx) {
                minx = mid = (minx + maxx) * 0.5;
                maxx = mid;
            }
            if (miny > maxy) {
                miny = mid = (miny + maxy) * 0.5;
                maxy = mid;
            }
        }
        return new AABB(new Vector2(minx, miny), new Vector2(maxx, maxy));
    }

    public boolean overlaps(AABB aabb) {
        if (this.min.x > aabb.max.x || this.max.x < aabb.min.x) {
            return false;
        }
        return !(this.min.y > aabb.max.y) && !(this.max.y < aabb.min.y);
    }

    public boolean contains(AABB aabb) {
        return this.min.x <= aabb.min.x && this.max.x >= aabb.max.x && this.min.y <= aabb.min.y && this.max.y >= aabb.max.y;
    }

    public boolean contains(Vector2 point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double x, double y) {
        return this.min.x <= x && this.max.x >= x && this.min.y <= y && this.max.y >= y;
    }

    public boolean isDegenerate() {
        return this.min.x == this.max.x || this.min.y == this.max.y;
    }

    public boolean isDegenerate(double error) {
        return Math.abs(this.max.x - this.min.x) <= error || Math.abs(this.max.y - this.min.y) <= error;
    }

    public double getMinX() {
        return this.min.x;
    }

    public double getMaxX() {
        return this.max.x;
    }

    public double getMaxY() {
        return this.max.y;
    }

    public double getMinY() {
        return this.min.y;
    }
}

