/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.DataContainer;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.PointFeature;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Circle
extends AbstractShape
implements Convex,
Shape,
Transformable,
DataContainer {
    private Circle(boolean valid, double radius) {
        super(radius);
    }

    public Circle(double radius) {
        this(Circle.validate(radius), radius);
    }

    private static final boolean validate(double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.circle.invalidRadius"));
        }
        return true;
    }

    @Override
    public double getRadius(Vector2 center) {
        return this.radius + center.distance(this.center);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Circle[").append(super.toString()).append("]");
        return sb.toString();
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        Vector2 v = transform.getTransformed(this.center);
        double radiusSquared = this.radius * this.radius;
        v.subtract(point);
        return v.getMagnitudeSquared() <= radiusSquared;
    }

    @Override
    public Interval project(Vector2 vector, Transform transform) {
        Vector2 center = transform.getTransformed(this.center);
        double c = center.dot(vector);
        return new Interval(c - this.radius, c + this.radius);
    }

    @Override
    public PointFeature getFarthestFeature(Vector2 vector, Transform transform) {
        Vector2 farthest = this.getFarthestPoint(vector, transform);
        return new PointFeature(farthest);
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector, Transform transform) {
        Vector2 nAxis = vector.getNormalized();
        Vector2 center = transform.getTransformed(this.center);
        center.x += this.radius * nAxis.x;
        center.y += this.radius * nAxis.y;
        return center;
    }

    @Override
    public Vector2[] getAxes(Vector2[] foci, Transform transform) {
        return null;
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        Vector2[] foci = new Vector2[]{transform.getTransformed(this.center)};
        return foci;
    }

    @Override
    public Mass createMass(double density) {
        double r2 = this.radius * this.radius;
        double mass = density * Math.PI * r2;
        double inertia = mass * r2 * 0.5;
        return new Mass(this.center, mass, inertia);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Vector2 center = transform.getTransformed(this.center);
        return new AABB(center, this.radius);
    }
}

