/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.DataContainer;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.PointFeature;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Ellipse
extends AbstractShape
implements Convex,
Shape,
Transformable,
DataContainer {
    final double width;
    final double height;
    final double halfWidth;
    final double halfHeight;
    final Vector2 localXAxis;

    private Ellipse(boolean valid, double width, double height) {
        super(Math.max(width, height) * 0.5);
        this.width = width;
        this.height = height;
        this.halfWidth = width * 0.5;
        this.halfHeight = height * 0.5;
        this.localXAxis = new Vector2(1.0, 0.0);
    }

    public Ellipse(double width, double height) {
        this(Ellipse.validate(width, height), width, height);
    }

    private static final boolean validate(double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipse.invalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipse.invalidHeight"));
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ellipse[").append(super.toString()).append("|Width=").append(this.width).append("|Height=").append(this.height).append("]");
        return sb.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] foci, Transform transform) {
        throw new UnsupportedOperationException(Messages.getString("geometry.ellipse.satNotSupported"));
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        throw new UnsupportedOperationException(Messages.getString("geometry.ellipse.satNotSupported"));
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector, Transform transform) {
        Vector2 localAxis = transform.getInverseTransformedR(vector);
        double r = this.getRotation();
        localAxis.rotate(-r);
        localAxis.x *= this.halfWidth;
        localAxis.y *= this.halfHeight;
        localAxis.normalize();
        Vector2 p = new Vector2(localAxis.x * this.halfWidth, localAxis.y * this.halfHeight);
        p.rotate(r);
        p.add(this.center);
        transform.transform(p);
        return p;
    }

    @Override
    public Feature getFarthestFeature(Vector2 vector, Transform transform) {
        Vector2 farthest = this.getFarthestPoint(vector, transform);
        return new PointFeature(farthest);
    }

    @Override
    public Interval project(Vector2 vector, Transform transform) {
        Vector2 p1 = this.getFarthestPoint(vector, transform);
        Vector2 center = transform.getTransformed(this.center);
        double c = center.dot(vector);
        double d = p1.dot(vector);
        return new Interval(2.0 * c - d, d);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Interval x = this.project(Vector2.X_AXIS, transform);
        Interval y = this.project(Vector2.Y_AXIS, transform);
        return new AABB(x.getMin(), y.getMin(), x.getMax(), y.getMax());
    }

    @Override
    public Mass createMass(double density) {
        double area = Math.PI * this.halfWidth * this.halfHeight;
        double m = area * density;
        double I = m * (this.halfWidth * this.halfWidth + this.halfHeight * this.halfHeight) / 4.0;
        return new Mass(this.center, m, I);
    }

    @Override
    public double getRadius(Vector2 center) {
        return this.radius + center.distance(this.center);
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        Vector2 localPoint = transform.getInverseTransformed(point);
        double r = this.getRotation();
        localPoint.rotate(-r, this.center.x, this.center.y);
        double x = localPoint.x - this.center.x;
        double y = localPoint.y - this.center.y;
        double x2 = x * x;
        double y2 = y * y;
        double a2 = this.halfWidth * this.halfWidth;
        double b2 = this.halfHeight * this.halfHeight;
        double value = x2 / a2 + y2 / b2;
        return value <= 1.0;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        super.rotate(theta, x, y);
        this.localXAxis.rotate(theta);
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.localXAxis);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getHalfWidth() {
        return this.halfWidth;
    }

    public double getHalfHeight() {
        return this.halfHeight;
    }
}

