/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Capsule;
import org.dyn4j.geometry.Circle;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ellipse;
import org.dyn4j.geometry.HalfEllipse;
import org.dyn4j.geometry.Polygon;
import org.dyn4j.geometry.Rectangle;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Slice;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Wound;
import org.dyn4j.resources.Messages;

public final class Geometry {
    public static final double TWO_PI = Math.PI * 2;
    public static final double INV_3 = 0.3333333333333333;
    public static final double INV_SQRT_3 = 1.0 / Math.sqrt(3.0);

    public static final double getWinding(List<Vector2> points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        int size = points.size();
        if (size < 2) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointList2"));
        }
        double area = 0.0;
        int i = 0;
        while (i < size) {
            Vector2 p1 = points.get(i);
            Vector2 p2 = points.get(i + 1 == size ? 0 : i + 1);
            if (p1 == null || p2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            area += p1.cross(p2);
            ++i;
        }
        return area;
    }

    public static final double getWinding(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        int size = points.length;
        if (size < 2) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointArray2"));
        }
        double area = 0.0;
        int i = 0;
        while (i < size) {
            Vector2 p1 = points[i];
            Vector2 p2 = points[i + 1 == size ? 0 : i + 1];
            if (p1 == null || p2 == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            area += p1.cross(p2);
            ++i;
        }
        return area;
    }

    public static final void reverseWinding(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        int size = points.length;
        if (size == 1 || size == 0) {
            return;
        }
        int i = 0;
        int j = size - 1;
        Vector2 temp = null;
        while (j > i) {
            temp = points[j];
            points[j] = points[i];
            points[i] = temp;
            --j;
            ++i;
        }
    }

    public static final void reverseWinding(List<Vector2> points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        int size = points.size();
        if (size == 1 || size == 0) {
            return;
        }
        Collections.reverse(points);
    }

    public static final Vector2 getAverageCenter(List<Vector2> points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        if (points.isEmpty()) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointList1"));
        }
        int size = points.size();
        if (size == 1) {
            Vector2 p = points.get(0);
            if (p == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            return p.copy();
        }
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < size) {
            Vector2 point = points.get(i);
            if (point == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            x += point.x;
            y += point.y;
            ++i;
        }
        return new Vector2(x / (double)size, y / (double)size);
    }

    public static final Vector2 getAverageCenter(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        int size = points.length;
        if (size == 0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointArray1"));
        }
        if (size == 1) {
            Vector2 p = points[0];
            if (p == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            return p.copy();
        }
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < size) {
            Vector2 point = points[i];
            if (point == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            x += point.x;
            y += point.y;
            ++i;
        }
        return new Vector2(x / (double)size, y / (double)size);
    }

    public static final Vector2 getAreaWeightedCenter(List<Vector2> points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        if (points.isEmpty()) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointList1"));
        }
        int size = points.size();
        if (size == 1) {
            Vector2 p = points.get(0);
            if (p == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            return p.copy();
        }
        Vector2 ac = new Vector2();
        int i = 0;
        while (i < size) {
            Vector2 p = points.get(i);
            if (p == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            ac.add(p);
            ++i;
        }
        ac.multiply(1.0 / (double)size);
        Vector2 center = new Vector2();
        double area = 0.0;
        int i2 = 0;
        while (i2 < size) {
            Vector2 p1 = points.get(i2);
            Vector2 p2 = i2 + 1 < size ? points.get(i2 + 1) : points.get(0);
            p1 = p1.difference(ac);
            p2 = p2.difference(ac);
            double d = p1.cross(p2);
            double triangleArea = 0.5 * d;
            area += triangleArea;
            center.add(p1.add(p2).multiply(0.3333333333333333).multiply(triangleArea));
            ++i2;
        }
        if (Math.abs(area) <= Epsilon.E) {
            return points.get(0).copy();
        }
        center.multiply(1.0 / area);
        center.add(ac);
        return center;
    }

    public static final Vector2 getAreaWeightedCenter(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        int size = points.length;
        if (size == 0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSizePointArray1"));
        }
        if (size == 1) {
            Vector2 p = points[0];
            if (p == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            return p.copy();
        }
        Vector2 ac = new Vector2();
        int i = 0;
        while (i < size) {
            Vector2 p = points[i];
            if (p == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointArrayElements"));
            }
            ac.add(p);
            ++i;
        }
        ac.multiply(1.0 / (double)size);
        Vector2 center = new Vector2();
        double area = 0.0;
        int i2 = 0;
        while (i2 < size) {
            Vector2 p1 = points[i2];
            Vector2 p2 = i2 + 1 < size ? points[i2 + 1] : points[0];
            p1 = p1.difference(ac);
            p2 = p2.difference(ac);
            double d = p1.cross(p2);
            double triangleArea = 0.5 * d;
            area += triangleArea;
            center.add(p1.add(p2).multiply(0.3333333333333333).multiply(triangleArea));
            ++i2;
        }
        if (Math.abs(area) <= Epsilon.E) {
            return points[0].copy();
        }
        center.multiply(1.0 / area);
        center.add(ac);
        return center;
    }

    public static final double getRotationRadius(Vector2 ... vertices) {
        return Geometry.getRotationRadius(new Vector2(), vertices);
    }

    public static final double getRotationRadius(Vector2 center, Vector2 ... vertices) {
        int size;
        if (vertices == null) {
            return 0.0;
        }
        if (center == null) {
            center = new Vector2();
        }
        if ((size = vertices.length) == 0) {
            return 0.0;
        }
        double r2 = 0.0;
        int i = 0;
        while (i < size) {
            Vector2 v = vertices[i];
            if (v != null) {
                double r2t = center.distanceSquared(v);
                r2 = Math.max(r2, r2t);
            }
            ++i;
        }
        return Math.sqrt(r2);
    }

    public static final Vector2[] getCounterClockwiseEdgeNormals(Vector2 ... vertices) {
        if (vertices == null) {
            return null;
        }
        int size = vertices.length;
        if (size == 0) {
            return null;
        }
        Vector2[] normals = new Vector2[size];
        int i = 0;
        while (i < size) {
            Vector2 p1 = vertices[i];
            Vector2 p2 = i + 1 == size ? vertices[0] : vertices[i + 1];
            Vector2 n = p1.to(p2).left();
            n.normalize();
            normals[i] = n;
            ++i;
        }
        return normals;
    }

    public static final Circle createCircle(double radius) {
        return new Circle(radius);
    }

    public static final Polygon createPolygon(Vector2 ... vertices) {
        if (vertices == null) {
            throw new NullPointerException(Messages.getString("geometry.nullVerticesArray"));
        }
        int size = vertices.length;
        Vector2[] verts = new Vector2[size];
        int i = 0;
        while (i < size) {
            Vector2 vertex = vertices[i];
            if (vertex == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPolygonPoint"));
            }
            verts[i] = vertex.copy();
            ++i;
        }
        return new Polygon(verts);
    }

    public static final Polygon createPolygonAtOrigin(Vector2 ... vertices) {
        Polygon polygon = Geometry.createPolygon(vertices);
        Vector2 center = polygon.getCenter();
        polygon.translate(-center.x, -center.y);
        return polygon;
    }

    public static final Polygon createUnitCirclePolygon(int count, double radius) {
        return Geometry.createUnitCirclePolygon(count, radius, 0.0);
    }

    public static final Polygon createUnitCirclePolygon(int count, double radius, double theta) {
        if (count < 3) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidVerticesSize"));
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidRadius"));
        }
        return Geometry.createPolygonalCircle(count, radius, theta);
    }

    public static final Rectangle createSquare(double size) {
        if (size <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSize"));
        }
        return new Rectangle(size, size);
    }

    public static final Rectangle createRectangle(double width, double height) {
        return new Rectangle(width, height);
    }

    public static final Triangle createTriangle(Vector2 p1, Vector2 p2, Vector2 p3) {
        if (p1 == null || p2 == null || p3 == null) {
            throw new NullPointerException(Messages.getString("geometry.nullTrianglePoint"));
        }
        return new Triangle(p1.copy(), p2.copy(), p3.copy());
    }

    public static final Triangle createTriangleAtOrigin(Vector2 p1, Vector2 p2, Vector2 p3) {
        Triangle triangle = Geometry.createTriangle(p1, p2, p3);
        Vector2 center = triangle.getCenter();
        triangle.translate(-center.x, -center.y);
        return triangle;
    }

    public static final Triangle createRightTriangle(double width, double height) {
        return Geometry.createRightTriangle(width, height, false);
    }

    public static final Triangle createRightTriangle(double width, double height, boolean mirror) {
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidHeight"));
        }
        Vector2 top = new Vector2(0.0, height);
        Vector2 left = new Vector2(0.0, 0.0);
        Vector2 right = new Vector2(mirror ? -width : width, 0.0);
        Triangle triangle = mirror ? new Triangle(top, right, left) : new Triangle(top, left, right);
        Vector2 center = triangle.getCenter();
        triangle.translate(-center.x, -center.y);
        return triangle;
    }

    public static final Triangle createEquilateralTriangle(double height) {
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidSize"));
        }
        double a = 2.0 * height * INV_SQRT_3;
        return Geometry.createIsoscelesTriangle(a, height);
    }

    public static final Triangle createIsoscelesTriangle(double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidHeight"));
        }
        Vector2 top = new Vector2(0.0, height);
        Vector2 left = new Vector2(-width * 0.5, 0.0);
        Vector2 right = new Vector2(width * 0.5, 0.0);
        Triangle triangle = new Triangle(top, left, right);
        Vector2 center = triangle.getCenter();
        triangle.translate(-center.x, -center.y);
        return triangle;
    }

    public static final Segment createSegment(Vector2 p1, Vector2 p2) {
        if (p1 == null || p2 == null) {
            throw new NullPointerException(Messages.getString("geometry.nullSegmentPoint"));
        }
        return new Segment(p1.copy(), p2.copy());
    }

    public static final Segment createSegmentAtOrigin(Vector2 p1, Vector2 p2) {
        Segment segment = Geometry.createSegment(p1, p2);
        Vector2 center = segment.getCenter();
        segment.translate(-center.x, -center.y);
        return segment;
    }

    public static final Segment createSegment(Vector2 end) {
        return Geometry.createSegment(new Vector2(), end);
    }

    public static final Segment createHorizontalSegment(double length) {
        if (length <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidLength"));
        }
        Vector2 start = new Vector2(-length * 0.5, 0.0);
        Vector2 end = new Vector2(length * 0.5, 0.0);
        return new Segment(start, end);
    }

    public static final Segment createVerticalSegment(double length) {
        if (length <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidLength"));
        }
        Vector2 start = new Vector2(0.0, -length * 0.5);
        Vector2 end = new Vector2(0.0, length * 0.5);
        return new Segment(start, end);
    }

    public static final Capsule createCapsule(double width, double height) {
        return new Capsule(width, height);
    }

    public static final Slice createSlice(double radius, double theta) {
        return new Slice(radius, theta);
    }

    public static final Slice createSliceAtOrigin(double radius, double theta) {
        Slice slice = new Slice(radius, theta);
        slice.translate(-slice.center.x, -slice.center.y);
        return slice;
    }

    public static final Ellipse createEllipse(double width, double height) {
        return new Ellipse(width, height);
    }

    public static final HalfEllipse createHalfEllipse(double width, double height) {
        return new HalfEllipse(width, height);
    }

    public static final HalfEllipse createHalfEllipseAtOrigin(double width, double height) {
        HalfEllipse half = new HalfEllipse(width, height);
        Vector2 c = half.getCenter();
        half.translate(-c.x, -c.y);
        return half;
    }

    public static final Polygon createPolygonalCircle(int count, double radius) {
        return Geometry.createPolygonalCircle(count, radius, 0.0);
    }

    public static final Polygon createPolygonalCircle(int count, double radius, double theta) {
        if (count < 3) {
            throw new IllegalArgumentException(Messages.getString("geometry.circleInvalidCount"));
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.circleInvalidRadius"));
        }
        double pin = Math.PI * 2 / (double)count;
        Vector2[] vertices = new Vector2[count];
        double c = Math.cos(pin);
        double s = Math.sin(pin);
        double t = 0.0;
        double x = radius;
        double y = 0.0;
        if (theta != 0.0) {
            x = radius * Math.cos(theta);
            y = radius * Math.sin(theta);
        }
        int i = 0;
        while (i < count) {
            vertices[i] = new Vector2(x, y);
            t = x;
            x = c * x - s * y;
            y = s * t + c * y;
            ++i;
        }
        return new Polygon(vertices);
    }

    public static final Polygon createPolygonalSlice(int count, double radius, double theta) {
        if (count < 1) {
            throw new IllegalArgumentException(Messages.getString("geometry.sliceInvalidCount"));
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.sliceInvalidRadius"));
        }
        if (theta <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.sliceInvalidTheta"));
        }
        double pin = theta / (double)(count + 1);
        Vector2[] vertices = new Vector2[count + 3];
        double c = Math.cos(pin);
        double s = Math.sin(pin);
        double t = 0.0;
        double x = radius * Math.cos(-theta * 0.5);
        double y = radius * Math.sin(-theta * 0.5);
        vertices[0] = new Vector2(x, y);
        vertices[count + 1] = new Vector2(x, -y);
        int i = 1;
        while (i < count + 1) {
            t = x;
            x = c * x - s * y;
            y = s * t + c * y;
            vertices[i] = new Vector2(x, y);
            ++i;
        }
        vertices[count + 2] = new Vector2();
        return new Polygon(vertices);
    }

    public static final Polygon createPolygonalSliceAtOrigin(int count, double radius, double theta) {
        Polygon polygon = Geometry.createPolygonalSlice(count, radius, theta);
        Vector2 center = polygon.getCenter();
        polygon.translate(-center.x, -center.y);
        return polygon;
    }

    public static final Polygon createPolygonalEllipse(int count, double width, double height) {
        if (count < 4) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipseInvalidCount"));
        }
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipseInvalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.ellipseInvalidHeight"));
        }
        double a = width * 0.5;
        double b = height * 0.5;
        int n2 = count / 2;
        double pin2 = Math.PI / (double)n2;
        Vector2[] vertices = new Vector2[n2 * 2];
        int j = 0;
        int i = 0;
        while (i < n2 + 1) {
            double t = pin2 * (double)i;
            double x = a * Math.cos(t);
            double y = b * Math.sin(t);
            if (i > 0) {
                vertices[vertices.length - j] = new Vector2(x, -y);
            }
            vertices[j++] = new Vector2(x, y);
            ++i;
        }
        return new Polygon(vertices);
    }

    public static final Polygon createPolygonalHalfEllipse(int count, double width, double height) {
        if (count < 1) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipseInvalidCount"));
        }
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipseInvalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipseInvalidHeight"));
        }
        double a = width * 0.5;
        double b = height * 0.5;
        double inc = Math.PI / (double)(count + 1);
        Vector2[] vertices = new Vector2[count + 2];
        vertices[0] = new Vector2(a, 0.0);
        vertices[count + 1] = new Vector2(-a, 0.0);
        int i = 1;
        while (i < count + 1) {
            double t = inc * (double)i;
            double x = a * Math.cos(t);
            double y = b * Math.sin(t);
            vertices[i] = new Vector2(x, y);
            ++i;
        }
        return new Polygon(vertices);
    }

    public static final Polygon createPolygonalHalfEllipseAtOrigin(int count, double width, double height) {
        Polygon polygon = Geometry.createPolygonalHalfEllipse(count, width, height);
        Vector2 center = polygon.getCenter();
        polygon.translate(-center.x, -center.y);
        return polygon;
    }

    public static final Polygon createPolygonalCapsule(int count, double width, double height) {
        if (count < 1) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsuleInvalidCount"));
        }
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsuleInvalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.capsuleInvalidHeight"));
        }
        if (Math.abs(width - height) < Epsilon.E) {
            return Geometry.createPolygonalCircle(count, width);
        }
        double pin = Math.PI / (double)(count + 1);
        Vector2[] vertices = new Vector2[4 + 2 * count];
        double c = Math.cos(pin);
        double s = Math.sin(pin);
        double t = 0.0;
        double major = width;
        double minor = height;
        boolean vertical = false;
        if (width < height) {
            major = height;
            minor = width;
            vertical = true;
        }
        double radius = minor * 0.5;
        double offset = major * 0.5 - radius;
        double ox = 0.0;
        double oy = 0.0;
        if (vertical) {
            oy = offset;
        } else {
            ox = offset;
        }
        int n = 0;
        double ao = vertical ? 0.0 : 1.5707963267948966;
        double x = radius * Math.cos(pin - ao);
        double y = radius * Math.sin(pin - ao);
        int i = 0;
        while (i < count) {
            vertices[n++] = new Vector2(x + ox, y + oy);
            t = x;
            x = c * x - s * y;
            y = s * t + c * y;
            ++i;
        }
        if (vertical) {
            vertices[n++] = new Vector2(-radius, oy);
            vertices[n++] = new Vector2(-radius, -oy);
        } else {
            vertices[n++] = new Vector2(ox, radius);
            vertices[n++] = new Vector2(-ox, radius);
        }
        ao = vertical ? Math.PI : 1.5707963267948966;
        x = radius * Math.cos(pin + ao);
        y = radius * Math.sin(pin + ao);
        i = 0;
        while (i < count) {
            vertices[n++] = new Vector2(x - ox, y - oy);
            t = x;
            x = c * x - s * y;
            y = s * t + c * y;
            ++i;
        }
        if (vertical) {
            vertices[n++] = new Vector2(radius, -oy);
            vertices[n++] = new Vector2(radius, oy);
        } else {
            vertices[n++] = new Vector2(-ox, -radius);
            vertices[n++] = new Vector2(ox, -radius);
        }
        return new Polygon(vertices);
    }

    public static final List<Vector2> cleanse(List<Vector2> points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointList"));
        }
        int size = points.size();
        if (size == 0) {
            return points;
        }
        ArrayList<Vector2> result = new ArrayList<Vector2>(size);
        double winding = 0.0;
        int i = 0;
        while (i < size) {
            Vector2 point = points.get(i);
            Vector2 prev = points.get(i - 1 < 0 ? size - 1 : i - 1);
            Vector2 next = points.get(i + 1 == size ? 0 : i + 1);
            if (point == null || prev == null || next == null) {
                throw new NullPointerException(Messages.getString("geometry.nullPointListElements"));
            }
            Vector2 diff = point.difference(next);
            if (!diff.isZero()) {
                double cross;
                Vector2 prevToPoint = prev.to(point);
                Vector2 pointToNext = point.to(next);
                if (prevToPoint.isZero() || !(Math.abs(cross = prevToPoint.cross(pointToNext)) <= Epsilon.E)) {
                    winding += point.cross(next);
                    result.add(point);
                }
            }
            ++i;
        }
        if (winding < 0.0) {
            Geometry.reverseWinding(result);
        }
        return result;
    }

    public static final Vector2[] cleanse(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.nullPointArray"));
        }
        List<Vector2> pointList = Arrays.asList(points);
        List<Vector2> resultList = Geometry.cleanse(pointList);
        Vector2[] result = new Vector2[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public static final Polygon flipAlongTheXAxis(Polygon polygon) {
        return Geometry.flip(polygon, Vector2.X_AXIS, null);
    }

    public static final Polygon flipAlongTheYAxis(Polygon polygon) {
        return Geometry.flip(polygon, Vector2.Y_AXIS, null);
    }

    public static final Polygon flipAlongTheXAxis(Polygon polygon, Vector2 point) {
        return Geometry.flip(polygon, Vector2.X_AXIS, point);
    }

    public static final Polygon flipAlongTheYAxis(Polygon polygon, Vector2 point) {
        return Geometry.flip(polygon, Vector2.Y_AXIS, point);
    }

    public static final Polygon flip(Polygon polygon, Vector2 axis) {
        return Geometry.flip(polygon, axis, null);
    }

    public static final Polygon flip(Polygon polygon, Vector2 axis, Vector2 point) {
        if (polygon == null) {
            throw new NullPointerException(Messages.getString("geometry.nullFlipPolygon"));
        }
        if (axis == null) {
            throw new NullPointerException(Messages.getString("geometry.nullFlipAxis"));
        }
        if (axis.isZero()) {
            throw new IllegalArgumentException(Messages.getString("geometry.zeroFlipAxis"));
        }
        if (point == null) {
            point = polygon.getCenter();
        }
        axis.normalize();
        Vector2[] pv = polygon.getVertices();
        Vector2[] nv = new Vector2[pv.length];
        int i = 0;
        while (i < pv.length) {
            Vector2 v0 = pv[i];
            Vector2 v1 = v0.difference(point);
            double proj = v1.dot(axis);
            Vector2 vp = axis.product(proj);
            Vector2 rv = vp.add(vp.x - v1.x, vp.y - v1.y);
            nv[i] = rv.add(point);
            ++i;
        }
        if (Geometry.getWinding(nv) < 0.0) {
            Geometry.reverseWinding(nv);
        }
        return new Polygon(nv);
    }

    public static final <E extends Wound & Convex> Polygon minkowskiSum(E convex1, E convex2) {
        Vector2 v;
        Vector2 s2;
        Vector2 s1;
        if (convex1 == null) {
            throw new NullPointerException(Messages.getString("geometry.nullMinkowskiSumConvex"));
        }
        if (convex2 == null) {
            throw new NullPointerException(Messages.getString("geometry.nullMinkowskiSumConvex"));
        }
        Vector2[] p1v = convex1.getVertices();
        Vector2[] p2v = convex2.getVertices();
        if (convex1 instanceof Segment && convex2 instanceof Segment && (s1 = p1v[0].to(p1v[1])).cross(s2 = p2v[0].to(p2v[1])) <= Epsilon.E) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidMinkowskiSumSegments"));
        }
        int c1 = p1v.length;
        int c2 = p2v.length;
        int i = 0;
        int j = 0;
        Vector2 min = new Vector2(Double.MAX_VALUE, Double.MAX_VALUE);
        int k = 0;
        while (k < c1) {
            v = p1v[k];
            if (v.y < min.y) {
                min.set(v);
                i = k;
            } else if (v.y == min.y && v.x < min.x) {
                min.set(v);
                i = k;
            }
            ++k;
        }
        min.set(Double.MAX_VALUE, Double.MAX_VALUE);
        k = 0;
        while (k < c2) {
            v = p2v[k];
            if (v.y < min.y) {
                min.set(v);
                j = k;
            } else if (v.y == min.y && v.x < min.x) {
                min.set(v);
                j = k;
            }
            ++k;
        }
        int n1 = c1 + i;
        int n2 = c2 + j;
        ArrayList<Vector2> sum = new ArrayList<Vector2>(c1 + c2);
        while (i <= n1 && j <= n2) {
            Vector2 v1s = p1v[i % c1];
            Vector2 v1e = p1v[(i + 1) % c1];
            Vector2 v2s = p2v[j % c2];
            Vector2 v2e = p2v[(j + 1) % c2];
            sum.add(v1s.sum(v2s));
            Vector2 e1 = v1s.to(v1e);
            Vector2 e2 = v2s.to(v2e);
            double a1 = Vector2.X_AXIS.getAngleBetween(e1);
            double a2 = Vector2.X_AXIS.getAngleBetween(e2);
            if (a1 < 0.0) {
                a1 += Math.PI * 2;
            }
            if (a2 < 0.0) {
                a2 += Math.PI * 2;
            }
            if (a1 < a2) {
                ++i;
                continue;
            }
            if (a1 > a2) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        return new Polygon(sum.toArray(new Vector2[0]));
    }

    public static final Polygon minkowskiSum(Circle circle, Polygon polygon, int count) {
        return Geometry.minkowskiSum(polygon, circle, count);
    }

    public static final Polygon minkowskiSum(Polygon polygon, Circle circle, int count) {
        if (circle == null) {
            throw new NullPointerException(Messages.getString("geometry.nullMinkowskiSumCircle"));
        }
        return Geometry.minkowskiSum(polygon, circle.radius, count);
    }

    public static final Polygon minkowskiSum(Polygon polygon, double radius, int count) {
        if (polygon == null) {
            throw new NullPointerException(Messages.getString("geometry.nullMinkowskiSumPolygon"));
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidMinkowskiSumRadius"));
        }
        if (count <= 0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidMinkowskiSumCount"));
        }
        Vector2[] vertices = polygon.vertices;
        Vector2[] normals = polygon.normals;
        int size = vertices.length;
        Vector2[] nVerts = new Vector2[size * 2 + size * count];
        int j = 0;
        int i = 0;
        while (i < size) {
            Vector2 v1 = vertices[i];
            Vector2 v2 = vertices[i + 1 == size ? 0 : i + 1];
            Vector2 normal = normals[i];
            Vector2 nv1 = normal.product(radius).add(v1);
            Vector2 nv2 = normal.product(radius).add(v2);
            Vector2 cv1 = null;
            if (i == 0) {
                Vector2 tn = normals[size - 1];
                cv1 = v1.to(tn.product(radius).add(v1));
            } else {
                cv1 = v1.to(nVerts[j - 1]);
            }
            Vector2 cv2 = v1.to(nv1);
            double theta = cv1.getAngleBetween(cv2);
            double pin = theta / (double)(count + 1);
            double c = Math.cos(pin);
            double s = Math.sin(pin);
            double t = 0.0;
            double sTheta = Vector2.X_AXIS.getAngleBetween(normals[i - 1 < 0 ? size - 1 : i - 1]);
            if (sTheta < 0.0) {
                sTheta += Math.PI * 2;
            }
            double x = radius * Math.cos(sTheta);
            double y = radius * Math.sin(sTheta);
            int k = 0;
            while (k < count) {
                t = x;
                x = c * x - s * y;
                y = s * t + c * y;
                nVerts[j++] = new Vector2(x, y).add(v1);
                ++k;
            }
            nVerts[j++] = nv1;
            nVerts[j++] = nv2;
            ++i;
        }
        return new Polygon(nVerts);
    }

    public static final Circle scale(Circle circle, double scale) {
        if (circle == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new Circle(circle.radius * scale);
    }

    public static final Capsule scale(Capsule capsule, double scale) {
        if (capsule == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new Capsule(capsule.getLength() * scale, capsule.getCapRadius() * 2.0 * scale);
    }

    public static final Ellipse scale(Ellipse ellipse, double scale) {
        if (ellipse == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new Ellipse(ellipse.getWidth() * scale, ellipse.getHeight() * scale);
    }

    public static final HalfEllipse scale(HalfEllipse halfEllipse, double scale) {
        if (halfEllipse == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new HalfEllipse(halfEllipse.getWidth() * scale, halfEllipse.getHeight() * scale);
    }

    public static final Slice scale(Slice slice, double scale) {
        if (slice == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        return new Slice(slice.getSliceRadius() * scale, slice.getTheta());
    }

    public static final Polygon scale(Polygon polygon, double scale) {
        if (polygon == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        Vector2[] oVertices = polygon.vertices;
        int size = oVertices.length;
        Vector2[] vertices = new Vector2[size];
        Vector2 center = polygon.center;
        int i = 0;
        while (i < size) {
            vertices[i] = center.to(oVertices[i]).multiply(scale).add(center);
            ++i;
        }
        return new Polygon(vertices);
    }

    public static final Segment scale(Segment segment, double scale) {
        if (segment == null) {
            throw new NullPointerException(Messages.getString("geometry.nullShape"));
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.invalidScale"));
        }
        double length = segment.getLength() * scale * 0.5;
        Vector2 n = segment.vertices[0].to(segment.vertices[1]);
        n.normalize();
        n.multiply(length);
        return new Segment(segment.center.sum(n.x, n.y), segment.center.difference(n.x, n.y));
    }
}

