/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.resources.Messages;

public class Interval {
    protected double min;
    protected double max;

    public Interval(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException(Messages.getString("geometry.interval.invalid"));
        }
        this.min = min;
        this.max = max;
    }

    public Interval(Interval interval) {
        this.min = interval.min;
        this.max = interval.max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.min).append(", ").append(this.max).append("]");
        return sb.toString();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double min) {
        if (min > this.max) {
            throw new IllegalArgumentException(Messages.getString("geometry.interval.invalidMinimum"));
        }
        this.min = min;
    }

    public void setMax(double max) {
        if (max < this.min) {
            throw new IllegalArgumentException(Messages.getString("geometry.interval.invalidMaximum"));
        }
        this.max = max;
    }

    public boolean includesInclusive(double value) {
        return value <= this.max && value >= this.min;
    }

    public boolean includesExclusive(double value) {
        return value < this.max && value > this.min;
    }

    public boolean includesInclusiveMin(double value) {
        return value < this.max && value >= this.min;
    }

    public boolean includesInclusiveMax(double value) {
        return value <= this.max && value > this.min;
    }

    public boolean overlaps(Interval interval) {
        return !(this.min > interval.max) && !(interval.min > this.max);
    }

    public double getOverlap(Interval interval) {
        if (this.overlaps(interval)) {
            return Math.min(this.max, interval.max) - Math.max(this.min, interval.min);
        }
        return 0.0;
    }

    public double clamp(double value) {
        return Interval.clamp(value, this.min, this.max);
    }

    public static double clamp(double value, double min, double max) {
        if (value <= max && value >= min) {
            return value;
        }
        if (max < value) {
            return max;
        }
        return min;
    }

    public boolean isDegenerate() {
        return this.min == this.max;
    }

    public boolean isDegenerate(double error) {
        return Math.abs(this.max - this.min) <= error;
    }

    public boolean contains(Interval interval) {
        return interval.min > this.min && interval.max < this.max;
    }

    public void union(Interval interval) {
        this.min = Math.min(interval.min, this.min);
        this.max = Math.max(interval.max, this.max);
    }

    public Interval getUnion(Interval interval) {
        return new Interval(Math.min(interval.min, this.min), Math.max(interval.max, this.max));
    }

    public void intersection(Interval interval) {
        if (this.overlaps(interval)) {
            this.min = Math.max(interval.min, this.min);
            this.max = Math.min(interval.max, this.max);
        } else {
            this.min = 0.0;
            this.max = 0.0;
        }
    }

    public Interval getIntersection(Interval interval) {
        if (this.overlaps(interval)) {
            return new Interval(Math.max(interval.min, this.min), Math.min(interval.max, this.max));
        }
        return new Interval(0.0, 0.0);
    }

    public double distance(Interval interval) {
        if (!this.overlaps(interval)) {
            if (this.max < interval.min) {
                return interval.min - this.max;
            }
            return this.min - interval.max;
        }
        return 0.0;
    }

    public void expand(double value) {
        double e = value * 0.5;
        this.min -= e;
        this.max += e;
        if (value < 0.0 && this.min > this.max) {
            double p;
            this.min = p = (this.min + this.max) * 0.5;
            this.max = p;
        }
    }

    public Interval getExpanded(double value) {
        double e = value * 0.5;
        double min = this.min - e;
        double max = this.max + e;
        if (value < 0.0 && min > max) {
            double p;
            min = p = (min + max) * 0.5;
            max = p;
        }
        return new Interval(min, max);
    }

    public double getLength() {
        return this.max - this.min;
    }
}

