/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.MassType;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Mass {
    MassType type;
    final Vector2 center;
    final double mass;
    final double inertia;
    final double invMass;
    final double invInertia;

    public Mass() {
        this.type = MassType.INFINITE;
        this.center = new Vector2();
        this.mass = 0.0;
        this.inertia = 0.0;
        this.invMass = 0.0;
        this.invInertia = 0.0;
    }

    public Mass(Vector2 center, double mass, double inertia) {
        if (center == null) {
            throw new NullPointerException(Messages.getString("geometry.mass.nullCenter"));
        }
        if (mass < 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.mass.invalidMass"));
        }
        if (inertia < 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.mass.invalidInertia"));
        }
        this.type = MassType.NORMAL;
        this.center = center.copy();
        this.mass = mass;
        this.inertia = inertia;
        if (mass > Epsilon.E) {
            this.invMass = 1.0 / mass;
        } else {
            this.invMass = 0.0;
            this.type = MassType.FIXED_LINEAR_VELOCITY;
        }
        if (inertia > Epsilon.E) {
            this.invInertia = 1.0 / inertia;
        } else {
            this.invInertia = 0.0;
            this.type = MassType.FIXED_ANGULAR_VELOCITY;
        }
        if (mass <= Epsilon.E && inertia <= Epsilon.E) {
            this.type = MassType.INFINITE;
        }
    }

    public Mass(Mass mass) {
        if (mass == null) {
            throw new NullPointerException(Messages.getString("geometry.mass.nullMass"));
        }
        this.type = mass.type;
        this.center = mass.center.copy();
        this.mass = mass.mass;
        this.inertia = mass.inertia;
        this.invMass = mass.invMass;
        this.invInertia = mass.invInertia;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Mass[Type=").append((Object)this.type).append("|Center=").append(this.center).append("|Mass=").append(this.mass).append("|Inertia=").append(this.inertia).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.center == null ? 0 : this.center.hashCode());
        long temp = Double.doubleToLongBits(this.inertia);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.invInertia);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.invMass);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mass);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof Mass) {
            Mass o = (Mass)other;
            if (this.type == o.type && this.mass == o.mass && this.inertia == o.inertia && this.center.equals(o.center)) {
                return true;
            }
        }
        return false;
    }

    public static Mass create(List<Mass> masses) {
        Mass mass;
        if (masses == null) {
            throw new NullPointerException(Messages.getString("geometry.mass.nullMassList"));
        }
        if (masses.size() == 0) {
            throw new IllegalArgumentException(Messages.getString("geometry.mass.invalidMassListSize"));
        }
        int size = masses.size();
        if (size == 1) {
            Mass m = masses.get(0);
            if (m != null) {
                return new Mass(masses.get(0));
            }
            throw new NullPointerException(Messages.getString("geometry.mass.invalidMassListSize"));
        }
        Vector2 c = new Vector2();
        double m = 0.0;
        double I = 0.0;
        int i = 0;
        while (i < size) {
            mass = masses.get(i);
            if (mass == null) {
                throw new NullPointerException(Messages.getString("geometry.mass.nullMassListElement"));
            }
            c.add(mass.center.product(mass.mass));
            m += mass.mass;
            ++i;
        }
        if (m > 0.0) {
            c.multiply(1.0 / m);
        }
        i = 0;
        while (i < size) {
            mass = masses.get(i);
            double d2 = mass.center.distanceSquared(c);
            double Idis = mass.inertia + mass.mass * d2;
            I += Idis;
            ++i;
        }
        return new Mass(c, m, I);
    }

    public boolean isInfinite() {
        return this.type == MassType.INFINITE;
    }

    public void setType(MassType type) {
        if (type == null) {
            throw new NullPointerException(Messages.getString("geometry.mass.nullMassType"));
        }
        this.type = type;
    }

    public MassType getType() {
        return this.type;
    }

    public Vector2 getCenter() {
        return this.center;
    }

    public double getMass() {
        if (this.type == MassType.INFINITE || this.type == MassType.FIXED_LINEAR_VELOCITY) {
            return 0.0;
        }
        return this.mass;
    }

    public double getInertia() {
        if (this.type == MassType.INFINITE || this.type == MassType.FIXED_ANGULAR_VELOCITY) {
            return 0.0;
        }
        return this.inertia;
    }

    public double getInverseMass() {
        if (this.type == MassType.INFINITE || this.type == MassType.FIXED_LINEAR_VELOCITY) {
            return 0.0;
        }
        return this.invMass;
    }

    public double getInverseInertia() {
        if (this.type == MassType.INFINITE || this.type == MassType.FIXED_ANGULAR_VELOCITY) {
            return 0.0;
        }
        return this.invInertia;
    }
}

