/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Ray {
    protected Vector2 start;
    protected Vector2 direction;

    public Ray(double direction) {
        this(new Vector2(direction));
    }

    public Ray(Vector2 direction) {
        this(new Vector2(), direction);
    }

    public Ray(Vector2 start, double direction) {
        this(start, new Vector2(direction));
    }

    public Ray(Vector2 start, Vector2 direction) {
        if (start == null) {
            throw new NullPointerException(Messages.getString("geometry.ray.nullStart"));
        }
        if (direction == null) {
            throw new NullPointerException(Messages.getString("geometry.ray.nullDirection"));
        }
        if (direction.isZero()) {
            throw new IllegalArgumentException(Messages.getString("geometry.ray.zeroDirection"));
        }
        this.start = start;
        this.direction = direction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ray[Start=").append(this.start).append("|Direction=").append(this.getDirection()).append("]");
        return sb.toString();
    }

    public Vector2 getStart() {
        return this.start;
    }

    public void setStart(Vector2 start) {
        if (start == null) {
            throw new NullPointerException(Messages.getString("geometry.ray.nullStart"));
        }
        this.start = start;
    }

    public void setDirection(double direction) {
        this.direction = new Vector2(direction);
    }

    public double getDirection() {
        return this.direction.getDirection();
    }

    public void setDirection(Vector2 direction) {
        if (direction == null) {
            throw new NullPointerException(Messages.getString("geometry.ray.nullDirection"));
        }
        if (direction.isZero()) {
            throw new IllegalArgumentException(Messages.getString("geometry.ray.zeroDirection"));
        }
        this.direction = direction;
    }

    public Vector2 getDirectionVector() {
        return this.direction;
    }
}

