/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.DataContainer;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Polygon;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Wound;
import org.dyn4j.resources.Messages;

public class Rectangle
extends Polygon
implements Convex,
Wound,
Shape,
Transformable,
DataContainer {
    final double width;
    final double height;

    private Rectangle(boolean valid, double width, double height, Vector2[] vertices) {
        super(new Vector2(), vertices[0].getMagnitude(), vertices, new Vector2[]{new Vector2(0.0, -1.0), new Vector2(1.0, 0.0), new Vector2(0.0, 1.0), new Vector2(-1.0, 0.0)});
        this.width = width;
        this.height = height;
    }

    public Rectangle(double width, double height) {
        this(Rectangle.validate(width, height), width, height, new Vector2[]{new Vector2(-width * 0.5, -height * 0.5), new Vector2(width * 0.5, -height * 0.5), new Vector2(width * 0.5, height * 0.5), new Vector2(-width * 0.5, height * 0.5)});
    }

    private static final boolean validate(double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.rectangle.invalidWidth"));
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.rectangle.invalidHeight"));
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rectangle[").append(super.toString()).append("|Width=").append(this.width).append("|Height=").append(this.height).append("]");
        return sb.toString();
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.normals[1]);
    }

    @Override
    public Vector2[] getAxes(Vector2[] foci, Transform transform) {
        int fociSize = foci != null ? foci.length : 0;
        Vector2[] axes = new Vector2[2 + fociSize];
        int n = 0;
        axes[n++] = transform.getTransformedR(this.normals[1]);
        axes[n++] = transform.getTransformedR(this.normals[2]);
        int i = 0;
        while (i < fociSize) {
            Vector2 focus = foci[i];
            Vector2 closest = transform.getTransformed(this.vertices[0]);
            double d = focus.distanceSquared(closest);
            int j = 1;
            while (j < 4) {
                Vector2 vertex = this.vertices[j];
                double dt = focus.distanceSquared(vertex = transform.getTransformed(vertex));
                if (dt < d) {
                    closest = vertex;
                    d = dt;
                }
                ++j;
            }
            Vector2 axis = focus.to(closest);
            axis.normalize();
            axes[n++] = axis;
            ++i;
        }
        return axes;
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        Vector2 p = transform.getInverseTransformed(point);
        Vector2 c = this.center;
        Vector2 p1 = this.vertices[0];
        Vector2 p2 = this.vertices[1];
        Vector2 p4 = this.vertices[3];
        double widthSquared = p1.distanceSquared(p2);
        double heightSquared = p1.distanceSquared(p4);
        Vector2 projectAxis0 = p1.to(p2);
        Vector2 projectAxis1 = p1.to(p4);
        Vector2 toPoint = c.to(p);
        return toPoint.project(projectAxis0).getMagnitudeSquared() <= widthSquared * 0.25 && toPoint.project(projectAxis1).getMagnitudeSquared() <= heightSquared * 0.25;
    }

    @Override
    public Interval project(Vector2 vector, Transform transform) {
        Vector2 center = transform.getTransformed(this.center);
        Vector2 projectAxis0 = transform.getTransformedR(this.normals[1]);
        Vector2 projectAxis1 = transform.getTransformedR(this.normals[2]);
        double c = center.dot(vector);
        double e = this.width * 0.5 * Math.abs(projectAxis0.dot(vector)) + this.height * 0.5 * Math.abs(projectAxis1.dot(vector));
        return new Interval(c - e, c + e);
    }

    @Override
    public Mass createMass(double density) {
        double height = this.height;
        double width = this.width;
        double mass = density * height * width;
        double inertia = mass * (height * height + width * width) / 12.0;
        return new Mass(this.center, mass, inertia);
    }
}

