/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.Iterator;
import org.dyn4j.DataContainer;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.EdgeFeature;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.PointFeature;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Wound;
import org.dyn4j.geometry.WoundIterator;
import org.dyn4j.resources.Messages;

public class Segment
extends AbstractShape
implements Convex,
Wound,
Shape,
Transformable,
DataContainer {
    final Vector2[] vertices;
    final Vector2[] normals;
    final double length;

    private Segment(boolean valid, Vector2[] vertices, Vector2 segment, double length) {
        super(Geometry.getAverageCenter(vertices), length * 0.5);
        this.vertices = vertices;
        this.normals = new Vector2[2];
        this.normals[0] = segment.right();
        this.normals[0].normalize();
        this.normals[1] = segment.getNegative();
        this.normals[1].normalize();
        this.length = length;
    }

    public Segment(Vector2 point1, Vector2 point2) {
        this(Segment.validate(point1, point2), new Vector2[]{point1, point2}, point1.to(point2), point1.distance(point2));
    }

    private static final boolean validate(Vector2 point1, Vector2 point2) {
        if (point1 == null) {
            throw new NullPointerException(Messages.getString("geometry.segment.nullPoint1"));
        }
        if (point2 == null) {
            throw new NullPointerException(Messages.getString("geometry.segment.nullPoint2"));
        }
        if (point1.equals(point2)) {
            throw new IllegalArgumentException(Messages.getString("geometry.segment.samePoint"));
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Segment[").append(super.toString()).append("|Length=").append(this.length).append("]");
        return sb.toString();
    }

    @Override
    public Vector2[] getVertices() {
        return this.vertices;
    }

    @Override
    public Vector2[] getNormals() {
        return this.normals;
    }

    @Override
    public Iterator<Vector2> getVertexIterator() {
        return new WoundIterator(this.vertices);
    }

    @Override
    public Iterator<Vector2> getNormalIterator() {
        return new WoundIterator(this.normals);
    }

    @Override
    public double getRadius(Vector2 center) {
        return Geometry.getRotationRadius(center, this.vertices);
    }

    public Vector2 getPoint1() {
        return this.vertices[0];
    }

    public Vector2 getPoint2() {
        return this.vertices[1];
    }

    public double getLength() {
        return this.length;
    }

    public static double getLocation(Vector2 point, Vector2 linePoint1, Vector2 linePoint2) {
        return (linePoint2.x - linePoint1.x) * (point.y - linePoint1.y) - (point.x - linePoint1.x) * (linePoint2.y - linePoint1.y);
    }

    public static Vector2 getPointOnLineClosestToPoint(Vector2 point, Vector2 linePoint1, Vector2 linePoint2) {
        Vector2 p1ToP = point.difference(linePoint1);
        Vector2 line = linePoint2.difference(linePoint1);
        double ab2 = line.dot(line);
        if (ab2 <= Epsilon.E) {
            return linePoint1.copy();
        }
        double ap_ab = p1ToP.dot(line);
        double t = ap_ab / ab2;
        return line.multiply(t).add(linePoint1);
    }

    public Vector2 getPointOnLineClosestToPoint(Vector2 point) {
        return Segment.getPointOnLineClosestToPoint(point, this.vertices[0], this.vertices[1]);
    }

    public static Vector2 getPointOnSegmentClosestToPoint(Vector2 point, Vector2 linePoint1, Vector2 linePoint2) {
        Vector2 p1ToP = point.difference(linePoint1);
        Vector2 line = linePoint2.difference(linePoint1);
        double ab2 = line.dot(line);
        double ap_ab = p1ToP.dot(line);
        if (ab2 <= Epsilon.E) {
            return linePoint1.copy();
        }
        double t = ap_ab / ab2;
        t = Interval.clamp(t, 0.0, 1.0);
        return line.multiply(t).add(linePoint1);
    }

    public Vector2 getPointOnSegmentClosestToPoint(Vector2 point) {
        return Segment.getPointOnSegmentClosestToPoint(point, this.vertices[0], this.vertices[1]);
    }

    public static Vector2 getLineIntersection(Vector2 ap1, Vector2 ap2, Vector2 bp1, Vector2 bp2) {
        Vector2 A = ap1.to(ap2);
        Vector2 B = bp1.to(bp2);
        double BxA = B.cross(A);
        if (Math.abs(BxA) <= Epsilon.E) {
            return null;
        }
        double ambxA = ap1.difference(bp1).cross(A);
        if (Math.abs(ambxA) <= Epsilon.E) {
            return null;
        }
        double tb = ambxA / BxA;
        return B.product(tb).add(bp1);
    }

    public Vector2 getLineIntersection(Segment segment) {
        return Segment.getLineIntersection(this.vertices[0], this.vertices[1], segment.vertices[0], segment.vertices[1]);
    }

    public static Vector2 getSegmentIntersection(Vector2 ap1, Vector2 ap2, Vector2 bp1, Vector2 bp2) {
        Vector2 A = ap1.to(ap2);
        Vector2 B = bp1.to(bp2);
        double BxA = B.cross(A);
        if (Math.abs(BxA) <= Epsilon.E) {
            return null;
        }
        double ambxA = ap1.difference(bp1).cross(A);
        if (Math.abs(ambxA) <= Epsilon.E) {
            return null;
        }
        double tb = ambxA / BxA;
        if (tb < 0.0 || tb > 1.0) {
            return null;
        }
        Vector2 ip = B.product(tb).add(bp1);
        double ta = ip.difference(ap1).dot(A) / A.dot(A);
        if (ta < 0.0 || ta > 1.0) {
            return null;
        }
        return ip;
    }

    public Vector2 getSegmentIntersection(Segment segment) {
        return Segment.getSegmentIntersection(this.vertices[0], this.vertices[1], segment.vertices[0], segment.vertices[1]);
    }

    public static final EdgeFeature getFarthestFeature(Vector2 v1, Vector2 v2, Vector2 vector, Transform transform) {
        Vector2 max = null;
        Vector2 p1 = transform.getTransformed(v1);
        Vector2 p2 = transform.getTransformed(v2);
        double dot1 = vector.dot(p1);
        double dot2 = vector.dot(p2);
        int index = 0;
        if (dot1 >= dot2) {
            max = p1;
            index = 0;
        } else {
            max = p2;
            index = 1;
        }
        PointFeature vp1 = new PointFeature(p1, 0);
        PointFeature vp2 = new PointFeature(p2, 1);
        PointFeature vm = new PointFeature(max, index);
        if (p1.to(p2).right().dot(vector) > 0.0) {
            return new EdgeFeature(vp2, vp1, vm, p2.to(p1), 0);
        }
        return new EdgeFeature(vp1, vp2, vm, p1.to(p2), 0);
    }

    public static final Vector2 getFarthestPoint(Vector2 v1, Vector2 v2, Vector2 vector, Transform transform) {
        double dot2;
        Vector2 p1 = transform.getTransformed(v1);
        Vector2 p2 = transform.getTransformed(v2);
        double dot1 = vector.dot(p1);
        if (dot1 >= (dot2 = vector.dot(p2))) {
            return p1;
        }
        return p2;
    }

    @Override
    public Vector2[] getAxes(Vector2[] foci, Transform transform) {
        int size = foci != null ? foci.length : 0;
        Vector2[] axes = new Vector2[2 + size];
        int n = 0;
        Vector2 p1 = transform.getTransformed(this.vertices[0]);
        Vector2 p2 = transform.getTransformed(this.vertices[1]);
        axes[n++] = transform.getTransformedR(this.normals[1]);
        axes[n++] = transform.getTransformedR(this.normals[0].getLeftHandOrthogonalVector());
        int i = 0;
        while (i < size) {
            Vector2 f = foci[i];
            Vector2 axis = p1.distanceSquared(f) < p2.distanceSquared(f) ? p1.to(f) : p2.to(f);
            axis.normalize();
            axes[n++] = axis;
            ++i;
        }
        return axes;
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        return null;
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        Vector2 p2;
        Vector2 p1;
        Vector2 p = transform.getInverseTransformed(point);
        double value = Segment.getLocation(p, p1 = this.vertices[0], p2 = this.vertices[1]);
        if (Math.abs(value) <= Epsilon.E) {
            double distSqrd = p1.distanceSquared(p2);
            return p.distanceSquared(p1) <= distSqrd && p.distanceSquared(p2) <= distSqrd;
        }
        return false;
    }

    public boolean contains(Vector2 point, Transform transform, double radius) {
        double dist;
        if (radius <= 0.0) {
            return this.contains(point, transform);
        }
        Vector2 p = transform.getInverseTransformed(point);
        if (this.vertices[0].distanceSquared(p) <= radius * radius) {
            return true;
        }
        if (this.vertices[1].distanceSquared(p) <= radius * radius) {
            return true;
        }
        Vector2 l = this.vertices[0].to(this.vertices[1]);
        Vector2 p1 = this.vertices[0].to(p);
        Vector2 p2 = this.vertices[1].to(p);
        return l.dot(p1) > 0.0 && -l.dot(p2) > 0.0 && (dist = p1.project(l.getRightHandOrthogonalVector()).getMagnitudeSquared()) <= radius * radius;
    }

    @Override
    public Interval project(Vector2 vector, Transform transform) {
        double min;
        double v = 0.0;
        Vector2 p1 = transform.getTransformed(this.vertices[0]);
        Vector2 p2 = transform.getTransformed(this.vertices[1]);
        double max = min = vector.dot(p1);
        v = vector.dot(p2);
        if (v < min) {
            min = v;
        } else if (v > max) {
            max = v;
        }
        return new Interval(min, max);
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector, Transform transform) {
        return Segment.getFarthestPoint(this.vertices[0], this.vertices[1], vector, transform);
    }

    @Override
    public EdgeFeature getFarthestFeature(Vector2 vector, Transform transform) {
        return Segment.getFarthestFeature(this.vertices[0], this.vertices[1], vector, transform);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        super.rotate(theta, x, y);
        this.vertices[0].rotate(theta, x, y);
        this.vertices[1].rotate(theta, x, y);
        this.normals[0].rotate(theta);
        this.normals[1].rotate(theta);
    }

    @Override
    public void translate(double x, double y) {
        super.translate(x, y);
        this.vertices[0].add(x, y);
        this.vertices[1].add(x, y);
    }

    @Override
    public Mass createMass(double density) {
        double length = this.length;
        double mass = density * length;
        double inertia = length * length * mass / 12.0;
        return new Mass(this.center, mass, inertia);
    }

    @Override
    public AABB createAABB(Transform transform) {
        double minY;
        double minX;
        double vx = 0.0;
        double vy = 0.0;
        Vector2 p = transform.getTransformed(this.vertices[0]);
        double maxX = minX = Vector2.X_AXIS.dot(p);
        double maxY = minY = Vector2.Y_AXIS.dot(p);
        p = transform.getTransformed(this.vertices[1]);
        vx = Vector2.X_AXIS.dot(p);
        vy = Vector2.Y_AXIS.dot(p);
        minX = Math.min(minX, vx);
        maxX = Math.max(maxX, vx);
        minY = Math.min(minY, vy);
        maxY = Math.max(maxY, vy);
        return new AABB(minX, minY, maxX, maxY);
    }
}

