/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.DataContainer;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.PointFeature;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Slice
extends AbstractShape
implements Convex,
Shape,
Transformable,
DataContainer {
    final double theta;
    final double alpha;
    final double sliceRadius;
    final Vector2[] vertices;
    final Vector2[] normals;
    final Vector2 localXAxis;

    private Slice(boolean valid, double radius, double theta, Vector2 center) {
        super(center, Math.max(center.x, radius - center.x));
        this.sliceRadius = radius;
        this.theta = theta;
        this.alpha = theta * 0.5;
        double x = radius * Math.cos(this.alpha);
        double y = radius * Math.sin(this.alpha);
        this.vertices = new Vector2[]{new Vector2(), new Vector2(x, y), new Vector2(x, -y)};
        Vector2 v1 = this.vertices[1].to(this.vertices[0]);
        Vector2 v2 = this.vertices[0].to(this.vertices[2]);
        v1.left().normalize();
        v2.left().normalize();
        this.normals = new Vector2[]{v1, v2};
        this.localXAxis = new Vector2(1.0, 0.0);
    }

    public Slice(double radius, double theta) {
        this(Slice.validate(radius, theta), radius, theta, new Vector2(2.0 * radius * Math.sin(theta * 0.5) / (1.5 * theta), 0.0));
    }

    private static final boolean validate(double radius, double theta) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.slice.invalidRadius"));
        }
        if (theta <= 0.0 || theta > Math.PI) {
            throw new IllegalArgumentException(Messages.getString("geometry.slice.invalidTheta"));
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Slice[").append(super.toString()).append("|Radius=").append(this.sliceRadius).append("|Theta=").append(this.theta).append("]");
        return sb.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] foci, Transform transform) {
        int fociSize = foci != null ? foci.length : 0;
        int size = this.vertices.length;
        Vector2[] axes = new Vector2[2 + fociSize];
        int n = 0;
        axes[n++] = transform.getTransformedR(this.normals[0]);
        axes[n++] = transform.getTransformedR(this.normals[1]);
        Vector2 focus = transform.getTransformed(this.vertices[0]);
        int i = 0;
        while (i < fociSize) {
            Vector2 f = foci[i];
            Vector2 closest = focus;
            double d = f.distanceSquared(closest);
            int j = 1;
            while (j < size) {
                Vector2 p = this.vertices[j];
                double dt = f.distanceSquared(p = transform.getTransformed(p));
                if (dt < d) {
                    closest = p;
                    d = dt;
                }
                ++j;
            }
            Vector2 axis = f.to(closest);
            axis.normalize();
            axes[n++] = axis;
            ++i;
        }
        return axes;
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        return new Vector2[]{transform.getTransformed(this.vertices[0])};
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector, Transform transform) {
        Vector2 localn = transform.getInverseTransformedR(vector);
        if (Math.abs(localn.getAngleBetween(this.localXAxis)) > this.alpha) {
            Vector2 point = new Vector2();
            point.set(this.vertices[0]);
            double max = localn.dot(this.vertices[0]);
            int size = this.vertices.length;
            int i = 1;
            while (i < size) {
                Vector2 v = this.vertices[i];
                double projection = localn.dot(v);
                if (projection > max) {
                    point.set(v);
                    max = projection;
                }
                ++i;
            }
            transform.transform(point);
            return point;
        }
        localn.normalize();
        localn.multiply(this.sliceRadius).add(this.vertices[0]);
        transform.transform(localn);
        return localn;
    }

    @Override
    public Feature getFarthestFeature(Vector2 vector, Transform transform) {
        Vector2 localAxis = transform.getInverseTransformedR(vector);
        if (Math.abs(localAxis.getAngleBetween(this.localXAxis)) <= this.alpha) {
            Vector2 point = this.getFarthestPoint(vector, transform);
            return new PointFeature(point);
        }
        if (Math.PI - this.theta <= 1.0E-6) {
            return Segment.getFarthestFeature(this.vertices[1], this.vertices[2], vector, transform);
        }
        if (localAxis.y > 0.0) {
            return Segment.getFarthestFeature(this.vertices[0], this.vertices[1], vector, transform);
        }
        if (localAxis.y < 0.0) {
            return Segment.getFarthestFeature(this.vertices[0], this.vertices[2], vector, transform);
        }
        return new PointFeature(transform.getTransformed(this.vertices[0]));
    }

    @Override
    public Interval project(Vector2 vector, Transform transform) {
        Vector2 p1 = this.getFarthestPoint(vector, transform);
        Vector2 p2 = this.getFarthestPoint(vector.getNegative(), transform);
        double d1 = p1.dot(vector);
        double d2 = p2.dot(vector);
        return new Interval(d2, d1);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Interval x = this.project(Vector2.X_AXIS, transform);
        Interval y = this.project(Vector2.Y_AXIS, transform);
        return new AABB(x.getMin(), y.getMin(), x.getMax(), y.getMax());
    }

    @Override
    public Mass createMass(double density) {
        double r2 = this.sliceRadius * this.sliceRadius;
        double m = density * r2 * this.alpha;
        double sina = Math.sin(this.alpha);
        double I = 0.05555555555555555 * r2 * r2 * (9.0 * this.alpha * this.alpha - 8.0 * sina * sina) / this.alpha;
        return new Mass(this.center, m, I);
    }

    @Override
    public double getRadius(Vector2 center) {
        return this.radius + center.distance(this.center);
    }

    @Override
    public boolean contains(Vector2 point, Transform transform) {
        Vector2 lp = transform.getInverseTransformed(point);
        double radiusSquared = this.sliceRadius * this.sliceRadius;
        Vector2 v = this.vertices[0].to(lp);
        return v.getMagnitudeSquared() <= radiusSquared && Segment.getLocation(lp, this.vertices[0], this.vertices[1]) <= 0.0 && Segment.getLocation(lp, this.vertices[0], this.vertices[2]) >= 0.0;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        super.rotate(theta, x, y);
        int i = 0;
        while (i < this.vertices.length) {
            this.vertices[i].rotate(theta, x, y);
            ++i;
        }
        i = 0;
        while (i < this.normals.length) {
            this.normals[i].rotate(theta);
            ++i;
        }
        this.localXAxis.rotate(theta);
    }

    @Override
    public void translate(double x, double y) {
        super.translate(x, y);
        int i = 0;
        while (i < this.vertices.length) {
            this.vertices[i].add(x, y);
            ++i;
        }
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.localXAxis);
    }

    public double getTheta() {
        return this.theta;
    }

    public double getSliceRadius() {
        return this.sliceRadius;
    }

    public Vector2 getCircleCenter() {
        return this.vertices[0];
    }
}

