/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Transform
implements Transformable {
    public static final Transform IDENTITY = new Transform(){

        @Override
        public final void identity() {
        }

        @Override
        public final void rotate(double theta) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void rotate(double theta, double x, double y) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void rotate(double theta, Vector2 point) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void translate(double x, double y) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void translate(Vector2 vector) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void set(Transform transform) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void setTranslation(double x, double y) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void setTranslationX(double x) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void setTranslationY(double y) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void setTranslation(Vector2 translation) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final double setRotation(double theta) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }

        @Override
        public final void lerp(Transform end, double alpha) {
            throw new UnsupportedOperationException(Messages.getString("geometry.transform.immutable"));
        }
    };
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double x = 0.0;
    protected double y = 0.0;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.m00).append(" ").append(this.m01).append(" | ").append(this.x).append("]").append("[").append(this.m10).append(" ").append(this.m11).append(" | ").append(this.y).append("]");
        return sb.toString();
    }

    @Override
    public void rotate(double theta) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double m00 = cos * this.m00 - sin * this.m10;
        double m01 = cos * this.m01 - sin * this.m11;
        double m10 = sin * this.m00 + cos * this.m10;
        double m11 = sin * this.m01 + cos * this.m11;
        double x = cos * this.x - sin * this.y;
        double y = sin * this.x + cos * this.y;
        this.m00 = m00;
        this.m01 = m01;
        this.m10 = m10;
        this.m11 = m11;
        this.x = x;
        this.y = y;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        double cm00 = this.m00;
        double cm01 = this.m01;
        double cx = this.x;
        double cm10 = this.m10;
        double cm11 = this.m11;
        double cy = this.y;
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double rx = x - cos * x + sin * y;
        double ry = y - sin * x - cos * y;
        this.m00 = cos * cm00 - sin * cm10;
        this.m01 = cos * cm01 - sin * cm11;
        this.x = cos * cx - sin * cy + rx;
        this.m10 = sin * cm00 + cos * cm10;
        this.m11 = sin * cm01 + cos * cm11;
        this.y = sin * cx + cos * cy + ry;
    }

    @Override
    public void rotate(double theta, Vector2 point) {
        this.rotate(theta, point.x, point.y);
    }

    @Override
    public void translate(double x, double y) {
        this.x += x;
        this.y += y;
    }

    @Override
    public void translate(Vector2 vector) {
        this.x += vector.x;
        this.y += vector.y;
    }

    public Transform copy() {
        Transform t = new Transform();
        t.m00 = this.m00;
        t.m01 = this.m01;
        t.x = this.x;
        t.m10 = this.m10;
        t.m11 = this.m11;
        t.y = this.y;
        return t;
    }

    public void set(Transform transform) {
        this.m00 = transform.m00;
        this.m01 = transform.m01;
        this.m10 = transform.m10;
        this.m11 = transform.m11;
        this.x = transform.x;
        this.y = transform.y;
    }

    public void identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.x = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.y = 0.0;
    }

    public Vector2 getTransformed(Vector2 vector) {
        Vector2 tv = new Vector2();
        double x = vector.x;
        double y = vector.y;
        tv.x = this.m00 * x + this.m01 * y + this.x;
        tv.y = this.m10 * x + this.m11 * y + this.y;
        return tv;
    }

    public void getTransformed(Vector2 vector, Vector2 destination) {
        double x = vector.x;
        double y = vector.y;
        destination.x = this.m00 * x + this.m01 * y + this.x;
        destination.y = this.m10 * x + this.m11 * y + this.y;
    }

    public void transform(Vector2 vector) {
        double x = vector.x;
        double y = vector.y;
        vector.x = this.m00 * x + this.m01 * y + this.x;
        vector.y = this.m10 * x + this.m11 * y + this.y;
    }

    public Vector2 getInverseTransformed(Vector2 vector) {
        Vector2 tv = new Vector2();
        double tx = vector.x - this.x;
        double ty = vector.y - this.y;
        tv.x = this.m00 * tx + this.m10 * ty;
        tv.y = this.m01 * tx + this.m11 * ty;
        return tv;
    }

    public void getInverseTransformed(Vector2 vector, Vector2 destination) {
        double tx = vector.x - this.x;
        double ty = vector.y - this.y;
        destination.x = this.m00 * tx + this.m10 * ty;
        destination.y = this.m01 * tx + this.m11 * ty;
    }

    public void inverseTransform(Vector2 vector) {
        double x = vector.x - this.x;
        double y = vector.y - this.y;
        vector.x = this.m00 * x + this.m10 * y;
        vector.y = this.m01 * x + this.m11 * y;
    }

    public Vector2 getTransformedR(Vector2 vector) {
        Vector2 v = new Vector2();
        double x = vector.x;
        double y = vector.y;
        v.x = this.m00 * x + this.m01 * y;
        v.y = this.m10 * x + this.m11 * y;
        return v;
    }

    public void getTransformedR(Vector2 vector, Vector2 destination) {
        double x = vector.x;
        double y = vector.y;
        destination.x = this.m00 * x + this.m01 * y;
        destination.y = this.m10 * x + this.m11 * y;
    }

    public void transformR(Vector2 vector) {
        double x = vector.x;
        double y = vector.y;
        vector.x = this.m00 * x + this.m01 * y;
        vector.y = this.m10 * x + this.m11 * y;
    }

    public Vector2 getInverseTransformedR(Vector2 vector) {
        Vector2 v = new Vector2();
        double x = vector.x;
        double y = vector.y;
        v.x = this.m00 * x + this.m10 * y;
        v.y = this.m01 * x + this.m11 * y;
        return v;
    }

    public void getInverseTransformedR(Vector2 vector, Vector2 destination) {
        double x = vector.x;
        double y = vector.y;
        destination.x = this.m00 * x + this.m10 * y;
        destination.y = this.m01 * x + this.m11 * y;
    }

    public void inverseTransformR(Vector2 vector) {
        double x = vector.x;
        double y = vector.y;
        vector.x = this.m00 * x + this.m10 * y;
        vector.y = this.m01 * x + this.m11 * y;
    }

    public double getTranslationX() {
        return this.x;
    }

    public void setTranslationX(double x) {
        this.x = x;
    }

    public double getTranslationY() {
        return this.y;
    }

    public void setTranslationY(double y) {
        this.y = y;
    }

    public Vector2 getTranslation() {
        return new Vector2(this.x, this.y);
    }

    public void setTranslation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setTranslation(Vector2 translation) {
        this.setTranslation(translation.x, translation.y);
    }

    public Transform getTranslationTransform() {
        Transform t = new Transform();
        t.translate(this.x, this.y);
        return t;
    }

    public double getRotation() {
        return Math.atan2(this.m10, this.m00);
    }

    public double setRotation(double theta) {
        double r = this.getRotation();
        this.rotate(-r, this.x, this.y);
        this.rotate(theta, this.x, this.y);
        return r;
    }

    public Transform getRotationTransform() {
        Transform t = new Transform();
        t.rotate(this.getRotation());
        return t;
    }

    public double[] getValues() {
        return new double[]{this.m00, this.m01, this.x, this.m10, this.m11, this.y};
    }

    public void lerp(Transform end, double alpha) {
        double a1 = 1.0 - alpha;
        double x = a1 * this.x + alpha * end.x;
        double y = a1 * this.y + alpha * end.y;
        double rs = this.getRotation();
        double re = end.getRotation();
        double diff = re - rs;
        if (diff < -Math.PI) {
            diff += Math.PI * 2;
        }
        if (diff > Math.PI) {
            diff -= Math.PI * 2;
        }
        double a = diff * alpha + rs;
        this.identity();
        this.rotate(a);
        this.translate(x, y);
    }

    public void lerp(Transform end, double alpha, Transform result) {
        double a1 = 1.0 - alpha;
        double x = a1 * this.x + alpha * end.x;
        double y = a1 * this.y + alpha * end.y;
        double rs = this.getRotation();
        double re = end.getRotation();
        double diff = re - rs;
        if (diff < -Math.PI) {
            diff += Math.PI * 2;
        }
        if (diff > Math.PI) {
            diff -= Math.PI * 2;
        }
        double a = diff * alpha + rs;
        result.identity();
        result.rotate(a);
        result.translate(x, y);
    }

    public void lerp(Vector2 dp, double da, double alpha, Transform result) {
        result.set(this);
        result.translate(dp.x * alpha, dp.y * alpha);
        result.rotate(da * alpha, result.getTranslationX(), result.getTranslationY());
    }

    public void lerp(Vector2 dp, double da, double alpha) {
        this.translate(dp.x * alpha, dp.y * alpha);
        this.rotate(da * alpha, this.getTranslationX(), this.getTranslationY());
    }

    public Transform lerped(Vector2 dp, double da, double alpha) {
        Transform result = new Transform();
        result.set(this);
        result.translate(dp.x * alpha, dp.y * alpha);
        result.rotate(da * alpha, result.getTranslationX(), result.getTranslationY());
        return result;
    }

    public Transform lerped(Transform end, double alpha) {
        double a1 = 1.0 - alpha;
        double x = a1 * this.x + alpha * end.x;
        double y = a1 * this.y + alpha * end.y;
        double rs = this.getRotation();
        double re = end.getRotation();
        double diff = re - rs;
        if (diff < -Math.PI) {
            diff += Math.PI * 2;
        }
        if (diff > Math.PI) {
            diff -= Math.PI * 2;
        }
        double a = diff * alpha + rs;
        Transform tx = new Transform();
        tx.rotate(a);
        tx.translate(x, y);
        return tx;
    }
}

