/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;

public class Vector2 {
    static final Vector2 X_AXIS = new Vector2(1.0, 0.0);
    static final Vector2 Y_AXIS = new Vector2(0.0, 1.0);
    public double x;
    public double y;

    public Vector2() {
    }

    public Vector2(Vector2 vector) {
        this.x = vector.x;
        this.y = vector.y;
    }

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(double x1, double y1, double x2, double y2) {
        this.x = x2 - x1;
        this.y = y2 - y1;
    }

    public Vector2(Vector2 p1, Vector2 p2) {
        this.x = p2.x - p1.x;
        this.y = p2.y - p1.y;
    }

    public Vector2(double direction) {
        this.x = Math.cos(direction);
        this.y = Math.sin(direction);
    }

    public static Vector2 create(double magnitude, double direction) {
        double x = magnitude * Math.cos(direction);
        double y = magnitude * Math.sin(direction);
        return new Vector2(x, y);
    }

    public Vector2 copy() {
        return new Vector2(this.x, this.y);
    }

    public double distance(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(Vector2 point) {
        double dx = this.x - point.x;
        double dy = this.y - point.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distanceSquared(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public double distanceSquared(Vector2 point) {
        double dx = this.x - point.x;
        double dy = this.y - point.y;
        return dx * dx + dy * dy;
    }

    public static Vector2 tripleProduct(Vector2 a, Vector2 b, Vector2 c) {
        Vector2 r = new Vector2();
        double ac = a.x * c.x + a.y * c.y;
        double bc = b.x * c.x + b.y * c.y;
        r.x = b.x * ac - a.x * bc;
        r.y = b.y * ac - a.y * bc;
        return r;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vector2) {
            Vector2 vector = (Vector2)obj;
            return this.x == vector.x && this.y == vector.y;
        }
        return false;
    }

    public boolean equals(Vector2 vector) {
        if (vector == null) {
            return false;
        }
        if (this == vector) {
            return true;
        }
        return this.x == vector.x && this.y == vector.y;
    }

    public boolean equals(double x, double y) {
        return this.x == x && this.y == y;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.x).append(", ").append(this.y).append(")");
        return sb.toString();
    }

    public Vector2 set(Vector2 vector) {
        this.x = vector.x;
        this.y = vector.y;
        return this;
    }

    public Vector2 set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2 getXComponent() {
        return new Vector2(this.x, 0.0);
    }

    public Vector2 getYComponent() {
        return new Vector2(0.0, this.y);
    }

    public double getMagnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2 setMagnitude(double magnitude) {
        if (Math.abs(magnitude) <= Epsilon.E) {
            this.x = 0.0;
            this.y = 0.0;
            return this;
        }
        if (this.isZero()) {
            return this;
        }
        double mag = Math.sqrt(this.x * this.x + this.y * this.y);
        mag = magnitude / mag;
        this.x *= mag;
        this.y *= mag;
        return this;
    }

    public double getDirection() {
        return Math.atan2(this.y, this.x);
    }

    public Vector2 setDirection(double angle) {
        double magnitude = Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = magnitude * Math.cos(angle);
        this.y = magnitude * Math.sin(angle);
        return this;
    }

    public Vector2 add(Vector2 vector) {
        this.x += vector.x;
        this.y += vector.y;
        return this;
    }

    public Vector2 add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2 sum(Vector2 vector) {
        return new Vector2(this.x + vector.x, this.y + vector.y);
    }

    public Vector2 sum(double x, double y) {
        return new Vector2(this.x + x, this.y + y);
    }

    public Vector2 subtract(Vector2 vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        return this;
    }

    public Vector2 subtract(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2 difference(Vector2 vector) {
        return new Vector2(this.x - vector.x, this.y - vector.y);
    }

    public Vector2 difference(double x, double y) {
        return new Vector2(this.x - x, this.y - y);
    }

    public Vector2 to(Vector2 vector) {
        return new Vector2(vector.x - this.x, vector.y - this.y);
    }

    public Vector2 to(double x, double y) {
        return new Vector2(x - this.x, y - this.y);
    }

    public Vector2 multiply(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2 product(double scalar) {
        return new Vector2(this.x * scalar, this.y * scalar);
    }

    public double dot(Vector2 vector) {
        return this.x * vector.x + this.y * vector.y;
    }

    public double dot(double x, double y) {
        return this.x * x + this.y * y;
    }

    public double cross(Vector2 vector) {
        return this.x * vector.y - this.y * vector.x;
    }

    public double cross(double x, double y) {
        return this.x * y - this.y * x;
    }

    public Vector2 cross(double z) {
        return new Vector2(-1.0 * this.y * z, this.x * z);
    }

    public boolean isOrthogonal(Vector2 vector) {
        return Math.abs(this.x * vector.x + this.y * vector.y) <= Epsilon.E;
    }

    public boolean isOrthogonal(double x, double y) {
        return Math.abs(this.x * x + this.y * y) <= Epsilon.E;
    }

    public boolean isZero() {
        return Math.abs(this.x) <= Epsilon.E && Math.abs(this.y) <= Epsilon.E;
    }

    public Vector2 negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        return this;
    }

    public Vector2 getNegative() {
        return new Vector2(-this.x, -this.y);
    }

    public Vector2 zero() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    public Vector2 rotate(double theta) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double x = this.x;
        double y = this.y;
        this.x = x * cos - y * sin;
        this.y = x * sin + y * cos;
        return this;
    }

    public Vector2 rotate(double theta, double x, double y) {
        this.x -= x;
        this.y -= y;
        this.rotate(theta);
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2 rotate(double theta, Vector2 point) {
        return this.rotate(theta, point.x, point.y);
    }

    public Vector2 project(Vector2 vector) {
        double dotProd = this.dot(vector);
        double denominator = vector.dot(vector);
        if (denominator <= Epsilon.E) {
            return new Vector2();
        }
        denominator = dotProd / denominator;
        return new Vector2(denominator * vector.x, denominator * vector.y);
    }

    public Vector2 getRightHandOrthogonalVector() {
        return new Vector2(-this.y, this.x);
    }

    public Vector2 right() {
        double temp = this.x;
        this.x = -this.y;
        this.y = temp;
        return this;
    }

    public Vector2 getLeftHandOrthogonalVector() {
        return new Vector2(this.y, -this.x);
    }

    public Vector2 left() {
        double temp = this.x;
        this.x = this.y;
        this.y = -temp;
        return this;
    }

    public Vector2 getNormalized() {
        double magnitude = this.getMagnitude();
        if (magnitude <= Epsilon.E) {
            return new Vector2();
        }
        magnitude = 1.0 / magnitude;
        return new Vector2(this.x * magnitude, this.y * magnitude);
    }

    public double normalize() {
        double magnitude = Math.sqrt(this.x * this.x + this.y * this.y);
        if (magnitude <= Epsilon.E) {
            return 0.0;
        }
        double m = 1.0 / magnitude;
        this.x *= m;
        this.y *= m;
        return magnitude;
    }

    public double getAngleBetween(Vector2 vector) {
        double a = Math.atan2(vector.y, vector.x) - Math.atan2(this.y, this.x);
        if (a > Math.PI) {
            return a - Math.PI * 2;
        }
        if (a < -Math.PI) {
            return a + Math.PI * 2;
        }
        return a;
    }
}

