/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;

public class Vector3 {
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(Vector3 vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.x = x2 - x1;
        this.y = y2 - y1;
        this.z = z2 - z1;
    }

    public Vector3(Vector3 p1, Vector3 p2) {
        this.x = p2.x - p1.x;
        this.y = p2.y - p1.y;
        this.z = p2.z - p1.z;
    }

    public Vector3 copy() {
        return new Vector3(this.x, this.y, this.z);
    }

    public double distance(double x, double y, double z) {
        double xd = this.x - x;
        double yd = this.y - y;
        double zd = this.z - z;
        return Math.sqrt(xd * xd + yd * yd + zd * zd);
    }

    public double distance(Vector3 point) {
        double xd = this.x - point.x;
        double yd = this.y - point.y;
        double zd = this.z - point.z;
        return Math.sqrt(xd * xd + yd * yd + zd * zd);
    }

    public double distanceSquared(double x, double y, double z) {
        double xd = this.x - x;
        double yd = this.y - y;
        double zd = this.z - z;
        return xd * xd + yd * yd + zd * zd;
    }

    public double distanceSquared(Vector3 point) {
        double xd = this.x - point.x;
        double yd = this.y - point.y;
        double zd = this.z - point.z;
        return xd * xd + yd * yd + zd * zd;
    }

    public static Vector3 tripleProduct(Vector3 a, Vector3 b, Vector3 c) {
        Vector3 r = new Vector3();
        double ac = a.x * c.x + a.y * c.y + a.z * c.z;
        double bc = b.x * c.x + b.y * c.y + b.z * c.z;
        r.x = b.x * ac - a.x * bc;
        r.y = b.y * ac - a.y * bc;
        r.z = b.z * ac - a.z * bc;
        return r;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vector3) {
            Vector3 other = (Vector3)obj;
            if (this.x == other.x && this.y == other.y && this.z == other.z) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Vector3 vector) {
        if (vector == null) {
            return false;
        }
        if (this == vector) {
            return true;
        }
        return this.x == vector.x && this.y == vector.y && this.z == vector.z;
    }

    public boolean equals(double x, double y, double z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.x).append(", ").append(this.y).append(", ").append(this.z).append(")");
        return sb.toString();
    }

    public Vector3 set(Vector3 vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
        return this;
    }

    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3 getXComponent() {
        return new Vector3(this.x, 0.0, 0.0);
    }

    public Vector3 getYComponent() {
        return new Vector3(0.0, this.y, 0.0);
    }

    public Vector3 getZComponent() {
        return new Vector3(0.0, 0.0, this.z);
    }

    public double getMagnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 setMagnitude(double magnitude) {
        if (Math.abs(magnitude) <= Epsilon.E) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            return this;
        }
        if (this.isZero()) {
            return this;
        }
        double mag = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        mag = magnitude / mag;
        this.x *= mag;
        this.y *= mag;
        this.z *= mag;
        return this;
    }

    public Vector3 add(Vector3 vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
        return this;
    }

    public Vector3 add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3 sum(Vector3 vector) {
        return new Vector3(this.x + vector.x, this.y + vector.y, this.z + vector.z);
    }

    public Vector3 sum(double x, double y, double z) {
        return new Vector3(this.x + x, this.y + y, this.z + z);
    }

    public Vector3 subtract(Vector3 vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
        return this;
    }

    public Vector3 subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3 difference(Vector3 vector) {
        return new Vector3(this.x - vector.x, this.y - vector.y, this.z - vector.z);
    }

    public Vector3 difference(double x, double y, double z) {
        return new Vector3(this.x - x, this.y - y, this.z - z);
    }

    public Vector3 to(Vector3 vector) {
        return new Vector3(vector.x - this.x, vector.y - this.y, vector.z - this.z);
    }

    public Vector3 to(double x, double y, double z) {
        return new Vector3(x - this.x, y - this.y, z - this.z);
    }

    public Vector3 multiply(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3 product(double scalar) {
        return new Vector3(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public double dot(Vector3 vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public double dot(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public Vector3 cross(Vector3 vector) {
        return new Vector3(this.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
    }

    public Vector3 cross(double x, double y, double z) {
        return new Vector3(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public boolean isOrthogonal(Vector3 vector) {
        return Math.abs(this.x * vector.x + this.y * vector.y + this.z * vector.z) <= Epsilon.E;
    }

    public boolean isOrthogonal(double x, double y, double z) {
        return Math.abs(this.x * x + this.y * y + this.z * z) <= Epsilon.E;
    }

    public boolean isZero() {
        return Math.abs(this.x) <= Epsilon.E && Math.abs(this.y) <= Epsilon.E && Math.abs(this.z) <= Epsilon.E;
    }

    public Vector3 negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
        return this;
    }

    public Vector3 getNegative() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public Vector3 zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public Vector3 project(Vector3 vector) {
        double dotProd = this.dot(vector);
        double denominator = vector.dot(vector);
        if (denominator <= Epsilon.E) {
            return new Vector3();
        }
        denominator = dotProd / denominator;
        return new Vector3(denominator * vector.x, denominator * vector.y, denominator * vector.z);
    }

    public Vector3 getNormalized() {
        double magnitude = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (magnitude <= Epsilon.E) {
            return new Vector3();
        }
        magnitude = 1.0 / magnitude;
        return new Vector3(this.x * magnitude, this.y * magnitude, this.z * magnitude);
    }

    public double normalize() {
        double magnitude = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (magnitude <= Epsilon.E) {
            return 0.0;
        }
        double m = 1.0 / magnitude;
        this.x *= m;
        this.y *= m;
        this.z *= m;
        return magnitude;
    }
}

