/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.dyn4j.geometry.Vector2;

final class WoundIterator
implements Iterator<Vector2> {
    final Vector2[] vectors;
    int index;

    public WoundIterator(Vector2[] vectors) {
        this.vectors = vectors;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.vectors.length;
    }

    @Override
    public Vector2 next() {
        if (this.index >= this.vectors.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            ++this.index;
            Vector2 v = this.vectors[this.index];
            return v.copy();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

