/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.List;
import java.util.PriorityQueue;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.ClosestEdgeToVertexSearchCriteria;
import org.dyn4j.geometry.decompose.Decomposer;
import org.dyn4j.geometry.decompose.DoubleEdgeList;
import org.dyn4j.geometry.decompose.SweepLineEdge;
import org.dyn4j.geometry.decompose.SweepLineState;
import org.dyn4j.geometry.decompose.SweepLineVertex;
import org.dyn4j.geometry.decompose.SweepLineVertexType;
import org.dyn4j.geometry.decompose.Triangulator;
import org.dyn4j.resources.Messages;

public class SweepLine
implements Decomposer,
Triangulator {
    @Override
    public List<Convex> decompose(Vector2 ... points) {
        DoubleEdgeList dcel = this.createTriangulation(points);
        dcel.hertelMehlhorn();
        return dcel.getConvexDecomposition();
    }

    @Override
    public List<Triangle> triangulate(Vector2 ... points) {
        DoubleEdgeList dcel = this.createTriangulation(points);
        return dcel.getTriangulation();
    }

    final DoubleEdgeList createTriangulation(Vector2 ... points) {
        if (points == null) {
            throw new NullPointerException(Messages.getString("geometry.decompose.nullArray"));
        }
        int size = points.length;
        if (size < 4) {
            throw new IllegalArgumentException(Messages.getString("geometry.decompose.invalidSize"));
        }
        double winding = Geometry.getWinding(points);
        if (winding < 0.0) {
            Geometry.reverseWinding(points);
        }
        SweepLineState sweepstate = new SweepLineState();
        PriorityQueue<SweepLineVertex> queue = sweepstate.initialize(points);
        while (!queue.isEmpty()) {
            SweepLineVertex vertex = queue.poll();
            if (vertex.type == SweepLineVertexType.START) {
                this.start(vertex, sweepstate);
                continue;
            }
            if (vertex.type == SweepLineVertexType.END) {
                this.end(vertex, sweepstate);
                continue;
            }
            if (vertex.type == SweepLineVertexType.SPLIT) {
                this.split(vertex, sweepstate);
                continue;
            }
            if (vertex.type == SweepLineVertexType.MERGE) {
                this.merge(vertex, sweepstate);
                continue;
            }
            if (vertex.type != SweepLineVertexType.REGULAR) continue;
            this.regular(vertex, sweepstate);
        }
        sweepstate.dcel.triangulateYMonotonePolygons();
        return sweepstate.dcel;
    }

    final void start(SweepLineVertex vertex, SweepLineState sweepstate) {
        SweepLineEdge leftEdge = vertex.left;
        sweepstate.referenceY.value = vertex.point.y;
        sweepstate.tree.insert(leftEdge);
        leftEdge.helper = vertex;
    }

    final void end(SweepLineVertex vertex, SweepLineState sweepstate) {
        SweepLineEdge rightEdge = vertex.right;
        if (rightEdge.helper.type == SweepLineVertexType.MERGE) {
            sweepstate.dcel.addHalfEdges(vertex.index, rightEdge.helper.index);
        }
        sweepstate.referenceY.value = vertex.point.y;
        sweepstate.tree.remove(rightEdge);
    }

    final void split(SweepLineVertex vertex, SweepLineState sweepstate) {
        SweepLineEdge ej = sweepstate.tree.search(new ClosestEdgeToVertexSearchCriteria((SweepLineVertex)vertex)).closest;
        sweepstate.dcel.addHalfEdges(vertex.index, ej.helper.index);
        ej.helper = vertex;
        sweepstate.referenceY.value = vertex.point.y;
        sweepstate.tree.insert(vertex.left);
        vertex.left.helper = vertex;
    }

    final void merge(SweepLineVertex vertex, SweepLineState sweepstate) {
        SweepLineEdge eiPrev = vertex.right;
        if (eiPrev.helper.type == SweepLineVertexType.MERGE) {
            sweepstate.dcel.addHalfEdges(vertex.index, eiPrev.helper.index);
        }
        sweepstate.referenceY.value = vertex.point.y;
        sweepstate.tree.remove(eiPrev);
        SweepLineEdge ej = sweepstate.tree.search(new ClosestEdgeToVertexSearchCriteria((SweepLineVertex)vertex)).closest;
        if (ej.helper.type == SweepLineVertexType.MERGE) {
            sweepstate.dcel.addHalfEdges(vertex.index, ej.helper.index);
        }
        ej.helper = vertex;
    }

    final void regular(SweepLineVertex vertex, SweepLineState sweepstate) {
        if (vertex.isInteriorRight()) {
            if (vertex.right.helper.type == SweepLineVertexType.MERGE) {
                sweepstate.dcel.addHalfEdges(vertex.index, vertex.right.helper.index);
            }
            sweepstate.referenceY.value = vertex.point.y;
            sweepstate.tree.remove(vertex.right);
            sweepstate.tree.insert(vertex.left);
            vertex.left.helper = vertex;
        } else {
            SweepLineEdge ej = sweepstate.tree.search(new ClosestEdgeToVertexSearchCriteria((SweepLineVertex)vertex)).closest;
            if (ej.helper.type == SweepLineVertexType.MERGE) {
                sweepstate.dcel.addHalfEdges(vertex.index, ej.helper.index);
            }
            ej.helper = vertex;
        }
    }
}

