/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.sql.classes;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.develnext.jphp.ext.sql.classes.PSqlResult;
import org.develnext.jphp.ext.sql.classes.PSqlStatement;
import org.develnext.jphp.ext.sql.classes.WrapSqlException;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Abstract
@Reflection.Name(value="SqlConnection")
@Reflection.Namespace(value="php\\sql")
public class PSqlConnection
extends BaseObject {
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    protected Connection connection;
    protected DatabaseMetaData metaData;

    public PSqlConnection(Environment env, Connection connection) {
        super(env);
        this.connection = connection;
        try {
            this.metaData = connection.getMetaData();
        }
        catch (SQLException e) {
            throw new WrapSqlException(env, e);
        }
    }

    public PSqlConnection(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Setter
    public void setAutoCommit(boolean value) throws SQLException {
        this.connection.setAutoCommit(value);
    }

    @Reflection.Getter
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Reflection.Setter
    public void setReadOnly(boolean value) throws SQLException {
        this.connection.setReadOnly(value);
    }

    @Reflection.Getter
    public boolean getReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Reflection.Setter
    public void setTransactionIsolation(int value) throws SQLException {
        this.connection.setTransactionIsolation(value);
    }

    @Reflection.Getter
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Reflection.Setter
    public void setCatalog(String value) throws SQLException {
        this.connection.setCatalog(value);
    }

    @Reflection.Getter
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Reflection.Signature
    public Memory getCatalogs(Environment env) throws SQLException {
        ResultSet catalogs = this.metaData.getCatalogs();
        ArrayMemory r = new ArrayMemory();
        while (catalogs.next()) {
            r.add((Memory)new PSqlResult(env, catalogs).toArray(env));
        }
        return r.toConstant();
    }

    @Reflection.Signature
    public Memory getSchemas(Environment env) throws SQLException {
        ResultSet schemas = this.metaData.getSchemas();
        ArrayMemory r = new ArrayMemory();
        while (schemas.next()) {
            r.add((Memory)new PSqlResult(env, schemas).toArray(env));
        }
        return r.toConstant();
    }

    @Reflection.Signature
    public Memory getMetaData() throws SQLException {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("userName").assign(this.metaData.getUserName());
        r.refOfIndex("driverName").assign(this.metaData.getDriverName());
        r.refOfIndex("driverVersion").assign(this.metaData.getDriverVersion());
        r.refOfIndex("databaseName").assign(this.metaData.getDatabaseProductName());
        r.refOfIndex("databaseVersion").assign(this.metaData.getDatabaseProductVersion());
        r.refOfIndex("catalogSeparator").assign(this.metaData.getCatalogSeparator());
        r.refOfIndex("catalogTerm").assign(this.metaData.getCatalogTerm());
        r.refOfIndex("schemaTerm").assign(this.metaData.getSchemaTerm());
        r.refOfIndex("procedureTerm").assign(this.metaData.getProcedureTerm());
        r.refOfIndex("searchStringEscape").assign(this.metaData.getSearchStringEscape());
        r.refOfIndex("numericFunctions").assign(this.metaData.getNumericFunctions());
        r.refOfIndex("stringFunctions").assign(this.metaData.getStringFunctions());
        r.refOfIndex("timeDateFunctions").assign(this.metaData.getTimeDateFunctions());
        r.refOfIndex("systemFunctions").assign(this.metaData.getSystemFunctions());
        r.refOfIndex("defaultTransactionIsolation").assign((long)this.metaData.getDefaultTransactionIsolation());
        r.refOfIndex("identifierQuoteString").assign(this.metaData.getIdentifierQuoteString());
        r.refOfIndex("maxBinaryLiteralLength").assign((long)this.metaData.getMaxBinaryLiteralLength());
        r.refOfIndex("maxCatalogNameLength").assign((long)this.metaData.getMaxCatalogNameLength());
        r.refOfIndex("maxCharLiteralLength").assign((long)this.metaData.getMaxCharLiteralLength());
        r.refOfIndex("maxConnections").assign((long)this.metaData.getMaxConnections());
        r.refOfIndex("maxColumnNameLength").assign((long)this.metaData.getMaxColumnNameLength());
        r.refOfIndex("maxColumnsInGroupBy").assign((long)this.metaData.getMaxColumnsInGroupBy());
        r.refOfIndex("maxColumnsInIndex").assign((long)this.metaData.getMaxColumnsInIndex());
        r.refOfIndex("maxColumnsInOrderBy").assign((long)this.metaData.getMaxColumnsInOrderBy());
        r.refOfIndex("maxColumnsInSelect").assign((long)this.metaData.getMaxColumnsInSelect());
        r.refOfIndex("maxColumnsInTable").assign((long)this.metaData.getMaxColumnsInTable());
        r.refOfIndex("maxCursorNameLength").assign((long)this.metaData.getMaxCursorNameLength());
        r.refOfIndex("maxIndexLength").assign((long)this.metaData.getMaxIndexLength());
        r.refOfIndex("maxProcedureNameLength").assign((long)this.metaData.getMaxProcedureNameLength());
        r.refOfIndex("maxRowSize").assign((long)this.metaData.getMaxRowSize());
        r.refOfIndex("maxSchemaNameLength").assign((long)this.metaData.getMaxSchemaNameLength());
        r.refOfIndex("maxStatementLength").assign((long)this.metaData.getMaxStatementLength());
        r.refOfIndex("maxTableNameLength").assign((long)this.metaData.getMaxTableNameLength());
        r.refOfIndex("maxTablesInSelect").assign((long)this.metaData.getMaxTablesInSelect());
        return r.toConstant();
    }

    @Reflection.Signature
    public PSqlStatement query(Environment env, String sql) throws Throwable {
        return this.query(env, sql, null);
    }

    @Reflection.Signature
    public PSqlStatement query(Environment env, String sql, @Reflection.Nullable ArrayMemory args) throws Throwable {
        PreparedStatement statement = this.connection.prepareStatement(sql, 2);
        PSqlStatement sqlStatement = new PSqlStatement(env, statement);
        if (args != null) {
            int index = 0;
            for (ReferenceMemory arg : args) {
                env.invokeMethod((IObject)sqlStatement, "bind", new Memory[]{LongMemory.valueOf((int)index), arg.getValue()});
                ++index;
            }
        }
        return sqlStatement;
    }

    @Reflection.Signature
    public String identifier(String value) throws SQLException {
        String identifierQuoteString = this.connection.getMetaData().getIdentifierQuoteString();
        return identifierQuoteString + value + identifierQuoteString;
    }

    @Reflection.Signature
    public void close() throws SQLException {
        this.connection.close();
    }

    @Reflection.Signature
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Reflection.Signature
    public void commit() throws SQLException {
        this.connection.commit();
    }
}

