/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.sql.classes;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.develnext.jphp.ext.sql.classes.PSqlConnection;
import org.develnext.jphp.ext.sql.classes.PSqlConnectionPool;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="SqlDriverManager")
@Reflection.Namespace(value="php\\sql")
public final class PSqlDriverManager
extends BaseObject {
    protected static final Map<String, String> dataSourceClasses = new HashMap<String, String>(){
        {
            this.put("sqlite", "org.sqlite.javax.SQLiteConnectionPoolDataSource");
            this.put("mysql", "com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            this.put("psql", "org.postgresql.ds.PGPoolingDataSource");
            this.put("postgres", "org.postgresql.ds.PGPoolingDataSource");
            this.put("postgresql", "org.postgresql.ds.PGPoolingDataSource");
            this.put("mssql", "com.microsoft.sqlserver.jdbc.SQLServerDataSource");
            this.put("sybase", "com.sybase.jdbc4.jdbc.SybDataSource");
            this.put("hsql", "org.hsqldb.jdbc.JDBCDataSource");
            this.put("firebird", "org.firebirdsql.pool.FBWrappingDataSource");
        }
    };
    protected static final Map<String, String> driverClasses = new HashMap<String, String>(){
        {
            this.put("db2", "COM.ibm.db2.jdbc.app.DB2Driver");
            this.put("mysql", "com.mysql.jdbc.Driver");
            this.put("psql", "org.postgresql.Driver");
            this.put("postgres", "org.postgresql.Driver");
            this.put("postgresql", "org.postgresql.Driver");
            this.put("postgresql", "org.postgresql.Driver");
            this.put("mssql", "com.microsoft.jdbc.sqlserver.SQLServerDriver");
            this.put("sybase", "com.sybase.jdbc2.jdbc.SybDriver");
            this.put("firebird", "org.firebirdsql.jdbc.FBDriver");
            this.put("hsql", "org.hsql.jdbcDriver");
            this.put("interbase", "interbase.interclient.Driver");
            this.put("sqlite", "org.sqlite.JDBC");
        }
    };

    public PSqlDriverManager(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    private void __construct() {
    }

    protected static String _getDriverClass(String dbName) {
        String driverClass = driverClasses.get(dbName.toLowerCase());
        if (driverClass == null) {
            driverClass = dbName;
        }
        return driverClass;
    }

    @Reflection.Signature
    public static void install(String dbName) throws SQLException {
        String driverClass = PSqlDriverManager._getDriverClass(dbName);
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Driver class '" + driverClass + "' is not found in classpath");
        }
    }

    @Reflection.Signature
    public static PSqlConnectionPool getPool(Environment env, String url, String driverName) throws SQLException {
        return PSqlDriverManager.getPool(env, url, driverName, null);
    }

    @Reflection.Signature
    public static PSqlConnectionPool getPool(Environment env, String url, String driverName, @Reflection.Nullable Properties properties) throws SQLException {
        HikariConfig config = new HikariConfig(properties == null ? new Properties() : properties);
        if (config.getDataSourceClassName() == null) {
            config.setDataSourceClassName(dataSourceClasses.get(driverName));
        }
        HikariDataSource pool = new HikariDataSource(config);
        pool.setDriverClassName(PSqlDriverManager._getDriverClass(driverName));
        pool.setJdbcUrl("jdbc:" + url);
        return new PSqlConnectionPool(env, pool);
    }

    @Reflection.Signature
    public static PSqlConnection getConnection(Environment env, String url) throws SQLException {
        return PSqlDriverManager.getConnection(env, url, null);
    }

    @Reflection.Signature
    public static PSqlConnection getConnection(Environment env, String url, @Reflection.Nullable Properties properties) throws SQLException {
        return new PSqlConnection(env, DriverManager.getConnection("jdbc:" + url, properties == null ? new Properties() : properties));
    }
}

