/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version13;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.version11.V11WireOperations;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class V13WireOperations
extends V11WireOperations {
    private static final Logger log = LoggerFactory.getLogger(V13WireOperations.class);

    public V13WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback, Object syncObject) {
        super(connection, defaultWarningMessageCallback, syncObject);
    }

    @Override
    public void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket, FbWireOperations.ProcessAttachCallback processAttachCallback) throws SQLException, IOException {
        assert (acceptPacket == null || acceptPacket.operation == 98) : "Unexpected operation in AcceptPacket";
        XdrInputStream xdrIn = this.getXdrIn();
        XdrOutputStream xdrOut = this.getXdrOut();
        ClientAuthBlock clientAuthBlock = this.getClientAuthBlock();
        while (true) {
            String pluginName;
            byte[] data;
            if (acceptPacket != null) {
                data = acceptPacket.p_acpt_data;
                pluginName = acceptPacket.p_acpt_plugin;
                this.addServerKeys(acceptPacket.p_acpt_keys);
                log.debug(String.format("authReceiveResponse: cond_accept data=%d pluginName=%d '%s'", data.length, pluginName != null ? Integer.valueOf(pluginName.length()) : null, pluginName));
                acceptPacket = null;
            } else {
                int operation = this.readNextOperation();
                switch (operation) {
                    case 90: {
                        xdrIn.readBuffer();
                        throw new FbExceptionBuilder().nonTransientConnectionException(337248272).toFlatSQLException();
                    }
                    case 92: {
                        data = xdrIn.readBuffer();
                        pluginName = xdrIn.readString(this.getEncoding());
                        xdrIn.readBuffer();
                        this.addServerKeys(xdrIn.readBuffer());
                        log.debug(String.format("authReceiveResponse: cont_auth data=%d pluginName=%d '%s'", data.length, pluginName.length(), pluginName));
                        break;
                    }
                    case 98: {
                        xdrIn.readInt();
                        xdrIn.readInt();
                        xdrIn.readInt();
                        data = xdrIn.readBuffer();
                        pluginName = xdrIn.readString(this.getEncoding());
                        xdrIn.readInt();
                        this.addServerKeys(xdrIn.readBuffer());
                        log.debug(String.format("authReceiveResponse: cond_accept data=%d pluginName=%d '%s'", data.length, pluginName.length(), pluginName));
                        break;
                    }
                    case 9: {
                        GenericResponse response = (GenericResponse)this.readOperationResponse(operation, null);
                        clientAuthBlock.setAuthComplete(true);
                        processAttachCallback.processAttachResponse(response);
                        return;
                    }
                    default: {
                        throw new SQLException(String.format("Unsupported operation code: %d", operation));
                    }
                }
            }
            if (pluginName != null && pluginName.length() > 0 && Objects.equals(pluginName, clientAuthBlock.getCurrentPluginName())) {
                pluginName = null;
            }
            if (pluginName != null && pluginName.length() > 0 && !clientAuthBlock.switchPlugin(pluginName) || !clientAuthBlock.hasPlugin()) break;
            clientAuthBlock.setServerData(data);
            log.debug(String.format("receiveResponse: authenticate(%s)", clientAuthBlock.getCurrentPluginName()));
            clientAuthBlock.authenticate();
            xdrOut.writeInt(92);
            xdrOut.writeBuffer(clientAuthBlock.getClientData());
            xdrOut.writeString(clientAuthBlock.getCurrentPluginName(), this.getEncoding());
            if (clientAuthBlock.isFirstTime()) {
                xdrOut.writeString(clientAuthBlock.getPluginNames(), this.getEncoding());
                clientAuthBlock.setFirstTime(false);
            } else {
                xdrOut.writeBuffer(null);
            }
            xdrOut.writeBuffer(null);
            xdrOut.flush();
        }
        throw new FbExceptionBuilder().exception(335544472).toFlatSQLException();
    }
}

