/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ParameterBufferHelper;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FBDriverPropertyManager {
    private static final Logger log = LoggerFactory.getLogger(FBDriverPropertyManager.class);
    private static final String RES = "driver_property_info";
    private static ResourceBundle info;
    private static final Map<String, PropertyInfo> aliases;
    private static final Map<String, PropertyInfo> dpbMap;

    FBDriverPropertyManager() {
    }

    public static Map<String, String> normalize(Properties props) throws SQLException {
        HashMap<String, String> tempProps = new HashMap<String, String>();
        for (String propertyName : props.stringPropertyNames()) {
            tempProps.put(propertyName, props.getProperty(propertyName));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : tempProps.entrySet()) {
            String propName = (String)entry.getKey();
            String propValue = (String)entry.getValue();
            PropertyInfo propInfo = aliases.get(propName);
            if (propInfo != null) {
                String originalName = propInfo.dpbName;
                String shortName = propInfo.dpbName.substring("isc_dpb_".length());
                boolean hasDuplicate = tempProps.keySet().contains(originalName) || tempProps.keySet().contains(shortName);
                hasDuplicate &= !propName.equals(shortName);
                if (hasDuplicate &= !propName.equals(originalName)) {
                    throw new FBSQLException("Specified properties contain reference to a DPB parameter under original and alias names: original name " + propInfo.dpbName + ", alias : " + propInfo.alias);
                }
            }
            if (propInfo == null) {
                String tempKey = propName;
                if (!tempKey.startsWith("isc_dpb_")) {
                    tempKey = "isc_dpb_" + tempKey;
                }
                propInfo = dpbMap.get(tempKey);
            }
            if (propInfo == null) continue;
            result.put(propInfo.dpbName, propValue);
        }
        FBDriverPropertyManager.handleEncodings(result);
        return result;
    }

    public static String getCanonicalName(String propertyName) {
        PropertyInfo propInfo = aliases.get(propertyName);
        if (propInfo == null) {
            String tempKey = propertyName;
            if (!tempKey.startsWith("isc_dpb_")) {
                tempKey = "isc_dpb_" + tempKey;
            }
            propInfo = dpbMap.get(tempKey);
        }
        if (propInfo == null) {
            return propertyName;
        }
        return propInfo.dpbName;
    }

    public static void handleEncodings(Map<String, String> info) throws SQLException {
        String localEncoding;
        String iscEncoding;
        IEncodingFactory encodingFactory = EncodingFactory.getPlatformDefault();
        EncodingDefinition encodingDefinition = encodingFactory.getEncodingDefinition(iscEncoding = info.get("isc_dpb_lc_ctype"), localEncoding = info.get("isc_dpb_local_encoding"));
        if (encodingDefinition != null) {
            if (!encodingDefinition.isInformationOnly()) {
                info.put("isc_dpb_local_encoding", encodingDefinition.getJavaEncodingName());
            }
            info.put("isc_dpb_lc_ctype", encodingDefinition.getFirebirdEncodingName());
        } else if (iscEncoding != null) {
            log.warn("No EncodingDefinition for " + iscEncoding + " / " + localEncoding + " specifying " + iscEncoding + " as connection encoding");
            info.put("isc_dpb_lc_ctype", iscEncoding);
        } else if (localEncoding != null) {
            log.warn("No EncodingDefinition for " + localEncoding + "; ignoring connection encoding");
        }
        String mappingPath = info.get("isc_dpb_mapping_path");
        if (encodingDefinition != null && mappingPath != null) {
            encodingDefinition.getEncoding().withTranslation(encodingFactory.getCharacterTranslator(mappingPath));
        }
    }

    public static DriverPropertyInfo[] getDriverPropertyInfo(Properties props) {
        ArrayList<DriverPropertyInfo> result = new ArrayList<DriverPropertyInfo>();
        for (String propName : props.stringPropertyNames()) {
            String propValue = props.getProperty(propName);
            PropertyInfo propInfo = aliases.get(propName);
            if (propInfo == null) {
                String tempKey = propName;
                if (!tempKey.startsWith("isc_dpb_")) {
                    tempKey = "isc_dpb_" + tempKey;
                }
                propInfo = dpbMap.get(tempKey);
            }
            DriverPropertyInfo driverPropInfo = new DriverPropertyInfo(propName, propValue != null ? propValue.toString() : "");
            if (propInfo != null) {
                driverPropInfo.description = propInfo.description;
            }
            result.add(driverPropInfo);
        }
        return result.toArray(new DriverPropertyInfo[0]);
    }

    static {
        try {
            info = ResourceBundle.getBundle(RES);
        }
        catch (MissingResourceException ex) {
            info = null;
        }
        HashMap<String, PropertyInfo> tempAliases = new HashMap<String, PropertyInfo>();
        HashMap<String, PropertyInfo> tempDpbMap = new HashMap<String, PropertyInfo>();
        if (info != null) {
            Enumeration<String> en = info.getKeys();
            while (en.hasMoreElements()) {
                Integer dpbKey;
                String dpbName;
                String key = en.nextElement();
                String value = info.getString(key);
                int hashIndex = value.indexOf(35);
                String description = "";
                if (hashIndex != -1) {
                    dpbName = value.substring(0, hashIndex).trim();
                    description = value.substring(hashIndex + 1).trim();
                } else {
                    dpbName = value.trim();
                }
                if (!dpbName.startsWith("isc_dpb_") || (dpbKey = ParameterBufferHelper.getDpbKey(dpbName)) == null) continue;
                PropertyInfo propInfo = new PropertyInfo(key, dpbName, dpbKey, description);
                tempAliases.put(propInfo.alias, propInfo);
                tempDpbMap.put(propInfo.dpbName, propInfo);
            }
        }
        for (Map.Entry<String, Integer> entry : ParameterBufferHelper.getDpbMap().entrySet()) {
            String dpbName = entry.getKey();
            Integer dpbKey = entry.getValue();
            if (!dpbName.startsWith("isc_dpb_") || tempDpbMap.containsKey(dpbName)) continue;
            PropertyInfo propInfo = new PropertyInfo(null, dpbName, dpbKey, "");
            tempDpbMap.put(dpbName, propInfo);
        }
        aliases = Collections.unmodifiableMap(tempAliases);
        dpbMap = Collections.unmodifiableMap(tempDpbMap);
    }

    private static class PropertyInfo {
        private final String alias;
        private final String dpbName;
        private final Integer dpbKey;
        private final String description;
        private final int hashCode;

        public PropertyInfo(String alias, String dpbName, Integer dpbKey, String description) {
            this.alias = alias;
            this.dpbName = dpbName;
            this.dpbKey = dpbKey;
            this.description = description;
            this.hashCode = Objects.hash(alias, dpbName, dpbKey);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PropertyInfo)) {
                return false;
            }
            PropertyInfo that = (PropertyInfo)obj;
            boolean result = Objects.equals(this.alias, that.alias);
            result &= this.dpbName.equals(that.dpbName);
            return result &= this.dpbKey.equals(that.dpbKey);
        }
    }
}

