/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.develnext.jphp.core.compiler.jvm.JPHPClassWriter;
import org.develnext.jphp.core.compiler.jvm.JvmCompiler;
import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.node.ClassNodeImpl;
import org.develnext.jphp.core.compiler.jvm.node.MethodNodeImpl;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.MethodStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.StmtCompiler;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.SelfExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassVarStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ConstStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import php.runtime.Memory;
import php.runtime.common.Function;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.FatalException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.invoke.cache.ClassCallCache;
import php.runtime.invoke.cache.ConstantCallCache;
import php.runtime.invoke.cache.FunctionCallCache;
import php.runtime.invoke.cache.MethodCallCache;
import php.runtime.invoke.cache.PropertyCallCache;
import php.runtime.lang.BaseObject;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.DocumentComment;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.PropertyEntity;
import php.runtime.reflection.helper.GeneratorEntity;

public class ClassStmtCompiler
extends StmtCompiler<ClassEntity> {
    protected JPHPClassWriter cw;
    public final ClassNode node;
    public final ClassStmtToken statement;
    public final List<TraceInfo> traceList = new ArrayList<TraceInfo>();
    public final List<Memory> memoryConstants = new ArrayList<Memory>();
    public final List<Collection<Memory>> memoryArrayConstants = new ArrayList<Collection<Memory>>();
    private boolean external = false;
    private boolean isSystem = false;
    private boolean isInterfaceCheck = true;
    private String functionName = "";
    private boolean initDynamicExists = false;
    private int callFuncCount = 0;
    private int callClassCount = 0;
    private int callMethCount = 0;
    private int callConstCount = 0;
    private int callPropCount = 0;
    private GeneratorEntity generatorEntity;
    protected List<ConstStmtToken.Item> dynamicConstants = new ArrayList<ConstStmtToken.Item>();
    protected List<ClassVarStmtToken> dynamicProperties = new ArrayList<ClassVarStmtToken>();
    private ClassStmtToken classContext;

    public ClassStmtCompiler(JvmCompiler compiler, ClassStmtToken statement) {
        super(compiler);
        this.statement = statement;
        this.node = new ClassNodeImpl();
    }

    public int getAndIncCallFuncCount() {
        return this.callFuncCount++;
    }

    public int getAndIncCallClassCount() {
        return this.callClassCount++;
    }

    public int getAndIncCallMethCount() {
        return this.callMethCount++;
    }

    public int getAndIncCallConstCount() {
        return this.callConstCount++;
    }

    public int getAndIncCallPropCount() {
        return this.callPropCount++;
    }

    public boolean isInitDynamicExists() {
        return this.initDynamicExists;
    }

    public boolean isClosure() {
        return this.functionName == null;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public GeneratorEntity getGeneratorEntity() {
        return this.generatorEntity;
    }

    public void setGeneratorEntity(GeneratorEntity generatorEntity) {
        this.generatorEntity = generatorEntity;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public void setSystem(boolean system) {
        this.isSystem = system;
    }

    public void setInterfaceCheck(boolean check) {
        this.isInterfaceCheck = check;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    TraceInfo makeTraceInfo(int line, int position) {
        return new TraceInfo(this.compiler.getContext(), line, 0, position, 0);
    }

    TraceInfo makeTraceInfo(Token token) {
        return token.toTraceInfo(this.compiler.getContext());
    }

    int addTraceInfo(int line, int position) {
        this.traceList.add(this.makeTraceInfo(line, position));
        return this.traceList.size() - 1;
    }

    int addTraceInfo(Token token) {
        this.traceList.add(this.makeTraceInfo(token));
        return this.traceList.size() - 1;
    }

    int addMemoryConstant(Memory memory) {
        this.memoryConstants.add(memory);
        return this.memoryConstants.size() - 1;
    }

    int addMemoryArray(Collection<Memory> memories) {
        this.memoryArrayConstants.add(memories);
        return this.memoryArrayConstants.size() - 1;
    }

    protected void writeDestructor() {
        if (((ClassEntity)this.entity).methodDestruct != null) {
            MethodNodeImpl destructor = new MethodNodeImpl();
            destructor.name = "finalize";
            destructor.access = 1;
            destructor.desc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[0]);
            MethodStmtCompiler methodCompiler = new MethodStmtCompiler(this, destructor);
            ExpressionStmtCompiler expressionCompiler = new ExpressionStmtCompiler(methodCompiler, null);
            methodCompiler.writeHeader();
            LabelNode end = new LabelNode();
            LabelNode l0 = this.writeLabel(destructor, this.statement.getMeta().getStartLine());
            methodCompiler.addLocalVariable("~this", l0);
            expressionCompiler.writeVarLoad("~this");
            expressionCompiler.writeSysDynamicCall(null, "isFinalized", Boolean.TYPE, new Class[0]);
            destructor.instructions.add((AbstractInsnNode)new JumpInsnNode(153, end));
            expressionCompiler.writeVarLoad("~this");
            expressionCompiler.writePushDup();
            expressionCompiler.writeSysDynamicCall(null, "doFinalize", Void.TYPE, new Class[0]);
            expressionCompiler.writePushEnvFromSelf();
            expressionCompiler.writePushConstNull();
            expressionCompiler.writeSysDynamicCall(null, ((ClassEntity)this.entity).methodDestruct.getInternalName(), Memory.class, Environment.class, Memory[].class);
            expressionCompiler.writePopAll(1);
            destructor.instructions.add((AbstractInsnNode)end);
            destructor.instructions.add((AbstractInsnNode)new InsnNode(177));
            methodCompiler.writeFooter();
            this.node.methods.add(destructor);
        }
    }

    protected void writeDefaultConstructors() {
        if (!(this.isSystem || this.isClosure() || ((ClassEntity)this.entity).getParent() == null || ((ClassEntity)this.entity).getParent().getNativeClass() == null || BaseObject.class.isAssignableFrom(((ClassEntity)this.entity).getParent().getNativeClass()))) {
            for (Constructor<?> el : ((ClassEntity)this.entity).getParent().getNativeClass().getConstructors()) {
                Class<?>[] parameterTypes = el.getParameterTypes();
                if (parameterTypes.length == 2 && parameterTypes[0] == Environment.class && parameterTypes[1] == ClassEntity.class) continue;
                MethodNodeImpl constructor = new MethodNodeImpl();
                constructor.name = "<init>";
                constructor.access = el.getModifiers();
                constructor.exceptions = new ArrayList();
                MethodStmtCompiler methodCompiler = new MethodStmtCompiler(this, constructor);
                ExpressionStmtCompiler expressionCompiler = new ExpressionStmtCompiler(methodCompiler, null);
                LabelNode l0 = this.writeLabel(constructor, this.statement.getMeta().getStartLine());
                methodCompiler.addLocalVariable("~this", l0);
                Type[] argumentTypes = new Type[parameterTypes.length];
                int i = 0;
                for (Class<?> type : parameterTypes) {
                    argumentTypes[i++] = Type.getType(type);
                    methodCompiler.addLocalVariable("arg" + i, l0, type);
                }
                constructor.desc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])argumentTypes);
                methodCompiler.writeHeader();
                expressionCompiler.writeVarLoad("~this");
                for (i = 0; i < argumentTypes.length; ++i) {
                    expressionCompiler.writeVarLoad("arg" + (i + 1));
                }
                constructor.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.node.superName, "<init>", constructor.desc, false));
                methodCompiler.writeFooter();
                constructor.instructions.add((AbstractInsnNode)new InsnNode(177));
                this.node.methods.add(constructor);
            }
        }
    }

    protected void writeConstructor() {
        MethodNodeImpl constructor = new MethodNodeImpl();
        constructor.name = "<init>";
        constructor.access = 1;
        constructor.exceptions = new ArrayList();
        MethodStmtCompiler methodCompiler = new MethodStmtCompiler(this, constructor);
        ExpressionStmtCompiler expressionCompiler = new ExpressionStmtCompiler(methodCompiler, null);
        methodCompiler.writeHeader();
        LabelNode l0 = this.writeLabel(constructor, this.statement.getMeta().getStartLine());
        methodCompiler.addLocalVariable("~this", l0);
        if (this.isClosure() || this.generatorEntity != null) {
            constructor.desc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Environment.class), Type.getType(ClassEntity.class), Type.getType(Memory.class), Type.getType(Memory[].class)});
            if (this.isClosure()) {
                constructor.desc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Environment.class), Type.getType(ClassEntity.class), Type.getType(Memory.class), Type.getType(String.class), Type.getType(Memory[].class)});
            }
            methodCompiler.addLocalVariable("~env", l0, Environment.class);
            methodCompiler.addLocalVariable("~class", l0, ClassEntity.class);
            methodCompiler.addLocalVariable("~self", l0, Memory.class);
            if (this.isClosure()) {
                methodCompiler.addLocalVariable("~context", l0, String.class);
            }
            methodCompiler.addLocalVariable("~uses", l0, Memory[].class);
            methodCompiler.writeHeader();
            expressionCompiler.writeVarLoad("~this");
            expressionCompiler.writeVarLoad("~env");
            expressionCompiler.writeVarLoad("~class");
            expressionCompiler.writeVarLoad("~self");
            if (this.isClosure()) {
                expressionCompiler.writeVarLoad("~context");
            }
            expressionCompiler.writeVarLoad("~uses");
            constructor.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.node.superName, "<init>", constructor.desc, false));
        } else {
            constructor.desc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Environment.class), Type.getType(ClassEntity.class)});
            methodCompiler.addLocalVariable("~env", l0, Environment.class);
            methodCompiler.addLocalVariable("~class", l0, String.class);
            expressionCompiler.writeVarLoad("~this");
            expressionCompiler.writeVarLoad("~env");
            expressionCompiler.writeVarLoad("~class");
            constructor.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.node.superName, "<init>", constructor.desc, false));
            for (ClassVarStmtToken property : this.statement.getProperties()) {
                ExpressionStmtCompiler expressionStmtCompiler = new ExpressionStmtCompiler(methodCompiler, null);
                Memory value = Memory.NULL;
                if (property.getValue() != null) {
                    value = expressionStmtCompiler.writeExpression(property.getValue(), true, true, false);
                }
                PropertyEntity prop = new PropertyEntity(this.compiler.getContext());
                prop.setName(property.getVariable().getName());
                prop.setModifier(property.getModifier());
                prop.setStatic(property.isStatic());
                prop.setDefaultValue(value);
                prop.setDefault(property.getValue() != null);
                prop.setTrace(property.toTraceInfo(this.compiler.getContext()));
                if (property.getDocComment() != null) {
                    prop.setDocComment(new DocumentComment(property.getDocComment().getComment()));
                }
                ClassEntity.PropertyResult result = ((ClassEntity)this.entity).addProperty(prop);
                result.check(this.compiler.getEnvironment());
                if (value != null || property.getValue() == null) continue;
                if (property.getValue().isSingle() && ValueExprToken.isConstable(property.getValue().getSingle(), true)) {
                    this.dynamicProperties.add(property);
                    continue;
                }
                this.compiler.getEnvironment().error(property.getVariable().toTraceInfo(this.compiler.getContext()), ErrorType.E_COMPILE_ERROR, Messages.ERR_EXPECTED_CONST_VALUE.fetch(new Object[]{((ClassEntity)this.entity).getName() + "::$" + property.getVariable().getName()}), new Object[0]);
            }
        }
        methodCompiler.writeFooter();
        constructor.instructions.add((AbstractInsnNode)new InsnNode(177));
        this.node.methods.add(constructor);
    }

    protected void writeConstant(ConstStmtToken constant) {
        MethodStmtCompiler methodStmtCompiler = new MethodStmtCompiler(this, (MethodStmtToken)null);
        ExpressionStmtCompiler expressionStmtCompiler = new ExpressionStmtCompiler(methodStmtCompiler, null);
        DocumentComment documentComment = null;
        if (constant.getDocComment() != null) {
            documentComment = new DocumentComment(constant.getDocComment().getComment());
        }
        for (ConstStmtToken.Item el : constant.items) {
            Memory value = expressionStmtCompiler.writeExpression(el.value, true, true, false);
            ConstantEntity constantEntity = new ConstantEntity(el.getFulledName(), value, true);
            constantEntity.setTrace(el.name.toTraceInfo(this.compiler.getContext()));
            constantEntity.setDocComment(documentComment);
            constantEntity.setModifier(constant.getModifier());
            if (value != null && !value.isArray()) {
                ConstantEntity c = ((ClassEntity)this.entity).findConstant(el.getFulledName());
                if (c != null && c.getClazz().getId() == ((ClassEntity)this.entity).getId()) {
                    this.compiler.getEnvironment().error(constant.toTraceInfo(this.compiler.getContext()), ErrorType.E_ERROR, Messages.ERR_CANNOT_REDEFINE_CLASS_CONSTANT, new Object[]{((ClassEntity)this.entity).getName() + "::" + el.getFulledName()});
                    return;
                }
                ((ClassEntity)this.entity).addConstant(constantEntity).check(this.compiler.getEnvironment());
                continue;
            }
            if (ValueExprToken.isConstable(el.value.getSingle(), false)) {
                this.dynamicConstants.add(el);
                ((ClassEntity)this.entity).addConstant(constantEntity).check(this.compiler.getEnvironment());
                continue;
            }
            this.compiler.getEnvironment().error(constant.toTraceInfo(this.compiler.getContext()), Messages.ERR_EXPECTED_CONST_VALUE.fetch(new Object[]{((ClassEntity)this.entity).getName() + "::" + el.getFulledName()}), new Object[0]);
        }
    }

    protected void writeSystemInfo() {
        this.node.fields.add(new FieldNode(25, "$FN", Type.getDescriptor(String.class), null, (Object)this.compiler.getSourceFile()));
        this.node.fields.add(new FieldNode(9, "$TRC", Type.getDescriptor(TraceInfo[].class), null, null));
        this.node.fields.add(new FieldNode(9, "$MEM", Type.getDescriptor(Memory[].class), null, null));
        this.node.fields.add(new FieldNode(9, "$AMEM", Type.getDescriptor(Memory[][].class), null, null));
        this.node.fields.add(new FieldNode(9, "$CALL_FUNC_CACHE", Type.getDescriptor(FunctionCallCache.class), null, null));
        this.node.fields.add(new FieldNode(9, "$CALL_METH_CACHE", Type.getDescriptor(MethodCallCache.class), null, null));
        this.node.fields.add(new FieldNode(9, "$CALL_PROP_CACHE", Type.getDescriptor(PropertyCallCache.class), null, null));
        this.node.fields.add(new FieldNode(9, "$CALL_CONST_CACHE", Type.getDescriptor(ConstantCallCache.class), null, null));
        this.node.fields.add(new FieldNode(9, "$CALL_CLASS_CACHE", Type.getDescriptor(ClassCallCache.class), null, null));
        if (this.functionName != null) {
            this.node.fields.add(new FieldNode(25, "$CL", Type.getDescriptor(String.class), null, (Object)(!this.functionName.isEmpty() ? this.functionName : ((ClassEntity)this.entity).getName())));
        }
    }

    protected void writeInitEnvironment() {
        if (!this.dynamicConstants.isEmpty() || !this.dynamicProperties.isEmpty()) {
            this.initDynamicExists = true;
            MethodNodeImpl node = new MethodNodeImpl();
            node.access = 9;
            node.name = "__$initEnvironment";
            node.desc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Environment.class)});
            if (((ClassEntity)this.entity).isTrait()) {
                node.desc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Environment.class), Type.getType(String.class)});
            }
            MethodStmtCompiler methodCompiler = new MethodStmtCompiler(this, node);
            ExpressionStmtCompiler expressionCompiler = new ExpressionStmtCompiler(methodCompiler, null);
            methodCompiler.writeHeader();
            LabelNode l0 = expressionCompiler.makeLabel();
            methodCompiler.addLocalVariable("~env", l0, Environment.class);
            if (((ClassEntity)this.entity).isTrait()) {
                methodCompiler.addLocalVariable("~class_name", l0, String.class);
            }
            LocalVariable l_class = methodCompiler.addLocalVariable("~class", l0, ClassEntity.class);
            expressionCompiler.writePushEnv();
            if (((ClassEntity)this.entity).isTrait()) {
                expressionCompiler.writeVarLoad("~class_name");
                expressionCompiler.writePushDupLowerCase();
            } else {
                expressionCompiler.writePushConstString(((ClassEntity)this.entity).getName());
                expressionCompiler.writePushConstString(((ClassEntity)this.entity).getLowerName());
            }
            expressionCompiler.writePushConstBoolean(true);
            expressionCompiler.writeSysDynamicCall(Environment.class, "fetchClass", ClassEntity.class, String.class, String.class, Boolean.TYPE);
            expressionCompiler.writeVarStore(l_class, false, false);
            ArrayList<ConstStmtToken.Item> first = new ArrayList<ConstStmtToken.Item>();
            HashSet<String> usedNames = new HashSet<String>();
            ArrayList<ConstStmtToken.Item> other = new ArrayList<ConstStmtToken.Item>();
            for (ConstStmtToken.Item item : this.dynamicConstants) {
                Token tk = item.value.getSingle();
                if (tk instanceof StaticAccessExprToken) {
                    StaticAccessExprToken access = (StaticAccessExprToken)tk;
                    boolean self = false;
                    if (access.getClazz() instanceof SelfExprToken) {
                        self = true;
                    } else if (access.getClazz() instanceof FulledNameToken && ((FulledNameToken)access.getClazz()).getName().equalsIgnoreCase(((ClassEntity)this.entity).getName())) {
                        self = true;
                    }
                    if (self) {
                        String name = ((NameToken)access.getField()).getName();
                        if (usedNames.contains(item.getFulledName())) {
                            first.add(0, item);
                        } else {
                            first.add(item);
                        }
                        usedNames.add(name);
                        continue;
                    }
                }
                if (usedNames.contains(item.getFulledName())) {
                    first.add(0, item);
                    continue;
                }
                other.add(item);
            }
            other.addAll(0, first);
            for (ConstStmtToken.Item item : other) {
                expressionCompiler.writeVarLoad(l_class);
                expressionCompiler.writePushEnv();
                expressionCompiler.writePushConstString(item.getFulledName());
                expressionCompiler.writeExpression(item.value, true, false, true);
                expressionCompiler.writePopBoxing(true);
                expressionCompiler.writeSysDynamicCall(ClassEntity.class, "addDynamicConstant", Void.TYPE, Environment.class, String.class, Memory.class);
            }
            for (ClassVarStmtToken classVarStmtToken : this.dynamicProperties) {
                expressionCompiler.writeVarLoad(l_class);
                expressionCompiler.writePushEnv();
                expressionCompiler.writePushConstString(classVarStmtToken.getVariable().getName());
                expressionCompiler.writeExpression(classVarStmtToken.getValue(), true, false, true);
                expressionCompiler.writePopBoxing(true);
                expressionCompiler.writeSysDynamicCall(ClassEntity.class, classVarStmtToken.isStatic() ? "addDynamicStaticProperty" : "addDynamicProperty", Void.TYPE, Environment.class, String.class, Memory.class);
            }
            node.instructions.add((AbstractInsnNode)new InsnNode(177));
            methodCompiler.writeFooter();
            this.node.methods.add(node);
        }
    }

    protected void writeInitStatic() {
        MethodNodeImpl node = new MethodNodeImpl();
        node.access = 8;
        node.name = "<clinit>";
        node.desc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[0]);
        MethodStmtCompiler methodCompiler = new MethodStmtCompiler(this, node);
        ExpressionStmtCompiler expressionCompiler = new ExpressionStmtCompiler(methodCompiler, null);
        methodCompiler.writeHeader();
        expressionCompiler.writePushSmallInt(this.traceList.size());
        node.instructions.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(TraceInfo.class)));
        expressionCompiler.stackPush(Memory.Type.REFERENCE);
        int i = 0;
        for (TraceInfo traceInfo : this.traceList) {
            expressionCompiler.writePushDup();
            expressionCompiler.writePushSmallInt(i);
            expressionCompiler.writePushCreateTraceInfo(traceInfo.getStartLine(), traceInfo.getStartPosition());
            node.instructions.add((AbstractInsnNode)new InsnNode(83));
            expressionCompiler.stackPop();
            expressionCompiler.stackPop();
            ++i;
        }
        expressionCompiler.writePutStatic("$TRC", TraceInfo[].class);
        expressionCompiler.writePushSmallInt(this.memoryConstants.size());
        node.instructions.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Memory.class)));
        expressionCompiler.stackPush(Memory.Type.REFERENCE);
        i = 0;
        for (Memory memory : this.memoryConstants) {
            expressionCompiler.writePushDup();
            expressionCompiler.writePushSmallInt(i);
            expressionCompiler.writePushMemory(memory);
            expressionCompiler.writePopBoxing(true, false);
            node.instructions.add((AbstractInsnNode)new InsnNode(83));
            expressionCompiler.stackPop();
            expressionCompiler.stackPop();
            ++i;
        }
        expressionCompiler.writePutStatic("$MEM", Memory[].class);
        expressionCompiler.writePushSmallInt(this.memoryArrayConstants.size());
        node.instructions.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Memory[].class)));
        expressionCompiler.stackPush(Memory.Type.REFERENCE);
        i = 0;
        for (Collection collection : this.memoryArrayConstants) {
            expressionCompiler.writePushDup();
            expressionCompiler.writePushSmallInt(i);
            expressionCompiler.writePushParameters(collection);
            node.instructions.add((AbstractInsnNode)new InsnNode(83));
            expressionCompiler.stackPop();
            expressionCompiler.stackPop();
            ++i;
        }
        expressionCompiler.writePutStatic("$AMEM", Memory[][].class);
        expressionCompiler.writePushNewObject(FunctionCallCache.class);
        expressionCompiler.writePutStatic("$CALL_FUNC_CACHE", FunctionCallCache.class);
        expressionCompiler.writePushNewObject(MethodCallCache.class);
        expressionCompiler.writePutStatic("$CALL_METH_CACHE", MethodCallCache.class);
        expressionCompiler.writePushNewObject(ConstantCallCache.class);
        expressionCompiler.writePutStatic("$CALL_CONST_CACHE", ConstantCallCache.class);
        expressionCompiler.writePushNewObject(PropertyCallCache.class);
        expressionCompiler.writePutStatic("$CALL_PROP_CACHE", PropertyCallCache.class);
        expressionCompiler.writePushNewObject(ClassCallCache.class);
        expressionCompiler.writePutStatic("$CALL_CLASS_CACHE", ClassCallCache.class);
        node.instructions.add((AbstractInsnNode)new InsnNode(177));
        methodCompiler.writeFooter();
        this.node.methods.add(node);
    }

    protected void writeInterfaceMethod(MethodEntity method) {
        MethodNodeImpl node = new MethodNodeImpl();
        node.access = 1;
        node.name = method.getName();
        node.desc = Type.getMethodDescriptor((Type)Type.getType(Memory.class), (Type[])new Type[]{Type.getType(Environment.class), Type.getType(Memory[].class)});
        MethodStmtCompiler methodCompiler = new MethodStmtCompiler(this, node);
        ExpressionStmtCompiler expressionCompiler = new ExpressionStmtCompiler(methodCompiler, null);
        methodCompiler.writeHeader();
        LabelNode l0 = this.writeLabel(node, this.statement.getMeta().getStartLine());
        methodCompiler.addLocalVariable("~this", l0);
        methodCompiler.addLocalVariable("~env", l0);
        methodCompiler.addLocalVariable("~args", l0);
        expressionCompiler.writeVarLoad("~this");
        expressionCompiler.writeVarLoad("~env");
        expressionCompiler.writeVarLoad("~args");
        String internalName = ((ClassEntity)this.entity).findMethod(method.getLowerName()).getInternalName();
        expressionCompiler.writeSysDynamicCall(null, internalName, Memory.class, Environment.class, Memory[].class);
        node.instructions.add((AbstractInsnNode)new InsnNode(176));
        methodCompiler.writeFooter();
        this.node.methods.add(node);
    }

    protected void writeInterfaceMethods(Collection<MethodEntity> methods) {
        for (MethodEntity method : methods) {
            this.writeInterfaceMethod(method);
        }
    }

    protected Set<ClassEntity> writeInterfaces(ClassEntity _interface) {
        HashSet<ClassEntity> result = new HashSet<ClassEntity>();
        this.writeInterfaces(_interface, result);
        return result;
    }

    protected void writeInterfaces(ClassEntity _interface, Set<ClassEntity> used) {
        if (used.add(_interface)) {
            if (_interface != null && _interface.isInternal()) {
                this.node.interfaces.add(_interface.getInternalName());
            }
            if (_interface != null) {
                for (ClassEntity el : _interface.getInterfaces().values()) {
                    if (_interface.isInternal() && el.isInternal()) continue;
                    this.writeInterfaces(el, used);
                }
            }
        }
    }

    protected ClassEntity fetchClass(String name) {
        ClassEntity result = this.compiler.getModule().findClass(name);
        if (result == null) {
            result = this.getCompiler().getEnvironment().fetchClass(name, true);
        }
        return result;
    }

    protected ClassEntity fetchClassAndCheck(String name) {
        ClassEntity r = this.fetchClass(name);
        if (r == null) {
            this.compiler.getEnvironment().error(((ClassEntity)this.entity).getTrace(), Messages.ERR_CLASS_NOT_FOUND.fetch(new Object[]{name}), new Object[0]);
        }
        return r;
    }

    protected void writeImplements() {
        if (this.statement.getImplement() != null) {
            Environment env = this.compiler.getEnvironment();
            for (FulledNameToken name : this.statement.getImplement()) {
                ClassEntity implement = this.fetchClass(name.getName());
                Set<Object> needWriteInterfaceMethods = new HashSet();
                if (implement == null) {
                    env.error(name.toTraceInfo(this.compiler.getContext()), Messages.ERR_INTERFACE_NOT_FOUND.fetch(new Object[]{name.toName()}), new Object[0]);
                } else {
                    if (implement.getType() != ClassEntity.Type.INTERFACE) {
                        env.error(name.toTraceInfo(this.compiler.getContext()), Messages.ERR_CANNOT_IMPLEMENT.fetch(new Object[]{((ClassEntity)this.entity).getName(), implement.getName()}), new Object[0]);
                    }
                    if (!this.statement.isInterface()) {
                        needWriteInterfaceMethods = this.writeInterfaces(implement);
                    }
                }
                ClassEntity.ImplementsResult addResult = ((ClassEntity)this.entity).addInterface(implement);
                addResult.check(env);
                for (ClassEntity classEntity : needWriteInterfaceMethods) {
                    if (!classEntity.isInternal()) continue;
                    this.writeInterfaceMethods(classEntity.getMethods().values());
                }
            }
        }
    }

    protected void writeCopiedMethod(ClassStmtToken.Alias alias, String methodName, ClassEntity trait) {
        MethodEntity origin;
        final MethodEntity methodEntity = this.fetchClassAndCheck(alias.getTrait()).findMethod(methodName.toLowerCase());
        String name = alias.getName();
        if (name == null) {
            name = methodName;
        }
        if ((origin = ((ClassEntity)this.entity).findMethod(name.toLowerCase())) != null && origin.getClazz() == this.entity) {
            if (origin.getTrait() != null) {
                this.compiler.getEnvironment().error(((ClassEntity)this.entity).getTrace(), Messages.ERR_TRAIT_METHOD_COLLISION.fetch(new Object[]{methodName, trait.getName(), origin.getTrait().getName(), ((ClassEntity)this.entity).getName()}), new Object[0]);
            }
            return;
        }
        if (methodEntity == null) {
            this.compiler.getEnvironment().error(((ClassEntity)this.entity).getTrace(), Messages.ERR_METHOD_NOT_FOUND.fetch(new Object[]{alias.getTrait(), methodName}), new Object[0]);
            return;
        }
        MethodEntity dup = methodEntity.duplicateForInject();
        dup.setClazz((ClassEntity)this.entity);
        dup.setTrait(trait);
        if (alias.getName() != null) {
            dup.setName(alias.getName());
        }
        if (alias.getModifier() != null) {
            dup.setModifier(alias.getModifier());
        }
        MethodNodeImpl methodNode = MethodNodeImpl.duplicate((MethodNode)methodEntity.getAdditionalData("methodNode", MethodNode.class, (Function)new Function<MethodNode>(){

            public MethodNode call() {
                ClassNode classNode = (ClassNode)methodEntity.getClazz().getAdditionalData("classNode", ClassNode.class, (Function)new Function<ClassNode>(){

                    public ClassNode call() {
                        ClassReader classReader;
                        if (methodEntity.getClazz().getData() != null) {
                            classReader = new ClassReader(methodEntity.getClazz().getData());
                        } else {
                            try {
                                classReader = new ClassReader(methodEntity.getClazz().getName());
                            }
                            catch (IOException e) {
                                throw new CriticalException((Throwable)e);
                            }
                        }
                        ClassNode classNode = new ClassNode();
                        classReader.accept((ClassVisitor)classNode, 0);
                        return classNode;
                    }
                });
                for (Object m : classNode.methods) {
                    MethodNode method = (MethodNode)m;
                    if (!method.name.equals(methodEntity.getInternalName())) continue;
                    return method;
                }
                throw new CriticalException("Cannot find MethodNode for method - " + methodEntity.getName() + "(" + methodEntity.getSignatureString(true) + ")");
            }
        }));
        if (origin != null) {
            dup.setPrototype(origin);
        }
        dup.setInternalName(dup.getName() + "$" + ((ClassEntity)this.entity).nextMethodIndex());
        methodNode.name = dup.getInternalName();
        ClassEntity.SignatureResult result = ((ClassEntity)this.entity).addMethod(dup, null);
        result.check(this.compiler.getEnvironment());
        this.node.methods.add(methodNode);
    }

    protected void writeCopiedMethod(MethodEntity methodEntity, ClassEntity trait) {
        ClassStmtToken.Replacement replacement = this.statement.findReplacement(methodEntity.getName());
        if (replacement != null && replacement.hasTrait(trait.getName())) {
            return;
        }
        List<ClassStmtToken.Alias> aliases = this.statement.findAliases(methodEntity.getName());
        if (aliases == null) {
            aliases = Arrays.asList(new ClassStmtToken.Alias(trait.getName(), null, methodEntity.getName()));
        } else {
            boolean replaceExists = false;
            boolean replaceAlias = false;
            for (ClassStmtToken.Alias alias : aliases) {
                if (replacement != null && alias.getTrait().equalsIgnoreCase(replacement.getOrigin())) {
                    replaceExists = true;
                    break;
                }
                if (alias.getModifier() != null && alias.getModifier() != methodEntity.getModifier() && alias.getName() != null) continue;
                replaceAlias = true;
            }
            if (replacement != null && !replaceExists) {
                aliases.add(new ClassStmtToken.Alias(replacement.getOrigin(), null, methodEntity.getName()));
            }
            if (!replaceAlias) {
                aliases.add(new ClassStmtToken.Alias(trait.getName(), null, methodEntity.getName()));
            }
        }
        for (ClassStmtToken.Alias alias : aliases) {
            this.writeCopiedMethod(alias, methodEntity.getName(), trait);
        }
    }

    protected void writeTraitProperties(ClassEntity trait, Collection<PropertyEntity> props) {
        for (PropertyEntity el : props) {
            PropertyEntity origin = (PropertyEntity)((ClassEntity)this.entity).properties.get(el.getLowerName());
            if (origin != null) {
                boolean isSkip;
                boolean bl = isSkip = origin.getTrait() == null && !origin.getClazz().equals((Object)this.entity) && origin.isPrivate();
                if (origin.getTrait() != null && origin.getTrait().equals((Object)trait)) {
                    isSkip = true;
                }
                if (!isSkip) {
                    boolean isFatal;
                    Environment env = this.compiler.getEnvironment();
                    String ownerName = origin.getClazz().getName();
                    if (origin.getTrait() != null) {
                        ownerName = origin.getTrait().getName();
                    }
                    boolean bl2 = isFatal = origin.getModifier() != el.getModifier();
                    if (origin.getDefaultValue() != null && el.getDefaultValue() == null) {
                        isFatal = true;
                    } else if (origin.getDefaultValue() == null && el.getDefaultValue() != null) {
                        isFatal = true;
                    } else if (origin.getDefaultValue() != null && !origin.getDefaultValue().identical(el.getDefaultValue())) {
                        isFatal = true;
                    }
                    if (isFatal) {
                        env.error(((ClassEntity)this.entity).getTrace(), Messages.ERR_TRAIT_SAME_PROPERTY.fetch(new Object[]{ownerName, trait.getName(), el.getName(), ((ClassEntity)this.entity).getName()}), new Object[0]);
                    } else {
                        env.error(((ClassEntity)this.entity).getTrace(), ErrorType.E_STRICT, Messages.ERR_TRAIT_SAME_PROPERTY_STRICT.fetch(new Object[]{ownerName, trait.getName(), el.getName(), ((ClassEntity)this.entity).getName()}), new Object[0]);
                    }
                }
            }
            if (origin != null && origin.getClazz().getId() == ((ClassEntity)this.entity).getId()) continue;
            PropertyEntity p = el.duplicate();
            p.setClazz((ClassEntity)this.entity);
            p.setTrait(trait);
            ClassEntity.PropertyResult r = ((ClassEntity)this.entity).addProperty(p);
            r.check(this.compiler.getEnvironment());
        }
    }

    protected void writeTraitProperties(ClassEntity trait) {
        this.writeTraitProperties(trait, trait.getProperties());
        this.writeTraitProperties(trait, trait.getStaticProperties());
    }

    protected void writeTrait(ClassEntity trait) {
        ((ClassEntity)this.entity).addTrait(trait);
        this.initDynamicExists = true;
        this.writeTraitProperties(trait);
        for (MethodEntity methodEntity : trait.getMethods().values()) {
            this.writeCopiedMethod(methodEntity, trait);
        }
    }

    protected void checkRequiredTrait(String trait) {
        if (!((ClassEntity)this.entity).hasTrait(trait.toLowerCase())) {
            this.compiler.getEnvironment().error(((ClassEntity)this.entity).getTrace(), Messages.ERR_TRAIT_WAS_NOT_ADDED.fetch(new Object[]{trait, ((ClassEntity)this.entity).getName()}), new Object[0]);
        }
    }

    protected void checkAliasAndReplacementsTraits() {
        if (this.statement.getAliases() != null) {
            for (List<ClassStmtToken.Alias> aliases : this.statement.getAliases().values()) {
                for (ClassStmtToken.Alias alias : aliases) {
                    this.checkRequiredTrait(alias.getTrait());
                }
            }
        }
        if (this.statement.getReplacements() != null) {
            for (ClassStmtToken.Replacement replacement : this.statement.getReplacements().values()) {
                this.checkRequiredTrait(replacement.getOrigin());
                for (String e : replacement.getTraits()) {
                    this.checkRequiredTrait(e);
                }
            }
        }
    }

    protected List<ClassEntity> fetchTraits() {
        ArrayList<ClassEntity> r = new ArrayList<ClassEntity>();
        for (NameToken one : this.statement.getUses()) {
            ClassEntity trait = this.fetchClass(one.getName());
            if (trait == null) {
                this.compiler.getEnvironment().error(one.toTraceInfo(this.compiler.getContext()), Messages.ERR_TRAIT_NOT_FOUND.fetch(new Object[]{one.getName()}), new Object[0]);
                return null;
            }
            if (!trait.isTrait()) {
                this.compiler.getEnvironment().error(one.toTraceInfo(this.compiler.getContext()), Messages.ERR_CANNOT_USE_NON_TRAIT.fetch(new Object[]{((ClassEntity)this.entity).getName(), one.getName()}), new Object[0]);
                continue;
            }
            r.add(trait);
        }
        return r;
    }

    protected void writeTraits(Collection<ClassEntity> traits) {
        for (ClassEntity trait : traits) {
            this.writeTrait(trait);
        }
    }

    @Override
    public ClassEntity compile() {
        this.entity = new ClassEntity(this.compiler.getContext());
        ((ClassEntity)this.entity).setId(this.compiler.getScope().nextClassIndex());
        ((ClassEntity)this.entity).setFinal(this.statement.isFinal());
        ((ClassEntity)this.entity).setAbstract(this.statement.isAbstract());
        ((ClassEntity)this.entity).setName(this.statement.getFulledName());
        if (this.statement.getDocComment() != null) {
            ((ClassEntity)this.entity).setDocComment(new DocumentComment(this.statement.getDocComment().getComment()));
        }
        ((ClassEntity)this.entity).setTrace(this.statement.toTraceInfo(this.compiler.getContext()));
        ((ClassEntity)this.entity).setType(this.statement.getClassType());
        List<ClassEntity> traits = this.fetchTraits();
        for (ClassEntity e : traits) {
            ((ClassEntity)this.entity).addTrait(e);
        }
        this.checkAliasAndReplacementsTraits();
        if (this.statement.getExtend() != null) {
            ClassEntity parent = this.fetchClass(this.statement.getExtend().getName().getName());
            if (parent == null) {
                this.compiler.getEnvironment().error(this.statement.getExtend().toTraceInfo(this.compiler.getContext()), Messages.ERR_CLASS_NOT_FOUND.fetch(new Object[]{this.statement.getExtend().getName().toName()}), new Object[0]);
            }
            ClassEntity.ExtendsResult result = ((ClassEntity)this.entity).setParent(parent, false);
            if (this.isInterfaceCheck) {
                result.check(this.compiler.getEnvironment());
            }
        }
        if (!this.isSystem) {
            if (((ClassEntity)this.entity).isUseJavaLikeNames()) {
                ((ClassEntity)this.entity).setInternalName(((ClassEntity)this.entity).getName().replace('\\', '/'));
            } else {
                ((ClassEntity)this.entity).setInternalName(this.compiler.getModule().getInternalName() + "_class" + this.compiler.getModule().getClasses().size());
            }
        }
        if (this.compiler.getModule().findClass(((ClassEntity)this.entity).getLowerName()) != null || this.compiler.getEnvironment().isLoadedClass(((ClassEntity)this.entity).getLowerName())) {
            throw new FatalException(Messages.ERR_CANNOT_REDECLARE_CLASS.fetch(new Object[]{((ClassEntity)this.entity).getName()}), this.statement.getName().toTraceInfo(this.compiler.getContext()));
        }
        if (!this.statement.isInterface()) {
            this.node.access = 33;
            this.node.name = !this.isSystem ? ((ClassEntity)this.entity).getCompiledInternalName() : this.statement.getFulledName('_');
            this.node.superName = ((ClassEntity)this.entity).getParent() == null ? Type.getInternalName(BaseObject.class) : ((ClassEntity)this.entity).getParent().getInternalName();
            this.node.sourceFile = this.compiler.getSourceFile();
            this.writeSystemInfo();
            this.writeConstructor();
            this.writeDefaultConstructors();
        }
        if (this.statement.getConstants() != null) {
            for (ConstStmtToken constant : this.statement.getConstants()) {
                this.writeConstant(constant);
            }
        }
        if (this.statement.getMethods() != null) {
            for (MethodStmtToken method : this.statement.getMethods()) {
                ClassEntity.SignatureResult result = ((ClassEntity)this.entity).addMethod(this.compiler.compileMethod(this, method, this.external, this.generatorEntity), null);
                result.check(this.compiler.getEnvironment());
            }
        }
        this.writeTraits(traits);
        ClassEntity.SignatureResult result = ((ClassEntity)this.entity).updateParentBody();
        if (this.isInterfaceCheck) {
            result.check(this.compiler.getEnvironment());
        }
        this.writeImplements();
        ((ClassEntity)this.entity).doneDeclare();
        if (!this.statement.isInterface()) {
            this.writeDestructor();
            if (((ClassEntity)this.entity).getType() != ClassEntity.Type.INTERFACE) {
                this.writeInitEnvironment();
            }
            this.writeInitStatic();
            this.cw = new JPHPClassWriter(((ClassEntity)this.entity).isTrait());
            this.node.accept((ClassVisitor)this.cw);
            ((ClassEntity)this.entity).setData(this.cw.toByteArray());
        }
        return (ClassEntity)this.entity;
    }

    public void setClassContext(ClassStmtToken classContext) {
        this.classContext = classContext;
    }

    public ClassStmtToken getClassContext() {
        return this.classContext;
    }
}

