/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr;

import java.util.List;
import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.MethodStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseStatementCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.CatchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TryStmtToken;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.lang.BaseException;
import php.runtime.lang.exception.BaseBaseException;

public class TryCatchCompiler
extends BaseStatementCompiler<TryStmtToken> {
    public TryCatchCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(TryStmtToken token) {
        if (token.getBody() == null || token.getBody().getInstructions().isEmpty()) {
            if (token.getFinally() != null) {
                this.expr.write(BodyStmtToken.class, token.getFinally());
            }
            return;
        }
        this.expr.writeDefineVariables(token.getLocal());
        LabelNode tryStart = this.expr.writeLabel(this.node, token.getMeta().getStartLine());
        LabelNode tryEnd = new LabelNode();
        LabelNode catchStart = new LabelNode();
        LabelNode catchEnd = new LabelNode();
        LabelNode returnLabel = new LabelNode();
        this.method.node.tryCatchBlocks.add(0, new TryCatchBlockNode(tryStart, tryEnd, catchStart, Type.getInternalName(BaseBaseException.class)));
        if (token.getFinally() != null) {
            this.method.getTryStack().push(new MethodStmtCompiler.TryCatchItem(token, returnLabel));
        }
        this.expr.write(BodyStmtToken.class, token.getBody());
        if (token.getFinally() != null) {
            this.method.getTryStack().pop();
        }
        this.add((AbstractInsnNode)tryEnd);
        this.add((AbstractInsnNode)new JumpInsnNode(167, catchEnd));
        this.add((AbstractInsnNode)catchStart);
        LocalVariable exception = this.method.addLocalVariable("~catch~" + this.method.nextStatementIndex(BaseException.class), catchStart, BaseBaseException.class);
        exception.setEndLabel(catchEnd);
        this.expr.makeVarStore(exception);
        LabelNode nextCatch = null;
        int i = 0;
        int size = token.getCatches().size();
        LocalVariable local = null;
        LabelNode catchFail = new LabelNode();
        for (CatchStmtToken _catch : token.getCatches()) {
            if (nextCatch != null) {
                this.add((AbstractInsnNode)nextCatch);
            }
            nextCatch = i == size - 1 ? catchFail : new LabelNode();
            local = this.method.getLocalVariable(_catch.getVariable().getName());
            List<FulledNameToken> catchExceptions = _catch.getExceptions();
            LabelNode bodyLabel = new LabelNode();
            LabelNode nextCatchLocal = new LabelNode();
            int j = 0;
            for (FulledNameToken catchException : catchExceptions) {
                if (j > 0) {
                    this.add((AbstractInsnNode)nextCatchLocal);
                    nextCatchLocal = new LabelNode();
                }
                this.expr.writePushEnv();
                this.expr.writeVarLoad(exception);
                this.expr.writePushConstString(catchException.toName());
                this.expr.writePushConstString(catchException.toName().toLowerCase());
                this.expr.writeSysDynamicCall(Environment.class, "__throwCatch", Memory.class, BaseBaseException.class, String.class, String.class);
                this.expr.writeVarAssign(local, _catch.getVariable(), true, false);
                this.expr.writePopBoolean();
                this.add((AbstractInsnNode)new JumpInsnNode(153, j == catchExceptions.size() - 1 ? nextCatch : nextCatchLocal));
                this.expr.stackPop();
                if (catchExceptions.size() > 1) {
                    this.add((AbstractInsnNode)new JumpInsnNode(167, bodyLabel));
                }
                ++j;
            }
            if (catchExceptions.size() > 1) {
                this.add((AbstractInsnNode)bodyLabel);
            }
            this.expr.write(BodyStmtToken.class, _catch.getBody());
            this.add((AbstractInsnNode)new JumpInsnNode(167, catchEnd));
            ++i;
        }
        this.add((AbstractInsnNode)catchFail);
        if (token.getFinally() != null) {
            this.expr.write(BodyStmtToken.class, token.getFinally());
        }
        this.expr.makeVarLoad(exception);
        this.add((AbstractInsnNode)new InsnNode(191));
        this.add((AbstractInsnNode)catchEnd);
        if (token.getFinally() != null) {
            LabelNode skip = new LabelNode();
            this.add((AbstractInsnNode)new JumpInsnNode(167, skip));
            this.add((AbstractInsnNode)returnLabel);
            this.expr.write(BodyStmtToken.class, token.getFinally());
            if (this.method.getTryStack().empty()) {
                LocalVariable retVar = this.method.getOrAddLocalVariable("~result~", null, Memory.class);
                this.expr.writeVarLoad(retVar);
                this.add((AbstractInsnNode)new InsnNode(176));
                this.expr.stackPop();
            } else {
                this.add((AbstractInsnNode)new JumpInsnNode(167, this.method.getTryStack().peek().getReturnLabel()));
            }
            this.add((AbstractInsnNode)skip);
            this.expr.write(BodyStmtToken.class, token.getFinally());
        }
        this.expr.writeUndefineVariables(token.getLocal());
        this.method.prevStatementIndex(BaseBaseException.class);
    }
}

