/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.develnext.jphp.core.syntax.ExpressionInfo;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.LabelStmtToken;

public class Scope {
    protected boolean staticExists = false;
    protected Set<VariableExprToken> variables;
    protected Map<Token, ExpressionInfo> typeInfo;
    protected Map<String, LabelStmtToken> labels;
    protected final Scope parent;
    protected boolean levelForGoto = false;
    protected int cachedGotoLevel = -1;

    public Scope(Scope parent) {
        this.parent = parent;
        this.variables = new HashSet<VariableExprToken>();
        this.labels = new HashMap<String, LabelStmtToken>();
        this.typeInfo = new LinkedHashMap<Token, ExpressionInfo>();
    }

    public void appendScope(Scope scope) {
        this.variables.addAll(scope.getVariables());
        this.labels.putAll(scope.getLabels());
        this.staticExists = this.staticExists || scope.staticExists;
    }

    public Map<Token, ExpressionInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public synchronized ExpressionInfo typeInfoOf(Token token) {
        ExpressionInfo info = this.typeInfo.get(token);
        if (info == null) {
            info = new ExpressionInfo();
            this.typeInfo.put(token, info);
        }
        return info;
    }

    public Set<VariableExprToken> getVariables() {
        return this.variables;
    }

    public void addVariable(VariableExprToken var) {
        this.variables.add(var);
    }

    public void addVariables(Collection<VariableExprToken> vars) {
        this.variables.addAll(vars);
    }

    public void addLabel(LabelStmtToken labelStmtToken) {
        labelStmtToken.setLevel(this.getGotoLevel());
        this.labels.put(labelStmtToken.getName().toLowerCase(), labelStmtToken);
    }

    public Map<String, LabelStmtToken> getLabels() {
        return this.labels;
    }

    public boolean isStaticExists() {
        return this.staticExists;
    }

    public void setStaticExists(boolean staticExists) {
        this.staticExists = staticExists;
    }

    public boolean isLevelForGoto() {
        return this.levelForGoto;
    }

    public Scope setLevelForGoto(boolean applyGoto) {
        this.levelForGoto = applyGoto;
        this.cachedGotoLevel = -1;
        return this;
    }

    public int getGotoLevel() {
        if (this.cachedGotoLevel > -1) {
            return this.cachedGotoLevel;
        }
        int level = this.isLevelForGoto() ? 1 : 0;
        Scope pr = this.parent;
        while (pr != null) {
            level += pr.isLevelForGoto() ? 1 : 0;
            pr = pr.parent;
        }
        this.cachedGotoLevel = level;
        return this.cachedGotoLevel;
    }
}

