/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ListIterator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.ExprGenerator;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.DeclareStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;

public class DeclareGenerator
extends Generator<DeclareStmtToken> {
    public DeclareGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    @Override
    public DeclareStmtToken getToken(Token current, ListIterator<Token> iterator) {
        if (current instanceof DeclareStmtToken) {
            BraceExprToken token = this.nextAndExpected(iterator, BraceExprToken.class);
            if (!this.isOpenedBrace(token, BraceExprToken.Kind.SIMPLE)) {
                this.unexpectedToken(token, "(");
            }
            NameToken nameToken = this.nextAndExpected(iterator, NameToken.class);
            this.nextAndExpected(iterator, AssignExprToken.class);
            ExprStmtToken value = this.analyzer.generator(ExprGenerator.class).getInBraces(BraceExprToken.Kind.SIMPLE, iterator, true);
            if (!value.isConstantly()) {
                this.unexpectedToken(value, "constant value");
            }
            DeclareStmtToken result = (DeclareStmtToken)current;
            result.setName(nameToken);
            result.setValue(value);
            return result;
        }
        return null;
    }
}

