/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token;

import java.lang.reflect.InvocationTargetException;
import org.develnext.jphp.core.tokenizer.TokenFinder;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import php.runtime.env.Context;
import php.runtime.env.TraceInfo;

public class Token {
    protected final TokenMeta meta;
    protected final TokenType type;

    public Token(TokenMeta meta, TokenType type) {
        this.meta = meta;
        this.type = type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.meta.getWord() + "]";
    }

    public TokenType getType() {
        return this.type;
    }

    public TokenMeta getMeta() {
        return this.meta;
    }

    public TraceInfo toTraceInfo(Context context) {
        return this.getMeta().toTraceInfo(context);
    }

    public String getWord() {
        return this.getMeta().getWord();
    }

    public boolean isNamedToken() {
        return this.type == TokenType.T_STRING;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        return token.getClass() == this.getClass() && this.getWord().equals(token.getWord());
    }

    public static Token of(TokenMeta meta) {
        TokenFinder finder = new TokenFinder();
        Class<? extends Token> clazz = finder.find(meta);
        try {
            return clazz.getConstructor(TokenMeta.class).newInstance(meta);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Token of(String word) {
        return Token.of(new TokenMeta(word, 0, 0, 0, 0));
    }
}

