/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.expr;

import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.ExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.OperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ConcatExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DivExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.KeyValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MinusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ModExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MulExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.PlusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.PowExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ArrayExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.BooleanExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.DoubleExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IntegerExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.SelfExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StringExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;

public abstract class ValueExprToken
extends ExprToken {
    public ValueExprToken(TokenMeta meta, TokenType type) {
        super(meta, type);
    }

    public boolean isConstant() {
        return false;
    }

    public Object toNumeric() {
        return 0L;
    }

    protected ValueExprToken operatorResult(Object value) {
        if (value instanceof String) {
            return new StringExprToken(TokenMeta.of(value.toString(), (Token)this), StringExprToken.Quote.SINGLE);
        }
        if (value instanceof Long) {
            return new IntegerExprToken(TokenMeta.of(value.toString(), (Token)this));
        }
        if (value instanceof Double) {
            return new DoubleExprToken(TokenMeta.of(value.toString(), (Token)this));
        }
        if (value instanceof Boolean) {
            return new BooleanExprToken(TokenMeta.of((Boolean)value != false ? "true" : "false", (Token)this));
        }
        return null;
    }

    protected ValueExprToken plus(ValueExprToken value) {
        Object o1 = this.toNumeric();
        Object o2 = value.toNumeric();
        if (o1 instanceof Long && o2 instanceof Long) {
            return this.operatorResult((Long)o1 + (Long)o2);
        }
        return this.operatorResult(Double.valueOf(o1.toString()) + Double.valueOf(o2.toString()));
    }

    protected ValueExprToken minus(ValueExprToken value) {
        Object o1 = this.toNumeric();
        Object o2 = value.toNumeric();
        if (o1 instanceof Long && o2 instanceof Long) {
            return this.operatorResult((Long)o1 - (Long)o2);
        }
        return this.operatorResult(Double.valueOf(o1.toString()) - Double.valueOf(o2.toString()));
    }

    protected ValueExprToken mul(ValueExprToken value) {
        Object o1 = this.toNumeric();
        Object o2 = value.toNumeric();
        if (o1 instanceof Long && o2 instanceof Long) {
            return this.operatorResult((Long)o1 * (Long)o2);
        }
        return this.operatorResult(Double.valueOf(o1.toString()) * Double.valueOf(o2.toString()));
    }

    protected ValueExprToken pow(ValueExprToken value) {
        Object o1 = this.toNumeric();
        Object o2 = value.toNumeric();
        return this.operatorResult(Math.pow(Double.valueOf(o1.toString()), Double.valueOf(o2.toString())));
    }

    protected ValueExprToken div(ValueExprToken value) {
        Object o1 = this.toNumeric();
        Object o2 = value.toNumeric();
        double r = Double.valueOf(o1.toString()) / Double.valueOf(o2.toString());
        if (r == Math.floor(r) && !Double.isInfinite(r)) {
            return this.operatorResult((long)r);
        }
        return this.operatorResult(r);
    }

    protected ValueExprToken mod(ValueExprToken value) {
        Object o1 = this.toNumeric();
        Object o2 = value.toNumeric();
        if (o1 instanceof Long && o2 instanceof Long) {
            return this.operatorResult((Long)o1 % (Long)o2);
        }
        return this.operatorResult(Double.valueOf(o1.toString()) % Double.valueOf(o2.toString()));
    }

    protected ValueExprToken concat(ValueExprToken value) {
        return this.operatorResult(this.toString() + value.toString());
    }

    public ValueExprToken operator(ValueExprToken value, OperatorExprToken operator) {
        if (operator instanceof PlusExprToken) {
            return this.plus(value);
        }
        if (operator instanceof MinusExprToken) {
            return this.minus(value);
        }
        if (operator instanceof MulExprToken) {
            return this.mul(value);
        }
        if (operator instanceof DivExprToken) {
            return this.div(value);
        }
        if (operator instanceof PowExprToken) {
            return this.pow(value);
        }
        if (operator instanceof ModExprToken) {
            return this.mod(value);
        }
        if (operator instanceof ConcatExprToken) {
            return this.concat(value);
        }
        return null;
    }

    public static boolean isConstable(Token token, boolean arrays) {
        StaticAccessExprToken sa;
        if (token instanceof NameToken) {
            return true;
        }
        if (token instanceof IntegerExprToken) {
            return true;
        }
        if (token instanceof DoubleExprToken) {
            return true;
        }
        if (token instanceof StringExprToken && ((StringExprToken)token).getSegments().isEmpty()) {
            return true;
        }
        if (token instanceof StaticAccessExprToken && !(sa = (StaticAccessExprToken)token).isGetStaticField() && (sa.getClazz() instanceof NameToken || sa.getClazz() instanceof SelfExprToken)) {
            return true;
        }
        if (arrays && token instanceof ArrayExprToken) {
            ArrayExprToken array = (ArrayExprToken)token;
            for (ExprStmtToken e : array.getParameters()) {
                if (e.isSingle()) {
                    if (ValueExprToken.isConstable(e.getSingle(), true)) continue;
                    return false;
                }
                if (e.getTokens().size() == 3) {
                    if (e.getTokens().get(1) instanceof KeyValueExprToken && ValueExprToken.isConstable(e.getSingle(), false) && ValueExprToken.isConstable(e.getLast(), true)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

