/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXRadioButtonSkin;
import com.sun.javafx.css.converters.ColorConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class JFXRadioButton
extends RadioButton {
    private static final String DEFAULT_STYLE_CLASS = "jfx-radio-button";
    private StyleableObjectProperty<Color> selectedColor = new SimpleStyleableObjectProperty(StyleableProperties.access$000(), (Object)this, "selectedColor", (Object)Color.valueOf((String)"#0F9D58"));
    private StyleableObjectProperty<Color> unSelectedColor = new SimpleStyleableObjectProperty(StyleableProperties.access$100(), (Object)this, "unSelectedColor", (Object)Color.valueOf((String)"#5A5A5A"));
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXRadioButton(String text) {
        super(text);
        this.initialize();
    }

    public JFXRadioButton() {
        this.initialize();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElements.length && i < 15; ++i) {
            if (!stackTraceElements[i].getClassName().toLowerCase().contains(".scenebuilder.kit.fxom.")) continue;
            this.setText("RadioButton");
            break;
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXRadioButtonSkin(this);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final StyleableObjectProperty<Color> selectedColorProperty() {
        return this.selectedColor;
    }

    public final Color getSelectedColor() {
        return this.selectedColor == null ? Color.rgb((int)0, (int)0, (int)0, (double)0.2) : (Color)this.selectedColorProperty().get();
    }

    public final void setSelectedColor(Color selectedColor) {
        this.selectedColorProperty().set((Object)selectedColor);
    }

    public final StyleableObjectProperty<Color> unSelectedColorProperty() {
        return this.unSelectedColor;
    }

    public final Color getUnSelectedColor() {
        return this.unSelectedColor == null ? Color.TRANSPARENT : (Color)this.unSelectedColorProperty().get();
    }

    public final void setUnSelectedColor(Color unSelectedColor) {
        this.unSelectedColorProperty().set((Object)unSelectedColor);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.addAll(JFXRadioButton.getClassCssMetaData());
            styleables.addAll(Labeled.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXRadioButton, Color> SELECTED_COLOR = new CssMetaData<JFXRadioButton, Color>("-jfx-selected-color", ColorConverter.getInstance(), Color.valueOf((String)"#0F9D58")){

            public boolean isSettable(JFXRadioButton control) {
                return control.selectedColor == null || !control.selectedColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(JFXRadioButton control) {
                return control.selectedColorProperty();
            }
        };
        private static final CssMetaData<JFXRadioButton, Color> UNSELECTED_COLOR = new CssMetaData<JFXRadioButton, Color>("-jfx-unselected-color", ColorConverter.getInstance(), Color.valueOf((String)"#5A5A5A")){

            public boolean isSettable(JFXRadioButton control) {
                return control.unSelectedColor == null || !control.unSelectedColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(JFXRadioButton control) {
                return control.unSelectedColorProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return SELECTED_COLOR;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNSELECTED_COLOR;
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, SELECTED_COLOR, UNSELECTED_COLOR);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

