/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXScrollPane$$Lambda$1;
import com.jfoenix.controls.JFXScrollPane$$Lambda$2;
import com.jfoenix.controls.JFXScrollPane$$Lambda$3;
import com.jfoenix.controls.JFXScrollPane$$Lambda$4;
import com.jfoenix.controls.JFXScrollPane$$Lambda$5;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

@DefaultProperty(value="content")
public class JFXScrollPane
extends StackPane {
    private static final String DEFAULT_STYLE_CLASS = "jfx-scroll-pane";
    private final VBox contentContainer = new VBox();
    private final StackPane headerSpace = new StackPane();
    private final StackPane condensedHeaderBackground = new StackPane();
    private final StackPane headerBackground = new StackPane();
    private double initY = -1.0;
    private double maxHeight = -1.0;
    private double minHeight = -1.0;
    private final StackPane bottomBar;
    private final Scale scale = new Scale(1.0, 1.0, 0.0, 0.0);
    private Transform oldSceneTransform = null;
    private final StackPane midBar;
    private final StackPane topBar;

    public JFXScrollPane() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        Rectangle clip = new Rectangle();
        this.setClip((Node)clip);
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.condensedHeaderBackground.setOpacity(0.0);
        this.condensedHeaderBackground.getStyleClass().add((Object)"condensed-header");
        this.condensedHeaderBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#1E88E5"), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.headerBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#3949AB"), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.headerBackground.getStyleClass().add((Object)"main-header");
        StackPane bgContainer = new StackPane();
        bgContainer.getChildren().setAll((Object[])new Node[]{this.condensedHeaderBackground, this.headerBackground});
        bgContainer.setMouseTransparent(true);
        this.topBar = new StackPane();
        this.topBar.setPickOnBounds(false);
        this.topBar.setMaxHeight(64.0);
        this.midBar = new StackPane();
        this.midBar.setMaxHeight(64.0);
        this.midBar.setPickOnBounds(false);
        this.bottomBar = new StackPane();
        this.bottomBar.setMaxHeight(64.0);
        this.bottomBar.getTransforms().add((Object)this.scale);
        this.scale.pivotYProperty().bind((ObservableValue)this.bottomBar.heightProperty().divide(2));
        this.bottomBar.setPickOnBounds(false);
        StackPane barsContainer = new StackPane(new Node[]{this.topBar, this.midBar, this.bottomBar});
        StackPane.setAlignment((Node)this.topBar, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)this.bottomBar, (Pos)Pos.BOTTOM_CENTER);
        StackPane header = new StackPane();
        header.setPrefHeight(192.0);
        header.maxHeightProperty().bind((ObservableValue)header.prefHeightProperty());
        header.getChildren().setAll((Object[])new Node[]{bgContainer, barsContainer});
        StackPane.setAlignment((Node)header, (Pos)Pos.TOP_CENTER);
        this.headerSpace.minHeightProperty().bind((ObservableValue)header.prefHeightProperty());
        this.headerSpace.maxHeightProperty().bind((ObservableValue)header.prefHeightProperty());
        this.headerSpace.setFocusTraversable(true);
        this.contentContainer.getChildren().setAll((Object[])new Node[]{this.headerSpace});
        this.contentContainer.localToSceneTransformProperty().addListener(JFXScrollPane$$Lambda$1.lambdaFactory$(this));
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.contentContainer);
        scrollPane.setFitToWidth(true);
        scrollPane.vvalueProperty().addListener(JFXScrollPane$$Lambda$2.lambdaFactory$(this, header));
        scrollPane.setPannable(true);
        this.getChildren().setAll((Object[])new Node[]{scrollPane, header});
    }

    private double map(double val, double min1, double max1, double min2, double max2) {
        return min2 + (max2 - min2) * ((val - min1) / (max1 - min1));
    }

    public void setContent(Node content) {
        if (this.contentContainer.getChildren().size() == 2) {
            this.contentContainer.getChildren().set(1, (Object)content);
        } else if (this.contentContainer.getChildren().size() == 1) {
            this.contentContainer.getChildren().add((Object)content);
        } else {
            this.contentContainer.getChildren().setAll((Object[])new Node[]{this.headerSpace, content});
        }
        VBox.setVgrow((Node)content, (Priority)Priority.ALWAYS);
    }

    public Node getContent() {
        return this.contentContainer.getChildren().size() == 2 ? (Node)this.contentContainer.getChildren().get(1) : null;
    }

    public StackPane getTopBar() {
        return this.topBar;
    }

    public StackPane getMidBar() {
        return this.midBar;
    }

    public StackPane getBottomBar() {
        return this.bottomBar;
    }

    public StackPane getMainHeader() {
        return this.headerBackground;
    }

    public StackPane getCondensedHeader() {
        return this.condensedHeaderBackground;
    }

    public static void smoothScrolling(ScrollPane scrollPane) {
        double[] frictions = new double[]{0.99, 0.1, 0.05, 0.04, 0.03, 0.02, 0.01, 0.04, 0.01, 0.008, 0.008, 0.008, 0.008, 6.0E-4, 5.0E-4, 3.0E-5, 1.0E-5};
        double[] pushes = new double[]{1.0};
        double[] derivatives = new double[frictions.length];
        Timeline timeline = new Timeline();
        scrollPane.getContent().addEventHandler(MouseEvent.DRAG_DETECTED, JFXScrollPane$$Lambda$3.lambdaFactory$(timeline));
        scrollPane.getContent().addEventHandler(ScrollEvent.ANY, JFXScrollPane$$Lambda$4.lambdaFactory$(pushes, derivatives, timeline));
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)3.0), JFXScrollPane$$Lambda$5.lambdaFactory$(derivatives, frictions, scrollPane, timeline), new KeyValue[0]));
        timeline.setCycleCount(-1);
    }

    static /* synthetic */ void lambda$smoothScrolling$4(double[] derivatives, double[] frictions, ScrollPane scrollPane, Timeline timeline, ActionEvent event) {
        int i;
        for (i = 0; i < derivatives.length; ++i) {
            int n = i;
            derivatives[n] = derivatives[n] * frictions[i];
        }
        for (i = 1; i < derivatives.length; ++i) {
            int n = i;
            derivatives[n] = derivatives[n] + derivatives[i - 1];
        }
        double dy = derivatives[derivatives.length - 1];
        double height = scrollPane.getContent().getLayoutBounds().getHeight();
        scrollPane.setVvalue(Math.min(Math.max(scrollPane.getVvalue() + dy / height, 0.0), 1.0));
        if (Math.abs(dy) < 0.001) {
            timeline.stop();
        }
    }

    static /* synthetic */ void lambda$smoothScrolling$3(double[] pushes, double[] derivatives, Timeline timeline, ScrollEvent event) {
        if (event.getEventType() == ScrollEvent.SCROLL) {
            int direction = event.getDeltaY() > 0.0 ? -1 : 1;
            for (int i = 0; i < pushes.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] + (double)direction * pushes[i];
            }
            if (timeline.getStatus() == Animation.Status.STOPPED) {
                timeline.play();
            }
            event.consume();
        }
    }

    static /* synthetic */ void lambda$smoothScrolling$2(Timeline timeline, MouseEvent event) {
        timeline.stop();
    }

    static /* synthetic */ void lambda$new$1(JFXScrollPane this_, StackPane header, ObservableValue o, Number oldVal, Number newVal) {
        double ty;
        double opacity;
        if (this_.minHeight == -1.0) {
            this_.minHeight = this_.bottomBar.getBoundsInParent().getMinY();
            this_.maxHeight = header.getHeight();
        }
        if (this_.initY == -1.0) {
            this_.initY = this_.oldSceneTransform.getTy();
        }
        opacity = (opacity = Math.abs((ty = this_.contentContainer.getLocalToSceneTransform().getTy()) - this_.initY) / this_.minHeight) > 1.0 ? 1.0 : (opacity < 0.0 ? 0.0 : opacity);
        this_.headerBackground.setOpacity(1.0 - opacity);
        this_.condensedHeaderBackground.setOpacity(opacity);
        if (newVal.doubleValue() == 0.0) {
            header.setTranslateY(0.0);
            this_.topBar.setTranslateY(0.0);
        } else if (newVal.doubleValue() == 1.0) {
            this_.topBar.setTranslateY(this_.minHeight);
            header.setTranslateY(-this_.maxHeight);
        } else {
            double dy = ty - this_.initY;
            this_.topBar.setTranslateY(-dy <= this_.minHeight ? -dy : this_.minHeight);
            double oldTy = this_.oldSceneTransform.getTy();
            double diff = oldTy - ty;
            if (-dy > this_.minHeight && newVal.doubleValue() < oldVal.doubleValue()) {
                if (-(header.getTranslateY() - diff) > this_.minHeight) {
                    header.setTranslateY(header.getTranslateY() - diff);
                } else {
                    header.setTranslateY(-this_.minHeight);
                }
            } else if (-dy > this_.maxHeight) {
                if (-(header.getTranslateY() - diff) < this_.maxHeight) {
                    header.setTranslateY(header.getTranslateY() - diff);
                } else {
                    header.setTranslateY(-this_.maxHeight);
                }
            } else if (diff > this_.maxHeight) {
                header.setTranslateY(-this_.maxHeight);
            } else {
                header.setTranslateY(dy);
            }
        }
        this_.scale.setX(this_.map(opacity, 0.0, 1.0, 1.0, 0.75));
        this_.scale.setY(this_.map(opacity, 0.0, 1.0, 1.0, 0.75));
    }

    static /* synthetic */ void lambda$new$0(JFXScrollPane this_, ObservableValue o, Transform oldVal, Transform newVal) {
        this_.oldSceneTransform = oldVal;
    }
}

